# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):

    def execute(self):
        # 查询系统告警信息
        alarm_infos = self.dsl("exec_cli 'show alarm' | horizontal_parser")
        # 存在告警ID为0xF00CF009C，则检查不通过
        for alarm_info in alarm_infos:
            if alarm_info.get("ID", "").strip() == "0xF00CF009C":
                return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion")
        return CheckStatus.PASS, ""
