# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl import fault_mode as ft


class CheckItem(BaseCheckItem):
    def execute(self):

        # 检查方法步骤1：使用dsl执行命令查询fs_migration信息
        migration_info = self.dsl("exec_cli 'show fs_migration general' | horizontal_parser",
                                  return_if={ft.FindStr("Error:"): "error occur"})

        if migration_info == "error occur":
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        if not migration_info:
            self.logger.info("this info NULL")
            return CheckStatus.PASS, ""
        else:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
