# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.protocol.cli_common import get_system_version_without_ret
from psdk.platform.util.product_util import compare_patch_version


class CheckItem(BaseCheckItem):
    def execute(self):
        if self.check_version():
            return CheckStatus.PASS, ""

        if self.check_lun_failed():
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")

        if self.check_fs_failed():
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""

    def check_version(self):
        # 获取版本信息
        flag, software_version, hot_patch_version = \
            get_system_version_without_ret(self.dsl("exec_cli 'show upgrade package'"))
        if any([software_version == "6.0.1" and compare_patch_version(hot_patch_version, "SPH28") >= 0,
                software_version == "6.1.0" and compare_patch_version(hot_patch_version, "SPH19") >= 0,
                software_version == "6.1.2" and compare_patch_version(hot_patch_version, "SPH8") >= 0]):
            return True
        return False

    def check_lun_failed(self):
        lun_informations = self.dsl("exec_developer 'show lun general |filterRow column=Capacity predict=greater_equal"
                                    " value=32T'"
                                    " | horizontal_parser")
        lun_ids = [item.get("ID") for item in lun_informations]
        for lun_id in lun_ids:
            lun_details = self.dsl("exec_developer 'show lun general lun_id={}'"
                                   " | vertical_parser".format(lun_id))
            for lun_detail in lun_details:
                if any([lun_detail.get("Snapshot ID(s)") != "--",
                        lun_detail.get("Remote Replication ID(s)") != "--",
                        lun_detail.get("HyperMetro ID(s)") != "--",
                        lun_detail.get("Is Clone").lower() == "yes"]):
                    return True
        return False

    def check_fs_failed(self):
        fs_informations = self.dsl("exec_developer 'show file_system general |filterRow column=Capacity"
                                   " predict=greater_equal value=32T'"
                                   " | horizontal_parser")
        fs_ids = [item.get("ID") for item in fs_informations]
        for fs_id in fs_ids:
            fs_details = self.dsl("exec_developer 'show file_system general file_system_id={}'"
                                  " | vertical_parser".format(fs_id))
            for fs_detail in fs_details:
                if any([fs_detail.get("Clone") == "yes",
                        fs_detail.get("Remote Replication ID(s)") != "--",
                        fs_detail.get("Hyper Metro Pair ID(s)") != "--"]):
                    return True
            snap_informations = self.dsl("exec_developer 'show fs_snapshot general file_system_id={}'"
                                         "| horizontal_parser".format(fs_id))
            if snap_informations:
                return True
        return False
