# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.checkitem.scripts import zero_op_disk_comm
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):
    def execute(self):

        if not zero_op_disk_comm.judge_patch_version(self.dsl):
            return CheckStatus.PASS, ""
        op_disk_cnt = zero_op_disk_comm.calc_zero_op_disk(self.dsl)
        if op_disk_cnt > 0:
            return CheckStatus.NOT_PASS, self.get_msg("item.suggestion")
        else:
            exp_disk_list = self.context.execute_env.ori_env.get("exp_disk_list")
            if not exp_disk_list:
                exp_disk_list = self.context.execute_env.ori_env.get("expDiskList")
            if not exp_disk_list:
                return CheckStatus.PASS, ""

            exp_disk_in_domain = {}
            for exp_disk in exp_disk_list:
                domain_id = exp_disk["diskDomain"]
                disk_num = int(exp_disk["diskNum"])
                disk_num_sum = disk_num
                if domain_id in exp_disk_in_domain:
                    disk_num_sum = exp_disk_in_domain[domain_id] + disk_num_sum
                if disk_num_sum >= 90:  # 判断规则阈值 90块盘
                    return CheckStatus.NOT_PASS, self.get_msg("item.suggestion")
                else:
                    exp_disk_in_domain[domain_id] = disk_num_sum

        return CheckStatus.PASS, ""
