# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.tool.obase.entity import EntityUtils
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus

# 屏蔽告警列表
DM_CERT_ALARM_ID_LIST = ["0xF03320002", "0xF03320003"]


def get_certificate_fingerprint(dev_node):
    return RestUtil.getSslFingerprint(dev_node)


class CheckItem(BaseCheckItem):

    def execute(self):
        if self.check_alarm_mask_status():
            return CheckStatus.PASS, ""

        origin_dev = self.context.get_dev_node().origin_dev
        old_dev = EntityUtils.toOldDev(origin_dev)
        fingerprint = get_certificate_fingerprint(old_dev)
        if not fingerprint:
            return CheckStatus.NOT_CHECK, self.get_msg("query.result.abnormal")
        expire_risk_fingerprints = [
            "60:02:EB:42:3F:DB:71:BA:85:E6:10:C8:14:1E:72:27:7C:7D:38:16",
            "81:4D:66:AA:59:B0:37:99:C7:AA:D9:E3:50:9D:4E:88:6F:2E:DD:8F",
            "69:0F:06:30:8B:BA:60:BA:B6:8D:9D:AE:BD:AD:56:73:DF:E4:80:97"
        ]
        if fingerprint in expire_risk_fingerprints:
            return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""

    def check_alarm_mask_status(self):
        # 判断当前设备是否屏蔽了对应告警
        return any(self.dsl("exec_cli 'show alarm_mask|filterRow column=Alarm ID predict=equal_to value=%s' |"
                            "horizontal_parser" % alarm_id) for alarm_id in DM_CERT_ALARM_ID_LIST)