# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
from com.huawei.ism.tool.obase.entity import EntityUtils
from com.huawei.ism.ui.swing.dialog import DialogUtils
from com.huawei.ism.tool.bizpack.wizardparse.context import BizPackageContext
from com.huawei.ism.ui.swing.dialog import WarningDialog
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


def get_certificate_fingerprint(dev_node):
    return RestUtil.getSslFingerprint(dev_node)


class CheckItem(BaseCheckItem):

    def execute(self):
        origin_dev = self.context.get_dev_node().origin_dev
        old_dev = EntityUtils.toOldDev(origin_dev)
        fingerprint = get_certificate_fingerprint(old_dev)
        if not fingerprint:
            return CheckStatus.NOT_CHECK, self.get_msg("query.result.abnormal")
        defualt_devicemanager_cert_fingerprints = [
            "60:02:EB:42:3F:DB:71:BA:85:E6:10:C8:14:1E:72:27:7C:7D:38:16",
            "81:4D:66:AA:59:B0:37:99:C7:AA:D9:E3:50:9D:4E:88:6F:2E:DD:8F",
            "69:0F:06:30:8B:BA:60:BA:B6:8D:9D:AE:BD:AD:56:73:DF:E4:80:97",
            "AD:E5:1A:19:97:AA:BA:AF:20:25:18:84:CC:6E:EF:CA:F5:6B:2A:CA",
            "28:5C:56:C7:9C:0D:E1:89:7D:F2:51:99:3A:3A:9E:80:81:CD:EA:F5"
        ]
        new_devicemanager_cert_fingerprints = [
            "07:15:11:F2:82:C1:64:9A:C6:34:73:FC:1A:AF:DD:FA:56:27:C5:A4",
        ]
        cert_file_flag = "CertFlag"
        if fingerprint in new_devicemanager_cert_fingerprints:
            parent = BizPackageContext.getInstance().getWizard()
            warning_dialog = DialogUtils.showWarnConfirmDialog(parent, self.get_msg("check.not.pass.new"),
                                                               self.get_msg("check.not.pass.confirm"))
            if warning_dialog.getValue() != WarningDialog.YES_OPTION:
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass.new")
            self.context.execute_env.ori_env.put(cert_file_flag, "NewHuawei")
            self.logger.info("[fru pre check dm] current restflag is CertFlag: NewHuawei.")
            return CheckStatus.PASS, ""
        
        if fingerprint not in defualt_devicemanager_cert_fingerprints:
            parent = BizPackageContext.getInstance().getWizard()
            warning_dialog = DialogUtils.showWarnConfirmDialog(parent, self.get_msg("check.not.pass.defualt"),
                                                               self.get_msg("check.not.pass.confirm"))
            if warning_dialog.getValue() != WarningDialog.YES_OPTION: 
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass.defualt")
            self.logger.info("[fru pre check dm] current restflag is CertFlag: NewNoHuawei.")
            self.context.execute_env.ori_env.put(cert_file_flag, "NewNoHuawei")
            return CheckStatus.PASS, ""
        self.logger.info("[fru pre check dm] current restflag is CertFlag: No.")
        self.context.execute_env.ori_env.put(cert_file_flag, "No")
        return CheckStatus.PASS, ""
