# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.
import re
import traceback
import ast
import os
import time
import traceback
import cert_uitls

import cbb.business.operate.fru.common.BaseFactory as BaseFactory
import cbb.business.operate.fru.common.SftpFactory as SftpFactory
import cbb.business.operate.fru.common.resource as resource
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil
import com.huawei.ism.tool.obase.connection.SftpTransporter as SftpCls

from com.huawei.ism.tool.obase.entity import EntityUtils
from com.huawei.ism.ui.swing.dialog import DialogUtils
from com.huawei.ism.tool.bizpack.wizardparse.context import BizPackageContext
from com.huawei.ism.ui.swing.dialog import WarningDialog
from com.huawei.ism.tool.obase.exception import ToolException
from com.huawei.ism.tool.protocol.factory import SftpConnector as SftpConn
from cbb.frame.base.baseUtil import is_dorado_v3
from cbb.frame.cli import cliUtil
from cbb.frame.context import contextUtil
from com.huawei.ism.tool.service.cert.fru import CertFileService
from java.lang import Exception as JException
from psdk.dsl.adapter import dsl_adapter
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.protocol.cli_con_mgr import get_ctrl_cli, create_cli_connection, close_cli_connection
from psdk.platform.protocol.cli_con_mgr import get_available_conn
from psdk.platform.protocol.cli_service import enter_developer_from_cli


ALL_CLI_RET = "allCliRet"
CMD_HEAD = "import ssl_certificate ip={} "

# 控制器名称和节点对应关系
CTRL_NODE_MAP = {
    "A": 0,
    "B": 1,
    "C": 2,
    "D": 3
}

# V5R7补丁版本
V5R7_VERSION_AND_PATCH = (
    "V500R007C60SPC100 Kunpeng", "V500R007C60SPC300 Kunpeng", "V500R007C71SPC100 Kunpeng", "V500R007C73SPC100 Kunpeng"
)

ENGINE_REGX = re.compile("CTE(\d+)")
PORT_REGX = re.compile("Port Number\s*:\s*(\d+)")


def get_certificate_fingerprint(dev_node):
    return RestUtil.getSslFingerprint(dev_node)


def get_upload_cert_file_assist():
    """
    获得证书设备管理
    :return: 设备管理实例
    """
    from com.huawei.ism.tool.service.cert.upload import UploadCertFileInPythonAssist
    return UploadCertFileInPythonAssist


class CheckItem(BaseCheckItem):
    """
    初始证书替换工具前置检查
    """
    def __init__(self, context) :
        super(CheckItem, self).__init__(context)
        self.cli = None
        self.is_nat = False
        self.error_msg = ""
        self.all_ret = ""
        self.data = {}
        self.engine_id = "" # 替换节点的引擎ID
        self.node_id = "" # 替换节点的nodeid
        self.upload_failed_engine = []
        self.replace_failed_ctrl = []
        self.replace_successfully_ctrl = []
        self.uploaded_ctrl_ips = []
        self.engine_controller_info_tuple = None
        self.ip = self.context.dev_node.ip
        self.map = CertFileService.replaceDMCertInfo(self.context.java_dev)
        self.local_file_path_list = self.map.get("localFilePathList")
        self.server_path = self.map.get("serverPath")
        self.cmd = self.map.get("cmd")
        self.importssl = ""
        self.product_version = self.map.get("productVersion")
        self.is_ip_v6 = cert_uitls.is_ip_v6(self.ip)
        self.all_valied_ip = None

    @staticmethod
    def get_ip_info(ip_str, temp_ip_map, ip_type):
        if ip_str and ip_str != '--':
            temp_ipv4 = temp_ip_map.get(ip_type, [])
            temp_ipv4.append(ip_str)
            temp_ip_map[ip_type] = temp_ipv4

    def pre_check_execute(self):
        self.cli = dsl_adapter.get_con(self.context)
        if not self.is_supper_admin() or not self.check_space_char():
            self.data["allCliRet"] = self.all_ret
            self.logger.info("[ReplaceDMCert] check admin failed or space char password")
            return False, self.error_msg, self.data
        self.is_nat = cert_uitls.is_nat_network(self.dsl, self.context)
        self.logger.info("[ReplaceDMCert] is nat network:{}".format(self.is_nat))
        self.set_new_ssh_port()
        self.check_management_ip()
        self.data["allCliRet"] = self.all_ret
        return self.error_msg == "", self.error_msg, self.data


    def check_space_char(self):
        # 密码中包含空格或空格转义符，检查不通过。
        space_char_list = [" ", r"\s"]
        origin_str = str(self.context.get_dev_node().password)
        for space_char in space_char_list:
            if space_char in origin_str:
                self.error_msg = "preCheck.not.pass.space.char.exist"
                return False
        return True

    def set_new_ssh_port(self):
        cmd = "show system server_port server_name=SSH"
        _, ret, _ = cliUtil.execCmdInCliMode(self.cli, cmd, True, self.lang)
        self.add_all_ret(ret)
        res = PORT_REGX.findall(ret)
        if not res:
            self.logger.error("[Post_Check] Not found new ssh port.")
            return
        port_num = res[0]
        if port_num != "22":
            self.data["storageNewSshPort"] = port_num

    def check_management_ip(self):
        """
        检查每个引擎上是否至少有一个控制器管理ip可连通
        """
        # 获取引擎id
        flag, ret, _, engine_id_list = cliUtil.getEngineIdList(self.cli, self.lang)
        self.add_all_ret(ret)
        if not flag:
            self.logger.error("[Post_Check][Check_Management_IP]Failed to get engine ids on {}.".format(self.ip))
            self.error_msg = "preCheck.not.complete"
            return

        # 单引擎设备, 当前管理网口可以建立sftp时，判断添加的设备IP是否为存储配置的IP，如果是则设置内部IP。
        # ssh跳转场景 管理IP和存储配置的是一致的。不会误修改 命令执行的IP参数。
        if cert_uitls.is_single_engine(engine_id_list):
            self.logger.info("[Post_Check][Check_Management_IP] is single engine and not run in svp. go on check sftp")
            if not self.check_sftp_can_connect(self.context.get_dev_node().ip):
                self.logger.error("[Post_Check][Check_Management_IP]Failed to create sftp conn {}.".format(self.ip))
                self.error_msg = "preCheck.check.management.ip.sftp.conn.failed"
                return
            self.logger.info("[Post_Check][Check_Management_IP] single engine. check sftp conn succ!")
            if self.is_nat:
                self.logger.info("[Post_Check][Check_Management_IP] single engine support nat network!")
                if not self.set_current_node_inner_ip():
                    self.error_msg = "preCheck.check.management.ip.nat.network.set.ctrl.ip.failed"
            return

        # 多引擎的 DM 证书替换直接报错。
        if self.is_nat:
            self.logger.error(
                "[Post_Check][Check_Management_IP] NAT network not support DM replace.")
            self.error_msg = "preCheck.check.management.ip.nat.network.not.support.dm.replace"
            return

        # 暂不支持Dorado V3设备三引擎及以上的组网配置替换DeviceManager证书
        if is_dorado_v3(self.context.dev_node.model) and len(engine_id_list) > 2:
            self.error_msg = "preCheck.check.management.ip.doradoV3.not.config"
            return

        # 获取控制器ip和name
        flag, ret, _, ctrl_ip_name_dict = cliUtil.get_ctrl_ip_name_dict(self.cli, self.lang)
        self.add_all_ret(ret)
        if not flag:
            self.logger.error("[Post_Check][Check_Management_IP]Failed to get ctrl ips on {}.".format(self.ip))
            self.error_msg = "preCheck.not.complete"
            return

        self.save_engine_and_inner_ip(ctrl_ip_name_dict, engine_id_list)

    def save_engine_and_inner_ip(self, ctrl_ip_name_dict, engine_id_list):
        # 保存引擎与控制器ip对应关系
        engine_id_ctrl_ip_list_dict = {}
        for engine_id in engine_id_list:
            engine_id_ctrl_ip_list_dict[engine_id[-1:]] = []
        for ctrl_ip, ctrl_name in ctrl_ip_name_dict.items():
            engine_id = ctrl_name[:1]
            engine_id_ctrl_ip_list_dict.get(engine_id, []).append(ctrl_ip)
        self.logger.info(
            "[Post_Check][Check_Management_IP] ctrl_ip_name_dict:{}, engine_id_ctrl_ip_list_dict:{}".format(
                ctrl_ip_name_dict, engine_id_ctrl_ip_list_dict))
        # 检查每个引擎上是否至少有一个控制器管理ip可连通
        no_management_ip_engines = []
        for engine_id, ctrl_ip_list in engine_id_ctrl_ip_list_dict.items():
            for ctrl_ip in ctrl_ip_list:
                if self.check_ip_can_connect(ctrl_ip):
                    self.logger.info(
                        "[Post_Check][Check_Management_IP] check_ip_can_connect check success break:{}".format(ctrl_ip)
                    )
                    break
                else:
                    no_management_ip_engines.append(engine_id)
                    self.logger.error(
                        "[Post_Check][Check_Management_IP]"
                        "Engine {} on device {} has no management ip can be connected.".format(engine_id, self.ip))

        self.logger.info("[Post_Check][Check_Management_IP] no_management_ip_engines:{}".format(
            no_management_ip_engines))
        # 当show upgrade package不通时，使用show system management_ip 查询存储管理IP。并检查每个引擎是否有可用IP。
        if no_management_ip_engines:
            flag, engine_valid_ip = self.get_system_management_ip(engine_id_list)
            self.logger.info("valid engine ip is:{}".format(engine_valid_ip))
            if not flag:
                self.error_msg = "preCheck.check.management.ip.not.config"
                return
            self.all_valied_ip = engine_valid_ip

    def get_system_management_ip(self, engine_id_list):
        """
        需要解析出每个引擎的IPV4 和 IPV6，并检查每个IP是否能够建立 cli 和 sftp 连接
        """
        cmd = "show system management_ip"
        flag, ret, _ = cliUtil.execCmdInCliMode(self.cli, cmd, True, self.lang)
        if flag is not True:
            self.error_msg = "preCheck.not.complete"
            self.logger.error("[Post_Check][Check_User_Privilege]Failed to get login user info on {}.".format(self.ip))
            return False, {}
        self.add_all_ret(ret)
        engine_ips = self.get_engine_ips(cliUtil.getVerticalCliRet(ret))
        self.logger.info("engine_ips:{}".format(engine_ips))
        return self.check_sys_management_ip(engine_id_list, engine_ips)

    def check_sys_management_ip(self, engine_id_list, engine_ips):
        engine_valid_ip = {}
        for engine in engine_id_list:
            engine_id = ENGINE_REGX.findall(engine)[0]
            if engine_id not in engine_ips:
                return False, engine_valid_ip
            engine_ip_dict = engine_ips.get(engine_id, {})
            if not engine_ip_dict:
                return False, engine_valid_ip
            ip_type = "ipv6" if self.is_ip_v6 else "ipv4"
            ip_list = engine_ip_dict.get(ip_type, [])
            valid_ip = self.get_valid_ip(ip_list)
            if not valid_ip:
                return False, engine_valid_ip
            engine_valid_ip[engine_id] = valid_ip
        return True, engine_valid_ip

    def get_valid_ip(self, ip_list):
        valid_ip = ""
        for ip in ip_list:
            if self.check_ip_can_connect(ip):
                valid_ip = ip
                break
        return valid_ip

    def get_engine_ips(self, res_list):
        """
        解析获取每个引擎下得IPV4 和 IPV6 地址
        """
        engine_ips = {}
        for record in res_list:
            engin_id_res = ENGINE_REGX.findall(record.get("Port ID", ""))
            if not engin_id_res:
                continue
            engine_id = engin_id_res[0]
            temp_ip_map = engine_ips.get(engine_id, {})
            self.get_ip_info(record.get("IPv4 Address", ""), temp_ip_map, "ipv4")
            self.get_ip_info(record.get("IPv6 Address", ""), temp_ip_map, "ipv6")
            engine_ips[engine_id] = temp_ip_map
        self.logger.info("engines ip map is:{}".format(engine_ips))
        return engine_ips

    def check_ip_can_connect(self, ctrl_ip):
        cli_connection = None
        try:
            cli_connection = create_cli_connection(self.context, ctrl_ip)
            if not cli_connection:
                self.logger.info("check_ip_can_connect {} cli_connection is None, build error!!".format(ctrl_ip))
                return False
            self.logger.info("check_ip_can_connect cli_connection:{}".format(cli_connection))
            return self.check_sftp_can_connect(ctrl_ip)
        except (ToolException, Exception):
            self.logger.info("check_ip_can_connect res false:{}".format(ctrl_ip))
            self.logger.error(traceback.format_exc())
            return False
        finally:
            if cli_connection:
                cli_connection.close()

    def check_sftp_can_connect(self, ip):
        sftp_connection = None
        try:
            cert_dev_node = EntityUtils.toOldDev(self.context.java_dev)
            sftp_connection = SftpConn(cert_dev_node).getConnection()
            sftp_connection.prepareSessionWithDefault(cert_dev_node.getLoginUser(), ip,
                                                      cert_dev_node.getPort())
            return True
        except (JException, Exception):
            self.logger.error(traceback.format_exc())
            return False
        finally:
            if sftp_connection:
                sftp_connection.closeConnection()

    def set_current_node_inner_ip(self):
        """
        设置内部控制器内部IP
        """
        if cert_uitls.is_kunpeng(self.context.get_dev_node().version):
            return self.set_kunpeng_ctrl_ip()

        flag, ret, _, engine_controller_info_tuple = cliUtil.getControllerEngineTopography(self.cli, self.lang)
        self.add_all_ret(ret)
        if not flag:
            self.logger.error("[ReplaceDMCert]execute cmd failed")
            cliUtil.enterCliModeFromSomeModel(self.cli, self.lang)
            return False

        node_id = engine_controller_info_tuple[1]
        inner_ip = cert_uitls.get_inner_ip(self.context, self.cli, node_id)
        if not inner_ip:
            self.logger.error("[Post_Check]get node inner ip error!")
            return False
        self.data["nodeInnerIp"] = inner_ip[0]
        self.logger.info("[Post_Check] get node inner ip is:{}".format(inner_ip))
        return True

    def set_kunpeng_ctrl_ip(self):
        """
        kunpeng版本获取当前节点对应的控制器管理IP
        """
        flag, ctrl_name_ip_dict, engine_ctrl_name_list = cert_uitls.get_ctrl_name_ip_dict(self.cli, self.lang)
        if not flag:
            self.logger.error("[ReplaceDMCert]execute cmd failed")
            cliUtil.enterCliModeFromSomeModel(self.cli, self.lang)
            return False

        flag, ret, _, engine_controller_info_tuple = cliUtil.getControllerEngineTopography(self.cli, self.lang)
        cliUtil.enterCliModeFromSomeModel(self.cli, self.lang)
        self.add_all_ret(ret)
        if not flag:
            self.logger.error("[ReplaceDMCert]execute cmd failed")
            return False

        node_id = engine_controller_info_tuple[1]
        engine_node_max = max([len(node_list) for engin_id, node_list in engine_ctrl_name_list.items()])
        self.logger.info("[Post_Check] set_kunpeng_ctrl_ip engine_node_max:{}, node_id:{}".format(
            engine_node_max, node_id))
        for ctrl_id, ip_str in ctrl_name_ip_dict.items():
            engine = int(ctrl_id[0])
            node_value = CTRL_NODE_MAP.get(ctrl_id[1]) + engine * engine_node_max
            self.logger.info(
                "[Post_Check] set_kunpeng_ctrl_ip ctrl_id:{}, ip:{}, node_value:{}, debug node_id:{}".format(
                    ctrl_id, ip_str, node_value, node_id))
            if int(node_id) == node_value and ip_str and ip_str != "--":
                self.logger.info("[Post_Check] set_kunpeng_ctrl_ip ip:{}".format(ip_str))
                self.data["nodeInnerIp"] = ip_str
                return True
        self.logger.info("[Post_Check] set_kunpeng_ctrl_ip failed!")
        return False

    def add_all_ret(self, ret):
        self.all_ret += ret + "\n"

    def add_replace_status(self):
        replace_successfully_nodes = ["node " + node_id for node_id in sorted(self.replace_successfully_ctrl)]
        replace_failed_nodes = ["node " + node_id for node_id in sorted(self.replace_failed_ctrl)]
        self.data["replaceSuccessfullyCtrl"] = ", ".join(replace_successfully_nodes)
        self.data["replaceFailedCtrl"] = ", ".join(replace_failed_nodes)

    def upload_to_all_engine(self):
        """
        上传到指定引擎
        1.获取当前所在引擎
        2.获取所有引擎和管理IP的映射关系
        3.通过管理IP上传到当前引擎，并保存当前节点和上传节点的内部IP
        """

        # 获取当前引擎ID
        flag, ret, _, self.engine_controller_info_tuple = cliUtil.getControllerEngineTopography(self.cli, self.lang)
        current_engine_id = self.engine_controller_info_tuple[0]

        _, ret, _, ctrl_ip_name_dict = cliUtil.get_ctrl_ip_name_dict(self.cli, self.lang)
        self.logger.info("[ReplaceDMCert] get ctrl ip name dick = {}.".format(ctrl_ip_name_dict))
        self.logger.info("[ReplaceDMCert] get ctrl enginet = {}.".format(self.engine_controller_info_tuple))
        self.add_all_ret(ret)
        # 保存引擎id与控制器ip对应关系
        engine_id_ctrl_ip_dict = {}
        for ctrl_ip, ctrl_name in ctrl_ip_name_dict.items():
            engine_id = ctrl_name[:1]
            if current_engine_id == engine_id :
                ctrl_ip_list = engine_id_ctrl_ip_dict.get(engine_id, [])
                ctrl_ip_list.append(ctrl_ip)
                engine_id_ctrl_ip_dict[engine_id] = ctrl_ip_list

        # 非当前引擎ID的，不需要上传证书文件，流程结束后，当前只有一个引擎信息，按照单引擎流程处理
        # 保存每个引擎上上传了证书的控制器的内部ip {engine_id : ctrl_inner_ip}
        uploaded_engine_dict = {}
        self.logger.info("[ReplaceDMCert] single engine start to upload by manager ip.")
        self.upload_to_engine_ctrl(uploaded_engine_dict)
        return uploaded_engine_dict
       

    def need_use_nat_network_upload_file(self, engine_id_ctrl_ip_dict):
        """
        单引擎：去SVP、NAT组网场景，无法通过show upgrade package查询的IP建立cli和 sftp连接上传证书，
        需要使用原始连接上传
        """
        self.logger.info("check is single engine!")
        return cert_uitls.is_single_engine(engine_id_ctrl_ip_dict)

    def upload_to_engine_ctrl(self, uploaded_engine_dict):
        """
        上传证书文件至一个引擎的一个配置了管理ip的控制器
        """
        sftp_connection = None
        try:
            cert_dev_node = EntityUtils.toOldDev(self.context.java_dev)
            sftp_connection = SftpConn(cert_dev_node)
            sftp_connection.getConnection().prepareSessionWithDefault(cert_dev_node.getLoginUser(),
                                                                      cert_dev_node.getIp(),
                                                                      cert_dev_node.getPort())
            flag, ret, _, engine_controller_info_tuple = cliUtil.getControllerEngineTopography(self.cli, self.lang)
            self.add_all_ret(ret)
            if not flag:
                self.logger.error("[ReplaceDMCert]execute cmd on {} failed,"
                                  " {} may not can be connected.".format(self.ip, self.ip))
                return False
            try:
                sftp_connection.getConnection().createDirs(self.server_path)
            except JException:
                self.logger.error(traceback.format_exc())
            # 增加延时，防止文件目录未创建成功，上传失败。
            time.sleep(2)
            for cert_file in self.local_file_path_list:
                get_upload_cert_file_assist().uploadCertFile(cert_file, sftp_connection.getConnection(),
                                                                          self.server_path)
            engine_id = engine_controller_info_tuple[0]
            # 保存每个引擎上上传了证书的控制器的管理ip {engine_id : ctrl_mgr_ip}，用于替换完成后删除上传的文件
            self.logger.info("[ReplaceDMCert]One engine Upload DeviceManager cert to ctrl_mgr_ip={}, engine_id={}, "
                             "login_device_ip={} successfully.".format(self.ip, engine_id, self.ip))
            self.uploaded_ctrl_ips.append(self.ip)
            node_id = engine_controller_info_tuple[1]
            inner_ip = cert_uitls.get_inner_ip(self.context, self.cli, node_id)
            if inner_ip:
                # 保存每个引擎上上传了证书的控制器的内部ip {engine_id : ctrl_inner_ip}，用于拼接至导入命令中
                self.logger.info(
                    "[ReplaceDMCert]Only one engine,Upload DeviceManager cert to ctrl_inner_ip={}, engine_id={}, "
                    "login_device_ip={} successfully.".format(inner_ip[0], engine_id, self.ip)
                )
                uploaded_engine_dict[engine_id] = inner_ip[0]
                return True
            return False
        except (ToolException, Exception, JException):
            self.logger.error(traceback.format_exc())
            return False
        finally:
            if sftp_connection:
                sftp_connection.getConnection().closeSshConnection()

    def upload_one_engine_one_ctrl(self, engine_id, ctrl_ip, uploaded_engin_dict, ):
        """
        上传证书文件至一个引擎的一个配置了管理ip的控制器
        本次修改：不同时创建两个cli连接，导致老版本同时最多占用3个连接，可能创建失败。
        先创建临时CLI连接使用并关闭。然后创建SFTP连接，使用并关闭。
        """
        sftp_connection = None
        origine_ip = self.context.get_dev_node().ip
        origine_sn = self.context.get_dev_node().sn
        try:
            flag, inner_ip, current_engine_id = self.get_current_engine_info(ctrl_ip)
            if not flag:
                self.logger.error("[ReplaceDMCert]execute cmd on {} failed,"
                                  " {} may not can be connected.".format(ctrl_ip, ctrl_ip))
                return False
            if current_engine_id != engine_id:
                return True
            cert_dev_node = EntityUtils.toOldDev(self.context.java_dev)
            sftp_connection = SftpConn(cert_dev_node)
            sftp_connection.getConnection().prepareSessionWithDefault(
                self.context.get_dev_node().user_name, ctrl_ip, cert_dev_node.getPort()
            )
            try:
                sftp_connection.getConnection().createDirs(self.server_path)
            except JException:
                self.logger.error(traceback.format_exc())
            time.sleep(2)
            for cert_file in self.local_file_path_list:
                get_upload_cert_file_assist().uploadCertFile(cert_file, sftp_connection.getConnection(),
                                                                          self.server_path)
            # 保存每个引擎上上传了证书的控制器的管理ip {engine_id : ctrl_mgr_ip}，用于替换完成后删除上传的文件
            self.logger.info("[ReplaceDMCert]Upload DeviceManager cert to ctrl_mgr_ip={}, engine_id={}, "
                             "login_device_ip={} successfully.".format(ctrl_ip, engine_id, origine_ip))
            self.uploaded_ctrl_ips.append(ctrl_ip)
            if inner_ip:
                # 保存每个引擎上上传了证书的控制器的内部ip {engine_id : ctrl_inner_ip}，用于拼接至导入命令中
                self.logger.info("[ReplaceDMCert]Upload DeviceManager cert to ctrl_inner_ip={}, engine_id={}, "
                                 "login_device_ip={} successfully.".format(inner_ip[0], engine_id, origine_ip))
                uploaded_engin_dict[engine_id] = inner_ip[0]
                return True
            return False
        except (JException, Exception):
            self.logger.error(traceback.format_exc())
            return False
        finally:
            if sftp_connection:
                sftp_connection.getConnection().closeSshConnection()

    def get_current_engine_info(self, ctrl_ip):
        flag = False
        inner_ip = ""
        engine_id = ""
        cli_connection = None
        try:
            cli_connection = create_cli_connection(self.context, ctrl_ip)
            flag, ret, _, engine_controller_info_tuple = cliUtil.getControllerEngineTopography(
                cli_connection, self.lang)
            engine_id = engine_controller_info_tuple[0]
            node_id = engine_controller_info_tuple[1]
            inner_ip = cert_uitls.get_inner_ip(self.context, cli_connection, node_id)
            self.add_all_ret(ret)
        except (JException, Exception):
            self.logger.error(traceback.format_exc())
        finally:
            if cli_connection:
                cli_connection.close() 
        return flag, inner_ip, engine_id

    def import_cert_on_all_controllers(self, uploaded_engine_dict):
        try:
            engine_id = self.engine_controller_info_tuple[0]
            ctrl_id = self.engine_controller_info_tuple[1]
            self.importssl = CMD_HEAD.format(uploaded_engine_dict.get(engine_id, "")) + self.cmd
            replace_node_id = self.engine_controller_info_tuple[2][self.engine_id][self.node_id]
            self.logger.info("[ReplaceDMCert]run cmd node {} {}.".format(self.engine_id, replace_node_id))
            results = self.dsl("exec_on_all {}", self.import_ssl_certificate,
                target_ctrl={self.engine_id: replace_node_id})

            if results is None or "successfully" not in str(results):
                self.logger.info("[ReplaceDMCert] results is {}.".format(str(results)))
                return False
            return True
        except (JException, Exception):
            self.logger.error(traceback.format_exc())
            return False

    def import_ssl_certificate(self):
        self.logger.info("[ReplaceDMCert]run cmd begin.")
        try:
            runcmd = "exec_developer '{}'".format(self.importssl)
            results = self.dsl(runcmd)
            return results
        except (JException, Exception):
            self.logger.error(traceback.format_exc())
        return None


    def execute_import_cmd(self, cmd, ctrl_id):
        flag, inner_ip, engine_id = self.get_current_engine_info(self.context.dev_node.ip)
        self.logger.info("[ReplaceDMCert]get current engine {}, inner ip {}.".format(engine_id, inner_ip))
        
        cli = create_cli_connection(self.context, inner_ip[0])
        if cli is None :
            self.logger.info("[ReplaceDMCert]create cli failed with ip {}.".format(inner_ip))
            return False
        flag, ret, _ = cliUtil.execCmdInCliMode(cli, cmd, False, self.lang)
        self.logger.info(
            "[ReplaceDMCert]Device {} node {} replace DeviceManager cert receive str : {}".format(self.ip, ctrl_id,
                                                                                                  ret))
        self.add_all_ret(ret)
        if not flag:
            return False
        total_ret_str, execute_cmd_y_ret = cliUtil.execute_cmd_y(cli, ret)
        self.add_all_ret(total_ret_str)
        if cliUtil.queryResultWithNoRecord(execute_cmd_y_ret):
            self.logger.info(
                "[ReplaceDMCert]Replace DeviceManager cert on node {} of {} successfully.".format(ctrl_id, self.ip)
            )
            self.replace_successfully_ctrl.append(ctrl_id)
            return True
        return False

    def add_all_ret(self, ret):
        self.all_ret += ret + "\n"

    def import_cert_svp_vm(self):
        cli_connection = None
        try:
            cli_connection = contextUtil.createCliConnection(self.context, self.context.get("devNodeIp"), False)
            self.logger.info("[ReplaceDMCert]Start replace DeviceManager on node {} of {}.".format("svp_vm", self.ip))
            cmd = CMD_HEAD.format(self.uploaded_ctrl_ips[0]) + self.cmd
            return self.execute_import_cmd(cli_connection, cmd, "svp_vm")
        except (ToolException, Exception):
            self.logger.error(traceback.format_exc())
            return False
        finally:
            if cli_connection:
                cli_connection.close()

    def delete_cert_files(self, ctrl_ip):
        """
        删除上传了证书的控制器上的证书文件及目录
        """
        cli_connection = None
        sftp_connection = None
        try:
            cli_connection = dsl_adapter.get_con(self.context)
            sftp_connection = SftpCls(cli_connection)
            try:
                for local_cert_file in self.local_file_path_list:
                    cert_file_path = self.server_path + local_cert_file.getFileName()
                    sftp_connection.deleteFile(cert_file_path)
                self.logger.info("[ReplaceDMCert]Delete DeviceManager cert on device {} successfully.".format(ctrl_ip))
            except JException:
                self.logger.error("[ReplaceDMCert]Delete DeviceManager cert on device {} failed.".format(ctrl_ip))
                self.logger.error(traceback.format_exc())
        except (ToolException, Exception):
            self.logger.error(traceback.format_exc())
        finally:
            if sftp_connection:
                sftp_connection.close()
            if cli_connection:
                cli_connection.close()

    def replace_execute(self):
        try:
            ip = self.context.dev_node.ip
            self.logger.info(
                "[ReplaceDMCert]Start replace DeviceManager cert on all controllers of {}.".format(ip))
            self.cli = dsl_adapter.get_con(self.context)
            try:
                uploaded_engine_dict = self.upload_to_all_engine()
                if self.upload_failed_engine:
                    self.data[ALL_CLI_RET] = self.all_ret
                    return False, "dm.upload.failed", self.data
            except (ToolException, Exception):
                self.logger.error(traceback.format_exc())
                self.logger.error("[ReplaceDMCert] upload to all engine fail")
                self.data[ALL_CLI_RET] = self.all_ret
                return False, "dm.upload.failed", self.data

            try:
                if not self.import_cert_on_all_controllers(uploaded_engine_dict):
                    self.logger.info(
                        "[ReplaceDMCert]End replace DeviceManager cert on all controllers of {}.".format(ip))
                    return False, "dm.build.connection.failed", self.data

                if self.map.get("isRunInSvp"):
                    self.import_cert_svp_vm()
                self.logger.info(
                    "[ReplaceDMCert]End replace DeviceManager cert on all controllers of {}.".format(ip))
            except (ToolException, Exception):
                self.logger.error(traceback.format_exc())
                self.add_replace_status()
                self.data[ALL_CLI_RET] = self.all_ret
                return False, "dm.build.connection.failed", self.data

            self.data[ALL_CLI_RET] = self.all_ret
            if self.replace_failed_ctrl:
                self.add_replace_status()
                return False, "dm.replace.failed", self.data
            return True, "", self.data
        finally:
            for ctrl_ip in self.uploaded_ctrl_ips:
                self.delete_cert_files(ctrl_ip)
            if self.cli:
                self.cli.close()

    """
        检查当前节点是否是更换后节点
    """
    def check_is_replace_node(self):
        selected_bbu = ast.literal_eval(self.context.execute_env.selected_fru)
        ctrl_name = selected_bbu.get("id")
        if ctrl_name is not None :
            self.engine_id = ctrl_name[:1]
            self.node_id = CTRL_NODE_MAP.get(ctrl_name[1:2])
        return True

    """
        前置场景检查
        1、检查是否是NAT组网
        2、检查当前更换节点所在引擎是否有管理IP
    """
    def pre_check_devicemanager(self):
        try:
            ret, msg, _ = self.pre_check_execute()
            if not ret:
                self.logger.error("[ReplaceDMCert]pre_check_devicemanager failed,msg : {}.".format(msg))
            return ret
        except JException:
            self.logger.error(traceback.format_exc())
            return False

    """
        证书替换
    """
    def replace_devicemanager_cert(self):
        try:
            ret, msg, _ = self.replace_execute()
            if not ret:
                self.logger.error("[ReplaceDMCert]replace_devicemanager_cert failed.msg : {}.".format(msg))
            return ret
        except JException:
            self.logger.error(traceback.format_exc())
            return False

    """
        获取证书指纹，校验是否替换过证书
    """
    def check_is_has_replace(self):
        origin_dev = self.context.get_dev_node().origin_dev
        old_dev = EntityUtils.toOldDev(origin_dev)
        restflag = self.context.execute_env.ori_env.get("CertFlag")
        self.logger.info("[ReplaceDMCert] current restflag is {}.".format(restflag))
        self.logger.info("[ReplaceDMCert] current is {}.".format(origin_dev))
        if restflag == "NewHuawei":
            return True
        if restflag == "NewNoHuawei":
            check_defualt = "check.not.pass.defualt"
            check_confirm = "check.not.pass.confirm"
            parent = BizPackageContext.getInstance().getWizard()
            warning_dialog = DialogUtils.showWarnConfirmDialog(parent, self.get_msg(check_defualt),
                                                            self.get_msg(check_confirm))
            if warning_dialog.getValue() != WarningDialog.YES_OPTION:
                return False
            return False # 此处只是做提示，任务不能失败。直接响应pass

        return False

    def get_confrim(self):
        check_warning = "check.not.pass.warning"
        check_confirm = "check.not.pass.confirm"
        try:
            parent = BizPackageContext.getInstance().getWizard()
            warning_dialog = DialogUtils.showWarnConfirmDialog(parent, self.get_msg(check_warning),
                                                            self.get_msg(check_confirm))
            if warning_dialog.getValue() != WarningDialog.YES_OPTION:
                return False
            return True
        except (ToolException, Exception, JException):
            self.logger.error(traceback.format_exc())
            return False

    def execute(self):
        check_warning = "check.not.pass.warning"
        try:
            if not self.check_is_replace_node():
                return CheckStatus.PASS, ""  # 当前节点是既有老节点，非更换后节点，直接检查通过
            self.logger.info("[ReplaceDMCert] check is replace node.")
            
            if not self.pre_check_devicemanager():
                if not self.get_confrim():
                    return CheckStatus.NOT_PASS, self.get_msg(check_warning)
                return CheckStatus.PASS, self.get_msg(check_warning)
            
            self.logger.info("[ReplaceDMCert] check is preCheckDeviceManager .")
            if not self.check_is_has_replace():
                self.logger.info("[ReplaceDMCert] no replace dm cert ,post do not to replacce.")
                return CheckStatus.PASS, ""  # 未进行替换，则直接结束
            
            self.logger.info("[ReplaceDMCert] check is is has replace .")
            if not self.replace_devicemanager_cert():
                self.logger.info("[ReplaceDMCert] replace cert file fail.")
                if not self.get_confrim():
                    return CheckStatus.NOT_PASS, self.get_msg(check_warning)
                return CheckStatus.PASS, self.get_msg(check_warning)
            self.logger.info("[ReplaceDMCert] replace cert file success.")
            return CheckStatus.PASS, ""
        except (ToolException, Exception, JException):
            self.logger.error(traceback.format_exc())
            if not self.get_confrim():
                return CheckStatus.NOT_PASS, self.get_msg(check_warning)
            return CheckStatus.PASS, self.get_msg(check_warning)
