# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.platform.util.product_util import compare_patch_version
from psdk.dsl.dsl_common import get_version_info
from psdk.dsl import fault_mode as ft


class CheckItem(BaseCheckItem):
    def execute(self):
        # 获取基本信息
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        version = version_info.get("base_version").get("Current Version")

        # 6.1.2安装了SPH30及以后补丁，通过
        if version == "6.1.2" and \
                compare_patch_version(patch_version, "SPH30") >= 0:
            return CheckStatus.PASS, ""

        # 6.1.3安装了SPH10及以后补丁，通过
        if version == "6.1.3" and \
                compare_patch_version(patch_version, "SPH10") >= 0:
            return CheckStatus.PASS, ""

        # 检查方法步骤1：使用dsl执行命令查询框的信息
        audit_infos = self.dsl("exec_cli 'show vstore' | horizontal_parser",
                               return_if={ft.FindStr("Error:"): "check_pass"})
        if audit_infos == "check_pass":
            return CheckStatus.PASS, ""
        for audit_info in audit_infos:
            audit_enabled = audit_info.get("Audit Log Strategy Enabled")
            if audit_enabled == "Yes":
                return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""
