# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl import fault_mode as ft


class CheckItem(BaseCheckItem):
    def execute(self):
        # 执行命令：show file_system general |filterRow column=Support\s32bit\sInode predict=equal_to value=Yes |filterColumn include columnList=ID,Support\s32bit\sInode，查找记录
        event_info = self.dsl("exec_cli 'show file_system general |filterRow column=Support\s32bit\sInode predict=equal_to value=Yes |filterColumn include columnList=ID,Support\s32bit\sInode'",
                              return_if={ft.CmdNoSupport: "not_support"})
        if 'No matching records' in event_info or "not_support" in event_info:
            return CheckStatus.PASS, ""
        return CheckStatus.NOT_PASS, self.get_msg("check.not.pass")
