# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):
    def execute(self):
        # 检查性能统计归档开关是否打开
        if self.check_perf_hitory_switch():
            return CheckStatus.PASS, ""

        # 如果不是Yes，则检查不通过
        return CheckStatus.WARNING, self.get_msg("check.not.pass")

    def check_perf_hitory_switch(self):
        """
        检查性能统计归档开关是否配置
        :return:Yes-打开，No-关闭
        """
        # 检查方法：使用dsl执行命令show performance strategy检查性能统计归档开关是否打开
        results = self.dsl("exec_cli 'show performance strategy' | vertical_parser")
        return results and results[0].get("Archive Enabled") == "Yes"
