# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
import re
import ast

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.checkitem.common.power_replace_common import self_exit, check_subrack_type


class CheckItem(BaseCheckItem):
    def execute(self):
        # 对于风扇模块，如果后续也要做该检查项，注意风扇模块可以多选，并且可能object_id参数中有空格
        selected_fru = ast.literal_eval(self.context.execute_env.selected_fru)
        # 获取name值
        object_name = selected_fru.get("name", "")
        self.logger.info(object_name)
        script_name = 'power_replace_before_depend_check'
        try:
            if not check_subrack_type(self, object_name, script_name):
                return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass.subract", "item.suggestion.subract")
            self.logger.info(script_name + " start!")
            return self.power_bmc_depend()
        finally:
            self_exit(self, script_name)

    # 电源依赖检查
    def power_bmc_depend(self):
        bmc_depend_upgrade_status = self.dsl("exec_mini_system 'eam.sh psu_upgrade_bmc_isok'")
        bmc_depend_replace_status = self.dsl("exec_mini_system 'eam.sh psu_replace_bmc_isok'")
        if '0x00' in bmc_depend_upgrade_status or '0x00' in bmc_depend_replace_status :
            return CheckStatus.PASS, ""
        else:
            return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion")

