# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
import re
import ast

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.checkitem.common.power_replace_common import self_exit, check_subrack_type


class CheckItem(BaseCheckItem):
    def execute(self):
        # 对于风扇模块，如果后续也要做该检查项，注意风扇模块可以多选，并且可能object_id参数中有空格
        selected_fru = ast.literal_eval(self.context.execute_env.selected_fru)
        # 獲取name值
        object_name = selected_fru.get("name", "")
        script_name = 'power_replace_before_subrack_type_check'
        try:
            if not check_subrack_type(self, object_name, script_name):
                return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass.subract", "item.suggestion.subract")
            self.logger.info(script_name + " start!")
            # 控制器0节点查询电源升级状态
            return self.power_dev_mod()
        finally:
            self_exit(self, script_name)

    # 当前设备形态检查
    def power_dev_mod(self):
        dev_mod_status = self.dsl("exec_mini_system 'eam.sh showenclosure'")
        # 获取frameType、enclModel字段信息
        frame_type_info = re.search(r'frameType\s*=\s*\w+', dev_mod_status).group()
        encl_model_info = re.search(r'enclModel\s*=\s*\w+', dev_mod_status).group()
        # 获取frameType、enclModel具体值
        index_f = frame_type_info[(frame_type_info.index("= ") + 2):]
        index_e = encl_model_info[(encl_model_info.index("= ") + 2):]
        mid_model = ['0x71', '0x72', '0x73', '0x7b', '0x7c', '0x7d', '0x7e']
        low_model = ['0x74', '0x75', '0x76', '0x77', '0x78', '0x7a']
        if index_f == 'CtrlEncl' and (index_e in mid_model or index_e in low_model):
            return CheckStatus.PASS, ""
        elif index_f == 'IpEncl' and (index_e in mid_model or index_e in low_model):
            return CheckStatus.PASS, ""
        else:
            return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion")

