# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
import re
import ast

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.checkitem.common.power_replace_common import self_exit, check_subrack_type


class CheckItem(BaseCheckItem):
    def execute(self):
        # 对于风扇模块，如果后续也要做该检查项，注意风扇模块可以多选，并且可能object_id参数中有空格
        selected_fru = ast.literal_eval(self.context.execute_env.selected_fru)
        # 獲取name值
        object_name = selected_fru.get("name", "")
        script_name = 'power_replace_before_upgrade_status_check'
        try:
            if not check_subrack_type(self, object_name, script_name):
                return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass.subract", "item.suggestion.subract")
            self.logger.info(script_name + " start!")
            # 控制器0节点查询电源升级状态
            results = self.check_psu_target()
            if results:
                return CheckStatus.PASS, ""
            else:
                return CheckStatus.NOT_PASS, self.get_err_msg("check.not.pass", "item.suggestion")
        finally:
            self_exit(self, script_name)

    def check_psu_upgrade(self):
        is_exist_permit = self.check_file_exist("power_upgrade_permit")
        is_exist_prohibit = self.check_file_exist("power_upgrade_prohibit")
        if is_exist_permit == False or is_exist_prohibit == True:
            selected_fru = ast.literal_eval(self.context.execute_env.selected_fru)
            # 获取目标框name值
            object_name = selected_fru.get("name", "")
            # 先退出一次
            script_name = 'power_replace_before_upgrade_status_check'
            self_exit(self, script_name)
            ret = check_subrack_type(self, object_name, script_name)
            if not ret:
                return False
            if self.check_psu_upgrade_start():
                return False
            else:
                return True
        else:
            return False

    def check_psu_upgrade_start(self):
        return self.check_file_exist("power_upgrade_start")

    def check_file_exist(self, filename):
    # 当前是admin状态，需要进入mini_system
        tmp_result = self.dsl("exec_mini_system 'ls /tmp/'")
        conf_result = self.dsl("exec_mini_system 'ls /home/ibc_os_hs'")
        if filename in conf_result or filename in tmp_result:
            return True
        else:
            return False

    # 电源编码、状态、功率检查
    def check_psu_target(self):
        # 电源版本查询
        power_psu0_ver_info = self.dsl("exec_mini_system 'eam.sh psu_upgrade_versions_check 1000 0'")
        power_psu1_ver_info = self.dsl("exec_mini_system 'eam.sh psu_upgrade_versions_check 1001 0'")
        # 获取version字段信息
        power_psu0_ver = re.search(r'version:\d+', power_psu0_ver_info).group()
        power_psu1_ver = re.search(r'version:\d+', power_psu1_ver_info).group()
        # 获取具体版本值
        index_psu0 = power_psu0_ver.index("version:") + 8
        index_psu1 = power_psu1_ver.index("version:") + 8
        psu0_ver = power_psu0_ver[index_psu0:]
        psu1_ver = power_psu1_ver[index_psu1:]
        if psu0_ver and psu1_ver:
            if psu0_ver not in ['111', '113', '115', '119'] and psu1_ver not in ['111', '113', '115', '119']:
                return True
            # 退控制框，跳转0节点
            results = self.dsl("exec_on_all {}", self.check_psu_upgrade, target_ctrl={"0": "0"})
            if not results.values():
                return False
            for result in results.values():
                if result:
                    return True
                return False
        else:
            return False
