# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.
import ast
from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info


psu_risk_list = ['02311TLF', '02312AHK', '02312HGY', '02312PEU', '02312QXD', '02312XWK', '02312YKR', '02313NFU',
                 '02314GVY', '02352TAK', '02352TYV', '02353MRU', '02353PMV', '02353THJ', '02353TLC', '02353UJQ',
                 '02353UJS', '02354ADL', '02354ADM', '02354BTC', '02354CCT', '02354JQD', '02355AHQ', '02355AJG',
                 '02355HQK', '02355HQL', '02355HQM']
disk5515_list = ['02312DLG', '02312EYA', '02312EYB', '02312EYD', '02312EYF', '02312EYG', '02312EYH', '02312EYJ',
                 '02312EYK', '02312EYL', '02312EYM', '02312EYP', '02312EYQ', '02312EYR', '02312EYS', '02312EYT',
                 '02312FPR', '02312FPX', '02312FQB', '02312FQD', '02312FQS', '02312FQV', '02312FQW', '02312FRA',
                 '02312FRC', '02312FRE', '02312FRJ', '02312FRL', '02312FRN', '02312FRQ', '02312FRT', '02312FTS',
                 '02312FTT', '02312FTU', '02312FTV', '02312FTW', '02312FTX', '02312FTY', '02312FUB', '02312FUD',
                 '02312FUE', '02312FUG', '02312FUH', '02312FUJ', '02312FUK', '02312FUM', '02312GDB', '02312HWM',
                 '02312HYW', '02312HYX', '02312JAA', '02312JAB', '02312JHW', '02312JHX', '02312JKD', '02312JKE',
                 '02312JKF', '02312JLR', '02312JLS', '02312JLT', '02312JLU', '02312JLV', '02312JLW', '02312JLX',
                 '02312JLY', '02312JMB', '02312JMC', '02312JMD', '02312JME', '02312JMF', '02312JRT', '02312JRV',
                 '02312JRW', '02312JRX', '02312JVL', '02312JVM', '02312JVN', '02312JVP', '02312JYB', '02312JYC',
                 '02312JYD', '02312JYE', '02312JYF', '02312JYG', '02312JYH', '02312JYJ', '02312JYK', '02312JYL',
                 '02312JYM', '02312JYN', '02312KAC', '02312KAU', '02312KAV', '02312KAW', '02312KDN', '02312KDQ',
                 '02312KDR', '02312KDT', '02312KDU', '02312KDV', '02312KDW', '02312KDX', '02312KDY', '02312KEA',
                 '02312KEB', '02312KEC', '02312KED', '02312KEE', '02312KEF', '02312KEG', '02312KEH', '02312KEJ',
                 '02312KEK', '02312KEL', '02312KEM', '02312KEN', '02312KEP', '02312KEQ', '02312KER', '02312KES',
                 '02312KET', '02312KEU', '02312KEV', '02312KEW', '02312KEX', '02312KEY', '02312KFA', '02312KFB',
                 '02312KFC', '02312KFD', '02312KFE', '02312KFF', '02312KFG', '02312KFH', '02312KFJ', '02312KFK',
                 '02312KFL', '02312KFM', '02312KFN', '02312KFP', '02312KFQ', '02312KFS', '02312KFT', '02312KFV',
                 '02312KFW', '02312KMQ', '02312KMR', '02312KMS', '02312KVA', '02312LJM', '02312LJQ', '02312LJS',
                 '02312LJU', '02312LJV', '02312LJW', '02312LJX', '02312LJY', '02312LKA', '02312LMK', '02312LML',
                 '02312LMM', '02312LMN', '02312MCM', '02312MCN', '02312MGG', '02312MYP', '02312NAT', '02312NGT',
                 '02312NLT', '02312PAV', '02312PBC', '02312PBE', '02312PBG', '02312TKU', '02312TKV', '02312YPX',
                 '02313EDM', '02350SSK', '02350SSM', '02350SWJ', '02350SWL', '02350VVA', '02350VVB', '02350VVC',
                 '02350VVD', '02350WNC', '02350WND', '02350YMC', '02350YME', '02350YMG', '02351CWQ', '02351CWR',
                 '02351EJJ', '02351FPM', '02351KCK', '02351KCL', '02351KCM', '02351KCP', '02351KES', '02351KEY',
                 '02351NWG', '02351NWJ', '02351PSC', '02351PSP', '02351SBH', '02351SDB', '02351SEL', '02351SEM',
                 '02351TKW', '02351TKX', '02351TKY', '02351TLA', '02351TLB', '02351TLM', '02351TLN', '02351TLP',
                 '02351TLQ', '02351TLR', '02351UQN', '02351UQQ', '02351UQR', '02351UQS', '02351VXF', '02351VXH',
                 '02351YPS', '02351YPT', '02351YRE', '02351YSU', '02351YSV', '02351YSW', '02352ANN', '02352ANP',
                 '02352ARR', '02352ASA', '02352ASB', '02352ASC', '02352CJH', '02352CLS', '02352CLT', '02352CWE',
                 '02352EHA', '02352EHC', '02352EHF', '02352EHG', '02352ENE', '02352FEU', '02352FEW', '02352FEX',
                 '02352FFB', '02352FFE', '02352FFH', '02352GPT', '02352JBW', '02352JBX', '02352LKQ', '02352LKT',
                 '02352LSS', '02352LST', '02352LVL', '02352LVQ', '02352LWF', '02352LWN', '02352LWP', '02352LWR',
                 '02352LWU', '02352LWV', '02352LWW', '02352LWX', '02352LWY', '02352LXA', '02352LXB', '02352NCG',
                 '02352NCJ', '02352NCK', '02352NCM', '02352RSX', '02352SFM', '02352SFN', '02352SFV', '02352SFW',
                 '02352TAV', '02352TCD', '02352UCD', '02352UCF', '02352UNW', '02352UPD', '02352WEL', '02352WEM',
                 '02352WEX', '02352WEY', '02352XBG', '02352XBM', '02352XNF', '02352XNL', '02352XWJ', '02353BFJ',
                 '02353BFK', '02353BGB', '02353BGG', '02353ECP', '02353HST', '02353HSU', '02353LCX', '02353LDJ']


class CheckItem(BaseCheckItem):
    def execute(self):
        ret_msg = ""
        selected_fru = ast.literal_eval(self.context.execute_env.selected_fru)
        self.logger.info(selected_fru)
        select_psu_id = str(selected_fru.get("location"))
        select_dev_type = select_psu_id.split(".PSU")[0]
        select_psu_sn = ""
        result_msg = self.dsl("exec_cli 'show power_supply|filterColumn include columnList=Serial\sNumber,ID'")
        psu_sn_list = self.dsl("echo {} | horizontal_parser", result_msg)
        for psu_sn in psu_sn_list:
            if psu_sn.get("ID") == select_psu_id:
                select_psu_sn = psu_sn.get("Serial Number")
        select_psu_code = select_psu_sn[2:10]
        psu_msg = "Replace PSU Info:\n  ID: {}, SN Code: {}\n\n".format(select_psu_id, select_psu_sn)
        self.logger.info(psu_msg)
        if select_psu_code not in psu_risk_list:
            return CheckStatus.PASS, ""
        
        result_msg = self.dsl("exec_cli 'show disk general|filterColumn include columnList=ID,Item'")
        disk_item_list = self.dsl("echo {} | horizontal_parser", result_msg)
        disk_msg = "5515 Disk Info:\n"
        disk_cnt = 0
        disk5515_cnt = 0
        for disk_item in disk_item_list:
            if select_dev_type in disk_item.get("ID"):
                disk_cnt += 1
                if disk_item.get("Item") in disk5515_list:
                    disk_msg += "  ID: {}, Item: {}\n".format(disk_item.get("ID"), disk_item.get("Item"))
                    disk5515_cnt += 1
        ret_msg = psu_msg + disk_msg
        self.logger.info(ret_msg)
        if disk_cnt > 0:
            if disk5515_cnt > 0 and disk5515_cnt < 5:
                return CheckStatus.NOT_PASS, psu_msg + "\n" + self.get_msg("check.not.pass")
        return CheckStatus.PASS, ""

