# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2022-2022. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus


class CheckItem(BaseCheckItem):
    def execute(self):
        # 步骤2 执行命令：dpsf showprocevent -dpsf_snm，获取自动修复记录；
        cli_ret = self.dsl("exec_diagnose 'dpsf showprocevent -dpsf_snm'")
        if not self._has_alarm_info(cli_ret):
            return CheckStatus.PASS, ""
        # 步骤3 执行命令：dpsf clearprocevent -dpsf_snm，清除已经查阅过的记录信息。
        self.dsl("exec_diagnose 'dpsf clearprocevent -dpsf_snm'")
        return CheckStatus.WARNING, self.get_msg("check.warning")

    def _has_alarm_info(self, cli_ret):
        """
        检查命令执行结果是否包含告警信息。
        [Proc_name1]
        type=1/2
        time=2022-4-21 16:01:30
        :param cli_ret: 命令执行结果
        :return:是否匹配
        """
        return "[" in cli_ret and "type=" in cli_ret and "time=" in cli_ret
