# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.checkitem.common.base_dsl_check import BaseCheckItem
from psdk.platform.entity.check_status import CheckStatus
from psdk.dsl.dsl_common import get_version_info
# 问题解决版本
PATCH_MAP = {
    "1.3.0": "SPH7",
    "1.5.0": "SPH2"
}


class CheckItem(BaseCheckItem):
    def execute(self):
        # 获取基本信息
        version_info = get_version_info(self.dsl)
        patch_version = version_info.get("patch_version").get("Current Version")
        system_version = version_info.get("base_version").get("Current Version")
        # 检查当前补丁版本
        if PATCH_MAP.get(system_version, "") == "":
            return CheckStatus.NOT_CHECK, ""
        resolved_patch_version = PATCH_MAP.get(system_version, "")
        if len(resolved_patch_version) < len(patch_version) or resolved_patch_version <= patch_version:
            return CheckStatus.PASS, ""
        # 检查dataturbo的版本号
        client_info = self.dsl("exec_cli 'show dataturbo client_info' | horizontal_parser")
        for client in client_info:
            if "1.0.0" in client.get("Client Version", ""):
                return CheckStatus.NOT_PASS, ""
        return CheckStatus.PASS, ""
