# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.


def get_con(context, allow_not_admin=False, conn_to_ctrl=True):
    """
    获取cli连接
    :param context: context
    :param allow_not_admin: 是否允许获取到非admin模式下的连接
    :param conn_to_ctrl: 是否连接到控制器
    如果允许，则获取到的cli可能处于debug/minisystem/developer/admin模式；
    如果不允许，则获取到的cli如果处于非admin/developer模式时会进行一次断开再重新连接的操作
    :return:
    """
    from psdk.platform.protocol.cli_con_mgr import get_ctrl_cli, get_available_conn
    cli = context.cli
    if conn_to_ctrl:
        return get_ctrl_cli(context, cli, allow_not_admin)
    return get_available_conn(context, cli, allow_not_admin)


def exec_cli(cli, cmd, lang="zh", **kwargs):
    from psdk.platform.protocol.cli_common import exec_cli
    lock = cli.getLock()
    try:
        lock.lock()
        flag, cli_ret = exec_cli(cli, cmd, lang, **kwargs)
        return flag, cli_ret
    finally:
        lock.unlock()


def exec_developer(cli, cmd, lang="zh", **kwargs):
    from psdk.platform.protocol.cli_service import exec_developer
    lock = cli.getLock()
    try:
        lock.lock()
        flag, cli_ret = exec_developer(cli, cmd, lang, None, **kwargs)
        return flag, cli_ret
    finally:
        lock.unlock()


def exec_diagnose(cli, cmd, lang="zh", **kwargs):
    from psdk.platform.protocol.cli_service import exec_diagnose
    lock = cli.getLock()
    try:
        lock.lock()
        flag, cli_ret = exec_diagnose(cli, cmd, lang, None, **kwargs)
        return flag, cli_ret
    finally:
        lock.unlock()


def exec_mini_system(cli, cmd, lang="zh", **kwargs):
    from psdk.platform.protocol.cli_service import exec_mini_system
    lock = cli.getLock()
    try:
        lock.lock()
        flag, cli_ret = exec_mini_system(cli, cmd, lang, None, **kwargs)
        return flag, cli_ret
    finally:
        lock.unlock()


def exec_rest(context, uri, method, param_obj):
    from psdk.platform.protocol.rest.rest_service import RestService
    if method == "get":
        return RestService(context.java_dev).exec_get(uri, param_obj)
    if method == "post":
        return RestService(context.java_dev).exec_post(uri, param_obj)
    if method == "put":
        return RestService(context.java_dev).exec_put(uri, param_obj)
    raise Exception


def get_logger(context):
    return context.get("logger")


def save_result(sn, cmd, value, node=""):
    # noinspection PyUnresolvedReferences
    from com.huawei.ism.tool.fdt.cache import CommandRecordService
    CommandRecordService.getInstance().saveWithDelDuplicated(sn, cmd, value, node)
    CommandRecordService.getInstance().commit()


def get_result(sn, cmd, node=""):
    # noinspection PyUnresolvedReferences
    from com.huawei.ism.tool.fdt.cache import CommandRecordService
    return CommandRecordService.getInstance().getCmdRet(sn, cmd, node)


def exec_on_all(dsl_context):
    from psdk.platform.ability.execute_on_all_controllers import (
        ExecuteOnAllControllers,
        ExeOnAllCtrlContext,
        FuncResult,
        ResultType
    )

    @ExecuteOnAllControllers
    def _fun(exe_context):
        # 从原始context中取出传入的实际参数，包括函数名和函数的入参
        func = exe_context.args[0]
        params = exe_context.args[1:]
        logger = dsl_context.context.get_logger()
        ctrl_id = ""
        try:
            result = func(*params)
            ctrl_id = exe_context.cur_ctrl_id
            logger.info("ctrl_id:{}".format(ctrl_id))
            exe_context.ctrl_results[ctrl_id] = result
        except Exception as exception:
            logger.error("Exception:{}".format(exception))
            exe_context.ctrl_results[ctrl_id] = None
        return FuncResult(ResultType.SUCCESS, need_continue_exe=True)

    exe_on_all_context = ExeOnAllCtrlContext(dsl_context.context, args=dsl_context.args)
    if "target_ctrl" in dsl_context.kwargs:
        target_ctrl = dsl_context.kwargs.get("target_ctrl")
        if isinstance(target_ctrl, dict):
            exe_on_all_context.set_target_ctrl_dict(target_ctrl)
        if "master" == target_ctrl:
            exe_on_all_context.set_target_engine_ctrl()

    _fun(exe_on_all_context)

    trans_node_id = False
    if "need_node_id" in dsl_context.kwargs:
        trans_node_id = dsl_context.kwargs.get("need_node_id")
    return exe_on_all_context.ctrl_results


def get_ctrl_num_one_engine(dsl_context, cli):
    pass
