# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.


class DslException(Exception):
    def __init__(self, code):
        Exception.__init__(self)
        self.code = code

    def get_code(self):
        return self.code


class ReturnException(Exception):
    def __init__(self, ret):
        Exception.__init__(self)
        self.ret = ret

    def get_ret(self):
        return self.ret


class DslContext:
    def __init__(self, context=None):

        # 每个操作符执行完成后，将结果记录到last_data，给下个环节使用
        self.last_data = None

        # 执行命令等操作符需要记录命令回显作为原始信息
        self.origin_info = []

        # 用于接收dsl函数的第2个及之后的参数
        self.args = None

        # 用于接收dsl的字典参数
        self.kwargs = None

        # 脚本原始的上下文
        self.context = context

        # 匹配到的日志数据
        self.matched_data = {}


