# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2021-2023. All rights reserved.

from psdk.platform.base.constants import PRODUCT_DORADO_V6
from psdk.platform.base.constants import PRODUCT_HYBRID_V6
from psdk.platform.base.constants import PRODUCT_DORADO_V6_K


def get_engine_height(dsl, context):
    product_model = context.dev_node.model
    # Dorado和新融合执行命令：showbayconfig
    if product_model in (PRODUCT_DORADO_V6 + PRODUCT_HYBRID_V6 + PRODUCT_DORADO_V6_K):
        engine_height = get_engine_height_on_mini_system_model(dsl)
        if engine_height != 0:
            return engine_height
    # 当showbayconfig没有查到时，或者其余设备，执行命令sys showcls
    dev_infos = dsl("exec_diagnose 'sys showcls' | vertical_parser")
    if dev_infos:
        dev_info = dev_infos[0]
        return int(int(dev_info.get("node max")) / int(dev_info.get("group max")))
    return 0


def get_engine_height_on_mini_system_model(dsl):
    dev_infos = dsl("exec_mini_system 'showbayconfig'")
    if not dev_infos:
        return 0
    line_list = dev_infos.splitlines()
    for line in line_list:
        if "CtrlNodeIdList" in line:
            nodes = line.split(")")[0].split(":")[-1].split(",")
            return len(nodes)
    return 0


def get_version_info(dsl):
    cli_data = dsl("exec_cli 'show upgrade package'")
    base_version = dsl("echo {} | regex 'Software Version([\\s\\S]+)HotPatch Version' | get_index(0) "
                       "| horizontal_parser | get_index(0)", cli_data)
    patch_version = dsl("echo {} | regex 'HotPatch Version([\\s\\S]+)' | get_index(0) "
                        "| horizontal_parser | get_index(0)", cli_data)
    return {"base_version": base_version, "patch_version": patch_version}


def is_single_device(dsl):
    from psdk.dsl import fault_mode as ft
    cli_data = dsl("exec_cli 'show system config_model'", return_if={ft.FindException: ""})
    return "single" in cli_data.lower()


def get_engine_num(dsl):
    engine_set = set()
    cli_data = dsl("exec_cli 'show upgrade package'")
    base_info_list = dsl("echo {} | regex 'Software Version([\\s\\S]+)HotPatch Version' | get_index(0) "
                         "| horizontal_parser ", cli_data)
    for engine_info in base_info_list:
        engine_set.add(engine_info.get("Name")[:1])
    # 返回当前设备引擎数
    return len(engine_set)
