# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from expparser import *
from psdk.dsl.adapter import dsl_adapter
from psdk.dsl.operator.base_operator import BaseOperator


class ExecOnAllDsl(BaseOperator):
    def __init__(self, dsl_context):
        BaseOperator.__init__(self, dsl_context)
        self.operator_type = "data_source"

    def get(self):
        """
        exec_on_all {}
        :return:
        """
        key = Literal("exec_on_all").setResultsName("type")
        pattern = key
        pattern.setParseAction(self.base_action)
        return pattern

    def action(self, s, loc, toks):
        self.logger.info("enter {} action ".format(toks.type))
        try:
            return dsl_adapter.exec_on_all(self.dsl_context)
        except Exception as e:
            import traceback
            self.logger.error("exec on all error." + traceback.format_exc())
