# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from expparser import (
    Literal,
    CharsNotIn,
    Suppress,
    Combine,
    OneOrMore
)
from psdk.dsl.adapter import dsl_adapter
from psdk.dsl.operator.base_operator import BaseOperator


class ExecRestDsl(BaseOperator):

    def __init__(self, dsl_context):
        BaseOperator.__init__(self, dsl_context)
        self.operator_type = "data_source"
        self.context = dsl_context.context
        self.dsl_context = dsl_context

    def get(self):
        key = Literal("exec_rest").setResultsName("type")
        a = CharsNotIn("'")
        b = Suppress("'")
        uri_section = Combine(b + OneOrMore(a) + b).setResultsName("uri")

        pattern = key + uri_section
        pattern.setParseAction(self.base_action)
        return pattern

    def action(self, s, loc, toks):
        self.logger.info("enter {} action ".format(toks.type))
        method = self.dsl_context.kwargs.get("method") if "method" in self.dsl_context.kwargs else "get"
        param_obj = self.dsl_context.kwargs.get("param_obj") if "param_obj" in self.dsl_context.kwargs else ""
        self.logger.info("method= {},param_obj= {}".format(method, param_obj))

        return dsl_adapter.exec_rest(self.context, toks.uri, method, param_obj)
