# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.


def has_svp_module(java_dev):
    from com.huawei.ism.tool.obase.utils import DeviceTypeUtil
    from com.huawei.ism.tool.obase.entity import EntityUtils

    return (
        DeviceTypeUtil.hasSVPModule(EntityUtils.toOldDev(java_dev))
        and java_dev.isIpListAreInnerIp()
        and not java_dev.canEnterDiagnose()
    )


def is_svp_dev_and_outside_svp_module(java_dev):
    from com.huawei.ism.tool.obase.utils import DeviceTypeUtil
    from com.huawei.ism.tool.obase.entity import EntityUtils

    return (
            DeviceTypeUtil.hasSVPModule(EntityUtils.toOldDev(java_dev))
            and not java_dev.isIpListAreInnerIp()
            and not java_dev.canEnterDiagnose()
    )


def get_logger_instance():
    from com.huawei.ism.tool.obase.log import ToolLoggerFactory
    return ToolLoggerFactory.getLoggerInStandAlone("py_log")


def get_lang():
    from com.huawei.ism.tool.obase.utils import ApplicationContext
    return ApplicationContext.getInstance().getCurrentLanguage().getLanguage()
