# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

from psdk.platform.context.app_context import AppContext


def has_svp_module(java_dev):
    device_type_util_cls = (
        AppContext().jvm.com.huawei.ism.tool.obase.utils.DeviceTypeUtil
    )
    entity_utils_cls = (
        AppContext().jvm.com.huawei.ism.tool.obase.entity.EntityUtils
    )
    return (
        device_type_util_cls.hasSVPModule(entity_utils_cls.toOldDev(java_dev))
        and java_dev.isIpListAreInnerIp()
        and not java_dev.canEnterDiagnose()
    )


def is_svp_dev_and_outside_svp_module(java_dev):
    device_type_util_cls = (
        AppContext().jvm.com.huawei.ism.tool.obase.utils.DeviceTypeUtil
    )
    entity_utils_cls = (
        AppContext().jvm.com.huawei.ism.tool.obase.entity.EntityUtils
    )
    return (
        device_type_util_cls.hasSVPModule(entity_utils_cls.toOldDev(java_dev))
        and not java_dev.isIpListAreInnerIp()
        and not java_dev.canEnterDiagnose()
    )


def get_logger_instance():
    from test.psdk.helper.double.logger_double import LoggerDouble
    return LoggerDouble()


def get_lang():
    application_context_cls = (
        AppContext().jvm.com.huawei.ism.tool.obase.utils.ApplicationContext
    )
    return (
        application_context_cls.getInstance()
        .getCurrentLanguage()
        .getLanguage()
    )
