# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import re
from psdk.platform.base.constants import support_product, support_scene, support_operator, support_parser, support_fault_mode


# 场景
def get_all_scene_names():
    return [item.get("name") for item in support_scene]


def get_scene_id(scene_name):
    for scene in support_scene:
        if scene.get("name") == scene_name:
            return scene.get("id")
    return scene_name


def get_tools_by_scene(scene_name):
    for scene in support_scene:
        if scene.get("name") == scene_name:
            return [item.get("name") for item in scene.get("tools")]
    return []


def get_tool_id_by_name(scene_name, tool_name):
    for scene in support_scene:
        if scene.get("name") == scene_name:
            for tool in scene.get("tools"):
                if tool.get("name") == tool_name:
                    return tool.get("id")
    return ""


def get_steps_by_tool(scene_name, tool_name):
    for scene in support_scene:
        if scene.get("name") == scene_name:
            for tool in scene.get("tools"):
                if tool.get("name") == tool_name:
                    return tool.get("steps")
    return []


def parse_scene_data_lines(data_str, pattern):
    ret = []
    for line in data_str.splitlines():
        match_obj = re.match(pattern, line)
        if match_obj:
            item = match_obj.groupdict()
            ret.append(item)
    return ret


# 产品型号和版本
def get_product_series_name():
    return [series.get("name") for series in support_product]


def get_product_series_id(series_name):
    for series in support_product:
        if series.get("name") == series_name:
            return series.get("id")
    return series_name


def get_product_group_name(series_name):
    for series in support_product:
        if series.get("name") == series_name:
            return [group.get("name") for group in series.get("group")]
    return []


def get_product_model(series_name, group_name):
    for series in support_product:
        if series.get("name") == series_name:
            for group in series.get("group"):
                if group.get("name") == group_name:
                    return group.get("model")
    return []


def get_product_model_by_series(series_name):
    for series in support_product:
        if series.get("id") == series_name:
            return series.get("detail")
    return []


# dsl操作
def get_all_dsl_operator():
    return [item.get("name") for item in support_operator]


def get_all_dsl_parser():
    return [item.get("name") for item in support_parser]


def get_all_dsl_fault_mode():
    return [item.get("name") for item in support_fault_mode]


def get_dsl_fault_mode_by_name(fault_mode_name):
    for item in support_fault_mode:
        if item.get("name") == fault_mode_name:
            return item.get("code")
    return fault_mode_name
