# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2023. All rights reserved.

common_step = ["pre_check", "post_check"]

support_scene = [
    {
        "name": "升级",
        "id": "upgrade",
        "tools": [{
            "name": "升级阵列",
            "id": "upgrade_array",
            "steps": common_step
        }, {
            "name": "升级评估",
            "id": "upgrade_eval",
            "steps": ["default"]
        }, {
            "name": "硬盘升级",
            "id": "upgrade_disk",
            "steps": ["default"]
        }]
    },
    {
        "name": "巡检",
        "id": "inspect",
        "tools": [{
            "name": "日常巡检",
            "id": "inspect_daily",
            "steps": ["default"]
        }, {
            "name": "开局质检",
            "id": "inspect_bureau",
            "steps": ["default"]
        }]
    },
    {
        "name": "扩容",
        "id": "expansion",
        "tools": [
            {
                "name": "控制器",
                "id": "exp_ctrl",
                "steps": common_step
            }, {
                "name": "硬盘",
                "id": "exp_disk",
                "steps": common_step
            }, {
                "name": "接口卡",
                "id": "exp_interface",
                "steps": common_step
            }
        ]
    },
    {
        "name": "备件更换",
        "id": "fru",
        "tools": [
            {
                "name": "控制器",
                "id": "fru_controller",
                "steps": common_step
            }, {
                "name": "硬盘",
                "id": "fru_ctrl",
                "steps": common_step
            }, {
                "name": "接口卡",
                "id": "fru_ctrl",
                "steps": common_step
            }
        ]
    }
]

PRODUCT_V3_M = ['2100 V3',
                '2200 V3', '2200 V3 Enhanced',
                '2600 V3', '2600 V3 Enhanced', '2600 V3 for Video', '2600F V3', '2600F V3 Enhanced',
                '2800 V3', '5300 V3',
                '5500 V3', '5500F V3',
                '5600 V3', '5600F V3',
                '5800 V3', '5800F V3',
                '6800 V3', '6800F V3']

PRODUCT_V3_H = ["18500 V3", "18800 V3", "18500F V3", "18800F V3"]

PRODUCT_V5_M = ['2800 V5',
                '5100K V5', '5110 V5', '5110F V5',
                '5200K V5', '5210 V5', '5210F V5',
                '5300 V5', '5300 V5 Enhanced', '5300F V5',
                '5500 V5', '5500 V5 Elite', '5500F V5',
                '5600 V5', '5600F V5',
                '5800 V5', '5800F V5',
                '6800 V5', '6800F V5']

PRODUCT_DORADO_NAS = ['Dorado NAS']

PRODUCT_V5_H = ["18500 V5", "18800 V5", "18500F V5", "18800F V5"]

PRODUCT_V5_KP_M = ['2200 V5', '2600 V5', '2800 V5', '2800K V5', '2810 V5',
                   '5110 V5 Enhanced', '5110F V5 Enhanced', '2210',
                   '5120 V5', '5220 V5', '2220',
                   '5210 V5 Enhanced', '5210F V5 Enhanced',
                   '5300 V5', '5300F V5', '5300K V5', '5310 V5', '5310F V5',
                   '5500 V5', '5500F V5', '5500K V5', '5510 V5', '5510F V5',
                   '5600 V5', '5600F V5', '5600K V5', '5610 V5', '5610F V5',
                   '5800 V5', '5800F V5', '5800K V5', '5810 V5', '5810F V5']

PRODUCT_V5_KP_H = ['6800 V5', '6800F V5', '6800K V5', '6810 V5', '6810F V5',
                   '18500 V5', '18500F V5', '18500K V5', '18510 V5', '18510F V5',
                   '18800 V5', '18800F V5', '18800K V5', '18810 V5', '18810F V5']

PRODUCT_V5 = sorted(list(set(PRODUCT_V5_M + PRODUCT_V5_H + PRODUCT_V5_KP_M + PRODUCT_V5_KP_H)))

PRODUCT_DORADO_V3 = ["Dorado3000 V3", "Dorado5000 V3",
                     "Dorado6000 V3", "Dorado18000 V3"]
PRODUCT_DORADO_V6 = [
    "OceanStor Dorado 3000 V6", "OceanStor Dorado 5300 V6", "OceanStor Dorado 5500 V6",
    "OceanStor Dorado 5600 V6", "OceanStor Dorado 5000 V6", "OceanStor Dorado 6000 V6", "OceanStor Dorado 2020",
    "OceanStor Dorado 8000 V6", "OceanStor Dorado 18000 V6", "OceanStor Dorado 2000", "OceanStor Dorado 2100",
    "OceanStor Dorado 6800 V6", "OceanStor Dorado 18500 V6", "OceanStor Dorado 18800 V6",
    "OceanStor Dorado 3000", "OceanStor Dorado 5000", "OceanStor Dorado 6000", "OceanStor Dorado 8000",
    "OceanStor Dorado 18000", "OceanStor Dorado 5300", "OceanStor Dorado 5500",
    "OceanStor Dorado 5600", "OceanStor Dorado 6800", "OceanStor Dorado 18500",
    "OceanStor Dorado 18800"
]
# 新融合
PRODUCT_HYBRID_V6 = ["OceanStor 5310", "OceanStor 5510", "OceanStor 5510S", "OceanStor 5610",
                     "OceanStor 6810", "OceanStor 18510", "OceanStor 18500K", "OceanStor 5310 Capacity Flash",
                     "OceanStor 18810", "OceanStor 5810-HS", "OceanStor 5320", "OceanStor 5510 Capacity Flash",
                     "OceanStor 5300K", "OceanStor 5500K", "OceanStor 2200", "OceanStor 2220", "OceanStor 5120",
                     "OceanStor 2600", "OceanStor 2620", "OceanStor 5210", "OceanStor 5220", "OceanStor A300"]
PRODUCT_DORADO_V6_K = [
    "OceanStor Dorado 5600K V6", "OceanStor Dorado 18800K V6", "OceanStor Dorado 5600K", "OceanStor Dorado 18800K"
]

PRODUCT_PROTECT = ["OceanProtect A8000", "OceanProtect X8000", "OceanProtect E8000",
                   "OceanProtect X9000", "OceanProtect X8000K",
                   "OceanProtect X3000",
                   "OceanProtect X9000K", "OceanProtect X6000"]
PRODUCT_MICRO = ["OceanStor Micro 1300", "OceanStor Micro 1500", "OceanDisk 1600", "OceanDisk 1300", "OceanDisk 1500",
                 "OceanDisk 1500T", "OceanDisk 1600T"]
PRODUCT_COMPUTE = ["OceanStor 2910"]

AI_ST_H = ["OceanStor A800"]

support_product = [
    {
        "name": "Dorado NAS",
        "id": "Dorado NAS",
        "detail": PRODUCT_DORADO_NAS,
        "group": [{
            "name": "全部",
            "model": "all",
        }, {
            "name": "自定义",
            "model": PRODUCT_DORADO_NAS
        }]
    },
    {
        "name": "融合V3",
        "id": "Hybrid_V3",
        "detail": PRODUCT_V3_M + PRODUCT_V3_H,
        "group": [{
            "name": "全部",
            "model": "all",
        }, {
            "name": "自定义",
            "model": PRODUCT_V3_M + PRODUCT_V3_H
        }]
    },
    {
        "name": "Dorado V3",
        "id": "Dorado_V3",
        "detail": PRODUCT_DORADO_V3,
        "group": [{
            "name": "全部",
            "model": "all",
        }, {
            "name": "自定义",
            "model": PRODUCT_DORADO_V3
        }]
    },
    {
        "name": "Dorado V6",
        "id": "Dorado_V6",
        "detail": PRODUCT_DORADO_V6 + PRODUCT_DORADO_V6_K,
        "group": [{
            "name": "全部",
            "model": "all",
        }, {
            "name": "自定义",
            "model": PRODUCT_DORADO_V6 + PRODUCT_DORADO_V6_K
        }]
    },
    {
        "name": "V5",
        "id": "V5",
        "detail": PRODUCT_V5_M + PRODUCT_V5_H,
        "group": [{
            "name": "全部",
            "model": "all",
        }, {
            "name": "自定义",
            "model": PRODUCT_V5_M + PRODUCT_V5_H
        }]
    },
    {
        "name": "V5 Kunpeng",
        "id": "V5_KP",
        "detail": PRODUCT_V5_KP_M + PRODUCT_V5_KP_H,
        "group": [{
            "name": "全部",
            "model": "all",
        }, {
            "name": "自定义",
            "model": PRODUCT_V5_KP_M + PRODUCT_V5_KP_H
        }]
    },
    {
        "name": "融合V3中低端",
        "id": "Hybrid_V3_M",
        "detail": PRODUCT_V3_M,
        "group": [{
            "name": "全部",
            "model": "all",
        }, {
            "name": "自定义",
            "model": PRODUCT_V3_M
        }]
    },
    {
        "name": "V5中低端",
        "id": "V5_M",
        "detail": PRODUCT_V5_M,
        "group": [{
            "name": "全部",
            "model": "all",
        }, {
            "name": "自定义",
            "model": PRODUCT_V5_M
        }]
    },
    {
        "name": "V5 KP中低端",
        "id": "V5_KP_M",
        "detail": PRODUCT_V5_KP_M,
        "group": [{
            "name": "全部",
            "model": "all",
        }, {
            "name": "自定义",
            "model": PRODUCT_V5_KP_M
        }]
    },
    {
        "name": "V5 KP高端",
        "id": "V5_KP_H",
        "detail": PRODUCT_V5_KP_H,
        "group": [{
            "name": "全部",
            "model": "all",
        }, {
            "name": "自定义",
            "model": PRODUCT_V5_KP_H
        }]
    },
    {
        "name": "融合V6",
        "id": "Hybrid_V6",
        "detail": PRODUCT_HYBRID_V6,
        "group": [{
            "name": "全部",
            "model": "all",
        }, {
            "name": "自定义",
            "model": PRODUCT_HYBRID_V6
        }],
    },
    {
        "name": "OceanProtect",
        "id": "OceanProtect",
        "detail": PRODUCT_PROTECT,
        "group": [{
            "name": "全部",
            "model": "all",
        }, {
            "name": "自定义",
            "model": PRODUCT_PROTECT
        }],
    },
    {
        "name": "微存储",
        "id": "Micro",
        "detail": PRODUCT_MICRO,
        "group": [{
            "name": "全部",
            "model": "all",
        }, {
            "name": "自定义",
            "model": PRODUCT_MICRO
        }],
    },
    {
        "name": "计算型存储",
        "id": "Compute",
        "detail": PRODUCT_COMPUTE,
        "group": [{
            "name": "全部",
            "model": "all",
        }, {
            "name": "自定义",
            "model": PRODUCT_COMPUTE
        }],
    },
    {
        "name": "AI存储",
        "id": "AI_ST",
        "detail": AI_ST_H,
        "group": [{
            "name": "全部",
            "model": "all",
        }, {
            "name": "自定义",
            "model": AI_ST_H
        }]
    },
]

support_operator = [
    {
        "name": "exec_cli",
    }, {
        "name": "exec_developer",
    }, {
        "name": "exec_diagnose",
    }, {
        "name": "exec_rest",
    }, {
        "name": "exec_log",
    }, {
        "name": "exec_tlv",
    }, {
        "name": "exec_config",
    },
]

support_parser = [
    {
        "name": "vertical_parser",
    }, {
        "name": "horizontal_parser",
    }, {
        "name": "double_space_parser",
    }, {
        "name": "regex",
    }
]

support_fault_mode = [
    {
        "name": "命令不支持",
        "code": "ft.CmdNotSupport"
    }, {
        "name": "无licence",
        "code": "ft.CmdNoLicense"
    }, {
        "name": "异常",
        "code": "ft.FindException"
    }, {
        "name": "包含关键字",
        "code": "ft.FindStr"
    }
]

# 证书名称对应type值（前面是证书名称，后面是type参数，名称需要转化成小写进行匹配）
CERT_TYPE_2_NAME_DICT = {'key management center': 'key_management_center',
                         'device management': 'device_management',
                         'domain authentication': 'domain_authentication',
                         'hypermetro arbitration': 'hypermetro_arbitration',
                         'https protocol': 'https_protocol',
                         'ftps protocol': 'ftps_protocol',
                         'syslog server authentication': 'syslog_authentication',
                         'ntp server authentication': 'ntp_authentication',
                         'call Home authentication': 'call_home_authentication',
                         'domain authentication extension 1': 'domain_authentication_extension_1',
                         'domain authentication extension 2': 'domain_authentication_extension_2',
                         'domain authentication extension 3': 'domain_authentication_extension_3',
                         'remote om link': 'remote_om_link',
                         'cloudbackup server authentication': 'cloud_backup_authentication',
                         'sso authentication': 'sso_authentication',
                         'container service authentication': 'smart_container_authentication',
                         'devicemanager authentication': 'devicemanager_authentication',
                         'virtual network computing (vnc) '
                         'server authentication for vms': 'vm_vnc_server_authentication',
                         'vm vnc-based client authentication': 'vm_vnc_client_authentication',
                         'email server authentication': 'email_authentication',
                         'otp email server authentication': 'OTP_email_authentication',
                         'file service domain authentication': 'file_service_domain_authentication',
                         'certificate authority authentication': 'certification_authority',
                         'in-band management': 'In-band_management'
                         }

CERT_TYPE_2_FINGERPRINT_DICT = {'HyperMetro Arbitration': '2F:73:81:36:78:77:BA:D4:8E:4D:01:36:E6:CA:F4:E4:39:63:04:21'}
