# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.


class UnCheckException(Exception):
    """
    未检查异常自定义类
    """
    def __init__(self, err_msg, cli_ret):
        self.err_msg = err_msg
        self.cli_ret = cli_ret


class MessageException(Exception):
    def __init__(self, msg):
        Exception.__init__(self)
        self.msg = msg

    def get_msg(self):
        return self.msg


class NotSupportDeviceException(Exception):
    def __init__(self, err_msg):
        self.err_msg = err_msg


class SshConnectionException(Exception):
    def __init__(self, err_msg):
        self.err_msg = err_msg


class CmdExecuteException(Exception):
    def __init__(self, err_msg, cli_ret=None):
        self.err_msg = err_msg
        self.cli_ret = cli_ret


class RestExecuteException(Exception):
    def __init__(self, err_msg, cli_ret=None):
        self.err_msg = err_msg
        self.cli_ret = cli_ret
