# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import traceback
import sys
from psdk.platform.adapter import java_common


class Logger(object):
    """ 日志类 """

    def __init__(self, logger):
        self.logger = logger

    def debug(self, msg):
        """
        调试信息输出
        :param msg: 调试信息
        """
        try:
            if msg is None:
                msg = "None"
            self.logger.debug(msg)
        except Exception:
            pass

    def info(self, msg):
        """
        调试信息输出
        :param msg: 调试信息
        """
        self.logger.info("[ToolLog][info][{}][{}]".format(str(msg), self._get_py_file_name()))

    def error(self, msg):
        """
        检查异常时的输出
        :param msg: 异常消息
        """
        self.logger.error("[ToolLog][error][{}][{}][traceback:{}]".format(
            msg, self._get_py_file_name(), traceback.format_exc()))

    @staticmethod
    def _get_py_file_name():
        try:
            py_file_name = sys._getframe(2).f_code.co_filename
        except Exception:
            py_file_name = ""
        return py_file_name


log = Logger(java_common.get_logger_instance())
