# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.
from psdk.platform.adapter import java_common


class DevNode(object):
    def __init__(self, sn="", ip="", model="", version=""):
        self.model = model
        self.version = version
        self.user_name = ""
        self.password = ""
        self.sn = sn
        self.ip = ip
        self.origin_dev = None
        self.has_svp_module = False
        self.is_svp_dev_and_outside_svp = False

    @staticmethod
    def to_py_dev_node(java_dev):
        dev_node = DevNode()
        dev_node.origin_dev = java_dev
        dev_node.ip = java_dev.getIp()
        dev_node.password = java_dev.getLoginUser().getPassword()
        dev_node.user_name = java_dev.getLoginUser().getUserName()
        dev_node.sn = java_dev.getDeviceSerialNumber()
        dev_node.model = str(java_dev.getDeviceType())
        dev_node.version = str(java_dev.getProductVersion())
        dev_node.has_svp_module = java_common.has_svp_module(java_dev)
        dev_node.is_svp_dev_and_outside_svp = java_common.is_svp_dev_and_outside_svp_module(java_dev)
        return dev_node

    def get_sn(self):
        return self.sn

    def get_ip(self):
        return self.ip


class BaseContext(object):
    def __init__(self, java_dev, env):
        self.logger = ""
        self.lang = ""
        self.cache_data = {}
        self.java_dev = java_dev
        self.dev_node = DevNode.to_py_dev_node(java_dev)
        self.execute_env = env
        self.tool = ""
        self.check_type = ""
        self.item_config = ""
        self.cli = None

    def get_logger(self):
        return self.logger

    def get_lang(self):
        return self.lang

    def get_dev_node(self):
        return self.dev_node

    def get_java_dev(self):
        return self.java_dev

    def set_item(self, key, value):
        self.cache_data[key] = value

    def get_item(self, key):
        return self.cache_data.get(key, "")

    def get_item_config(self):
        return self.item_config

    def set_item_config(self, item_config):
        self.item_config = item_config
