# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2023. All rights reserved.
import ast
from psdk.platform.base.logger import log

# 备件类型与 SELECTED_ROW 的对应关系
FRU_TYPE_DICT = {
    "fru_controller": "input_selectfru_controllerSelectedRow",
    "fru_disk": "input_selectfru_diskSelectedRow",
    "fru_fan": "input_selectfru_fanSelectedRow",
    "fru_power": "input_selectfru_frutab",
    "fru_risk_power": "input_selectfru_enclosureSelectedRow",
    "fru_ip_scale_out_interface": "input_selectfru_ipScaleOutIntftab",
    "fru_front_end_fibre_module": "input_selectfru_frutab",
    "fru_fibre_module": "input_selectfru_frutab",
    "fru_back_end_interface": "input_selectfru_backEndIntftab",
    "fru_cable_front_end": "input_selectfru_frutab",
    "fru_cable_mgmt": "input_selectfru_frutab_port",
    "fru_cable_pcie": "input_selectfru_frutab",
    "fru_controller_enclosure": "input_selectfru_controllerEnclosureSelectedRow",
    "fru_disk_enclosure": 'input_selectfru_diskEnclosureSelectedRow',
    "fru_exp_board": "input_selectfru_expBoardtab",
    "fru_front_end_interface": "input_selectfru_frontEndIntftab",
    "fru_manage_board": "input_selectfru_manageBoardtab",
    "fru_pcie_switch": "input_selectfru_pcieSwitchtab",
    "fru_ip_scale_out_cable": "input_selectfru_frutab_port",
    "fru_ip_scale_out_fibre_module": "input_selectfru_frutab",
    "fru_ip_scale_out_switch": "input_selectfru_ipScaleOutSwitchtab",
    "fru_express_acc": "input_selectfru_expressAcctab",
    "fru_manage_fan_ctrl_board": "input_selectfru_mgmtfanctrlSelectedRow",
    "fru_memory": "input_selectfru_memorySelectedRow",
    "fru_bbu": "input_selectfru_frutab",
    "fru_xpu": "input_selectfru_controllerSelectedRow",
    "fru_back_end_fibre": "input_selectfru_frutab",
    "fru_cable_sas": "input_selectfru_frutab_port",
    "fru_disk_drawer": "input_selectfru_diskDrawerSelectedRow",
    "fru_other_interface": "input_selectfru_otherIntftab",
    "fru_box_disk": "input_selectfru_boxDisktab",
    "fru_box_intf": "input_selectfru_boxIntftab",
    "fru_system_disk":"input_selectfru_controllerSelectedRow",
}


class ExecuteEnv(object):
    def __init__(self, **kwargs):
        """
        供后续能力拓展 scene_value示例
        健康检查：
            'scene_value': u'{"mainScene":"Routine Maintain","subScene":"Daily Checks","field":"Storage",
            "stepID":"Inspector", "stepTitleEn":"Inspection"}
        巡检：
            'scene_value': u''
        备件更换后巡检：
            'scene_value': u'{"mainScene":"Parts Replacement","subScene":"FRU Replacement","field":"Storage",
            "stepID":"Inspector","stepTitleEn":"Inspection"}'
        扩容评估场景：
            'scene_value': u'{"mainScene":"Expansion","subScene":"Expansion Evaluation","field":"Storage",
            "stepID":"PerInspector","stepTitleEn":"Expansion Evaluation"}'
        扩容后巡检（扩容硬盘、硬盘框、硬盘柜场景）：
            scene_value={'stepTitleEn': 'Post-Expansion Inspection', 'stepID': 'PostInspector',
            'mainScene': 'Expansion', 'field': 'Storage', 'subScene': 'Expansion Disk'}
        """
        self.scenario = str(kwargs.get("scenario", ""))
        self.tool_name = str(kwargs.get("tool_name", ""))
        self.step = str(kwargs.get("step", ""))
        self.scene_value = ast.literal_eval(str(kwargs.get("scene_value", ""))) if kwargs.get("scene_value") else {}
        self.ori_env = kwargs.get("ori_env")

    @classmethod
    def to_py_env(cls, java_env):
        get_fun_list = [name for name in dir(java_env) if name.startswith("get") and name != "getClass"]
        params = {}
        log.info("fun_list:{}".format(get_fun_list))
        for fun in get_fun_list:
            params[cls.get_lower_case_name(fun[3:])] = getattr(java_env, fun)()
        params["java_env"] = java_env
        return cls(**params)

    @staticmethod
    def get_lower_case_name(text):
        lst = []
        for index, char in enumerate(text):
            if char.isupper() and index != 0:
                lst.append("_")
            lst.append(char)

        return "".join(lst).lower()


class UpgradeExecuteEnv(ExecuteEnv):
    def __init__(self, **kwargs):
        super(UpgradeExecuteEnv, self).__init__(**kwargs)
        self.upgrade_pkg_path = kwargs.get("upgrade_pkg_path")
        self.upgrade_pkg_version = kwargs.get("upgrade_pkg_version")
        self.target_version = kwargs.get("target_version")
        self.upgrade_mode = kwargs.get("upgrade_mode")
        self.java_env = kwargs.get("java_env")


class InspectExecuteEnv(ExecuteEnv):
    pass


class ExpansionExecuteEnv(ExecuteEnv):
    def __init__(self, **kwargs):
        super(ExpansionExecuteEnv, self).__init__(**kwargs)
        self.origin_ctrl_num = ""
        self.new_ctrl_num = ""
        self.net_work_type = ""


class FruExecuteEnv(ExecuteEnv):
    def __init__(self, **kwargs):
        super(FruExecuteEnv, self).__init__(**kwargs)
        self.origin_ctrl_num = ""
        self.new_ctrl_num = ""
        self.net_work_type = ""
        self.selected_fru = self.get_selected_fru()

    def get_selected_fru(self):
        if not self.ori_env:
            log.info("ori env is none.")
            return ""
        select_key = FRU_TYPE_DICT.get(self.tool_name, '')
        log.info("select_key={}".format(select_key))
        if select_key:
            return self.ori_env.get(select_key)
        return ""
