# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.

import json
import sys

from psdk.platform.entity.py_task import PyTask
from psdk.platform.entity.base_context import BaseContext
from psdk.platform.base.logger import log
from psdk.platform.adapter import java_common


def execute_py_task(java_task, call_back=None):
    return PyTaskExecutor().run(java_task, call_back), ""


class PyTaskExecutor(object):
    """
    任务执行器
    找指定模块->PyTaskService->指定方法进行执行
    因此要对Java提供方法，必须在PyTaskService类中去实现
    """

    def run(self, java_task, call_back=None):
        py_task = PyTask.to_py_task(java_task)
        if py_task.sys_path:
            sys.path.append(py_task.sys_path)
        node_file = __import__(py_task.module_path, fromlist=["None"])
        base_context = self.get_base_context(py_task)
        if call_back:
            py4j_service = getattr(node_file, "PyTaskService")(base_context, call_back)
        else:
            py4j_service = getattr(node_file, "PyTaskService")(base_context)
        result = getattr(py4j_service, py_task.method_name)(*py_task.args, **py_task.kwargs)
        call_back and call_back.finish(json.dumps(result))
        return json.dumps(result)

    @staticmethod
    def get_base_context(py_task):
        base_context = BaseContext(py_task.java_dev, py_task.execute_env)
        base_context.logger = log
        base_context.lang = java_common.get_lang()
        return base_context
