# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2024-2024. All rights reserved.

from psdk.platform.util import json_util

from com.huawei.ism.tool.protocol.rest import RestConnectionManager
import com.huawei.ism.tool.protocol.utils.RestUtil as RestUtil


def get_a800_dme_rest_response(dme_node, method, uri, param_dict):
    """
    获取A800 DME接口的响应
    @param dme_node: dme设备信息
    @param method: 执行方法
    @param uri: 接口地址
    @param param_dict: 接口参数
    @return: 接口响应
    """
    connection = RestConnectionManager.getRestConnection(dme_node)
    RestUtil.getBaseUri(dme_node)
    url = RestUtil.getBaseUri(dme_node) + uri
    param_json = json_util.covert_dict_to_json(param_dict)
    response_str = ""
    if method == "GET":
        response_str = connection.execGet(url, param_json).getContent()
    elif method == "POST":
        response_str = connection.execPost(url, param_json).getContent()
    elif method == "PUT":
        response_str = connection.execPut(url, param_json).getContent()
    return json_util.covert_json_to_dict(response_str)
