# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2021. All rights reserved.
from psdk.platform.resource.common_resource import MESSAGES_DICT


def ignore_all_exception(fun):
    def inner(*params):
        try:
            return fun(*params)
        except Exception:
            pass

    return inner


def format_msg(origin_msg, *args, **kwargs):
    """消息国际化

    :param origin_msg: 消息
    :param args: 消息参数
    :return: 经过国际化处理后的消息
    """
    try:
        if not args and not kwargs:
            return origin_msg
        if args:
            return origin_msg.format(*args)
        if kwargs:
            return origin_msg.format(**kwargs)
        return origin_msg
    except Exception:
        return origin_msg


def get_common_msg(lang, msg_key, *args):
    msg = MESSAGES_DICT.get(msg_key).get(lang)
    return format_msg(msg, *args)
