<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template match="/">
 <html>
 <head>
<style type="text/css">
	body{
		font-size:13px;
		background-color:#FFF;
	}
	
	table,td,th
	{
		border:1px solid #868686;
		border-collapse:collapse;
	}
	
	th
	{
		background:#E1E1E1;
	}
</style>
 </head>
  <body>
  <h2><xsl:value-of select="checklist/res/checkrule"/></h2>
  <table>
   <tr>
      <th width="5%"><xsl:value-of select="checklist/res/id"/></th>
      <th width="10%"><xsl:value-of select="checklist/res/name"/></th>
      <th width="25%"><xsl:value-of select="checklist/res/method"/></th>
      <th width="20%"><xsl:value-of select="checklist/res/criterion"/></th>
      <th width="20%"><xsl:value-of select="checklist/res/suggestion"/></th>
   </tr>

   <xsl:for-each select="checklist/item">
	<xsl:choose>
		<xsl:when test="@type='type'">
			<tr >
				<td bgcolor="#5EBBE8" colspan="5"><b><xsl:value-of select="name"/></b></td>
			</tr>
		</xsl:when>
	    <xsl:otherwise>
			<tr>
			  <td>
				<a><xsl:attribute name="name"><xsl:value-of select="./@id" /></xsl:attribute></a>
				<xsl:value-of select="./@index"/>
			  </td>
			  <td><b><xsl:value-of select="name"/></b></td>
			  <td><xsl:value-of select="method"/></td>
			  <td><xsl:value-of select="criterion"/></td>
			  <td><xsl:value-of select="suggestion"/></td>
			</tr>
	    </xsl:otherwise>
	</xsl:choose>
   </xsl:for-each>

  </table>
 </body>
 </html>
</xsl:template>
</xsl:stylesheet>