# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import common
import dpa_common
from common_utils import get_dpa_rest_record

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
COUNT = 15


def execute(dpa_rest):
    err_msg = ""
    job_list, record = dpa_common.get_backup_job_list(dpa_rest)
    if not job_list:
        err_msg += common.getMsg(LANG, "dpa.get.backup.job.list.abnormal")
    for job in job_list:
        if not job.get("jobDataRetentionPolicy"):
            err_msg += common.getMsg(LANG, "dpa.standard.backup.retention.policy.abnormal",
                                     (job.get("jobId"), job.get("jobName")))
    if err_msg:
        return False, record, err_msg
    return True, record, err_msg
