# -*- coding: UTF-8 -*-
#  Copyright (c) Huawei Technologies Co., Ltd. 2023-2023. All rights reserved.

import common
from common_utils import get_dpa_rest_record

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(dpa_rest):
    err_msg = ""
    node_query_uri = "/clusters/nodes"
    record = get_dpa_rest_record(dpa_rest, node_query_uri)
    node_info_list = record.get("responseData", {}).get("data")
    if not node_info_list:
        err_msg += common.getMsg(LANG, "query.result.abnormal")
        return False, record, err_msg
    for node_info in node_info_list:
        node_ip = node_info.get("nodeIp")
        node_status = node_info.get("status")
        if not node_ip or not str(node_status).isdecimal():
            err_msg += common.getMsg(LANG, "query.result.abnormal")
            return False, record, err_msg
        if node_status != 1:
            err_msg += common.getMsg(LANG, "dpa.node.status.abnormal", (node_ip, node_status))
            LOGGER.logNoPass("The status of node [{}] is abnormal (Node Status:{})".format(node_ip, node_status))
    if not err_msg:
        return True, record, err_msg
    return False, record, err_msg
