# -*- coding: UTF-8 -*-
import common
from cbb.frame.base import config
from cbb.frame.cli import cliUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

VERSION = [
    "V300R006C10SPC100", "V500R007C00SPC100",
    "V300R006C10", "V500R007C00", "6.0.RC1"
]
HAS_PATCH_VERSION = {
    "V300R006C10SPC100": "V300R006C10SPH102",
    "V500R007C00SPC100": "V500R007C00SPH102"
}
PRODUCT_MODEL = {
    "6.0.RC1": config.DORADO_DEVS_V6
}


def execute(cli):
    """检查项名称：扩控前白名单检查
    检查项ID：sysctrl_v5r7c00_expand_check_hotpatch
    :param cli:
    :return:
    """
    cli_ret = ""
    err_msg = ""

    try:
        # 获取设备当前产品版本和补丁信息
        check_ret, current_version_dict_list, hot_patch_version_dict_list = \
            common.parse_upgradePackage(cli, LANG)
        cli_ret += check_ret[1]
        if check_ret[0] is not True:
            LOGGER.logSysAbnormal()
            return check_ret[0], cli_ret, check_ret[2]
        
        result, current_version, err_msg = \
            common.getCurrentVersion(current_version_dict_list, LANG)
        if not result:
            return cliUtil.RESULT_NOCHECK, cli_ret, err_msg
        
        result, cur_hot_patch_ver, err_msg = \
            common.getCurrentVersion(hot_patch_version_dict_list, LANG)
        if not result:
            return cliUtil.RESULT_NOCHECK, cli_ret, err_msg
        
        if current_version not in VERSION:
            return True, cli_ret, ""
        
        if current_version in HAS_PATCH_VERSION:
            if cur_hot_patch_ver == "--":
                err_msg = common.getMsg(LANG, "exp.ctrl.sys.ver.null")
                return False, cli_ret, err_msg
            
            if cur_hot_patch_ver < HAS_PATCH_VERSION.get(current_version):
                err_msg = common.getMsg(
                    LANG, "exp.ctrl.patch.ver.error", cur_hot_patch_ver)
                return False, cli_ret, err_msg
            return True, cli_ret, ""

        # dorado v6高端设备RC1不支持扩控
        result, product_model, err_msg = cliUtil.getProductModel(cli, LANG)
        if result is not True:
            return cliUtil.RESULT_NOCHECK, cli_ret, err_msg

        if current_version in PRODUCT_MODEL:
            product_model_list = PRODUCT_MODEL.get(current_version)
            if product_model not in product_model_list:
                return True, cli_ret, ""
            
        err_msg = common.getMsg(
            LANG, "exp.ctrl.sys.ver.error", current_version)
        return False, cli_ret, err_msg
        
    except Exception as exception:
        LOGGER.logException(exception)
        err_msg = common.getMsg(LANG, "query.result.abnormal")
        return cliUtil.RESULT_NOCHECK, cli_ret, err_msg
