# -*- coding: UTF-8 -*-
import cliUtil
import common
import expandconfig
import time

#进度总剩余时间
LIMIT_TIME = 120
#进度刷新间隔
INTERVAL = 2

expConfigObj = expandconfig.ExpandConfig(py_java_env)
LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
CHECK_TIME = 60

def execute(cli):
    allCliRet = ""
    errMsg = ""
    flag = True

    # 进度条刷新
    common.threadUpProcess(py_java_env, LIMIT_TIME, INTERVAL, LOGGER)
    # 进度开始
    common.inProcess(py_java_env)
    LOGGER.logInfo("process Thread started!")

    try:
        expDiskInfo = expConfigObj.getExpDiskInfo()
        #新建硬盘域通过
        if not expDiskInfo:
            LOGGER.logInfo("Dont select the disk domain.")
            return True, allCliRet, errMsg

        #检查补丁版本是否V300R001C21SPH109及之后的版本
        verFlag, verRet, verMsg = checkPatchVersion(cli)
        allCliRet += verRet
        errMsg += verMsg
        if verFlag is not False:
            return verFlag, allCliRet, errMsg

        #获取控制器ID
        domainIds = sorted(expDiskInfo.keys())
        for domainId in domainIds:
            result, cliRet, msg, diskInDomainInfo = common.getDomainInfoById(cli, domainId, LANG)
            allCliRet += cliRet
            if result != True:
                errMsg += msg
                flag = common.getResult(flag, cliUtil.RESULT_NOCHECK)
                continue

            result,ret,msg = checkTask(cli, diskInDomainInfo)
            flag = common.getResult(flag, result)
            allCliRet += ret
            errMsg += msg
        return flag, allCliRet, errMsg

    except Exception, exception:
        LOGGER.logException(exception)
        return cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal")
    finally:
        common.finishProcess(py_java_env)
        LOGGER.logInfo("finish process!")

def checkTask(cli,diskInDomainInfo):
    cliRet = ""
    errMsg = ""
    flag = True

    domainId = diskInDomainInfo.get("ID", "")
    ctrlInfo = diskInDomainInfo.get("Controller", "")
    ctrlList = ctrlInfo.split(",")
    if not domainId or not len(ctrlList):
        errMsg = common.getMsg(LANG, "cannot.get.domain.info")
        return cliUtil.RESULT_NOCHECK,cliRet,errMsg

    for ctrl in ctrlList:
        ret = ""
        checkFlag = True
        startTime = time.time()
        while (checkFlag and time.time() - startTime <= CHECK_TIME):
            cmd = "show zone_rebuild info info_type=task_count pool_id=%s controller=%s" %(domainId, ctrl)
            result, ret, msg = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
            if result != True:
                errMsg += common.getMsg(LANG, "cannot.get.domain.ctrl.task.info", (ctrl, domainId))
                flag = common.getResult(flag, cliUtil.RESULT_NOCHECK)
                checkFlag = False
                break

            cliList = cliUtil.getHorizontalCliRet(ret)
            if not cliList:
                errMsg += common.getMsg(LANG, "cannot.get.domain.task.info", domainId)
                flag = common.getResult(flag, cliUtil.RESULT_NOCHECK)
                checkFlag = False
                break

            for info in cliList:
                stepName = info.get("Step Name","")
                if "REB_DEL_DISKTASK" not in stepName:
                    continue

                notBack = info.get("Not Back",None)
                if notBack == "0":
                    checkFlag = False
                break

            common.safeSleep(2)

        cliRet += ret
        if checkFlag:
            flag = False
            errMsg += common.getMsg(LANG, "cannot.get.domain.ctrl.task.abnormal", (ctrl, domainId))

    return flag,cliRet,errMsg


def checkPatchVersion(cli):
    # 获取设备当前补丁信息
    checkRet, _, hotPatchVersionDictList = common.parse_upgradePackage(cli, LANG)
    if checkRet[0] != True:
        LOGGER.logSysAbnormal()
        return cliUtil.RESULT_NOCHECK, checkRet[1], checkRet[2]

    result, curHotPatchVer, errMsg = common.getCurrentVersion(hotPatchVersionDictList, LANG)
    if not result:
        return cliUtil.RESULT_NOCHECK, checkRet[1], errMsg

    if curHotPatchVer >= "V300R001C21SPH109":
        return cliUtil.RESULT_NOSUPPORT, checkRet[1], ""

    return False, checkRet[1], ""

