# --*-- coding: utf-8 --*--

import common
import cliUtil

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    cliRet = ""
    cliRetAll = ""
    errMsg = ""
    try:
        NO_LIMITI_VERSION = "V300R003C20SPC200"
        #版本限制，V300R003C20SPC200之后版本不做检查
        checkRet, currentVersionDictList, _ = common.parse_upgradePackage(cli, LANG)
        cliRet += checkRet[1]
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return (cliUtil.RESULT_NOCHECK, cliRet ,checkRet[2])
        
        result, currentVersion, errMsg = common.getCurrentVersion(currentVersionDictList, LANG)
        if not result:
            return (cliUtil.RESULT_NOCHECK, cliRet , errMsg)
        
        if currentVersion >= NO_LIMITI_VERSION:
            return (True, cliRet , errMsg)
            
        #查看是否存在SmartIO IO卡（4 port SmartIO I/O Module）
        flag, cliRet, errMsg, modulePortIdList= cliUtil.existSmartIoCard(cli,LANG)
        cliRetAll += cliRet
        if flag != True :
            return (cliUtil.RESULT_NOCHECK, cliRetAll , errMsg)
        
        #获取设备型号
        flag, product_model, cliRet, errMsg = cliUtil.getProductModelWithCliRet(cli, LANG)
        cliRetAll += cliRet
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, cliRetAll , checkRet[2]) 
            
        #获取FC卡Working Mode为Point To Point的端口ID
        flag, cliRet, errMsg, fcFortIdList = getFcInfo(cli)
        cliRetAll += cliRet
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, cliRetAll ,errMsg)
        
        bugFcPortIdList = []
        #判断是否可能存在版本卡场景，设备型号为5500 V3且产品版本为V300R002C00到V300R003C20SPC200
        if product_model == "5500 V3":
            #过滤出非板载卡的有效端口ID
            for fcPortId in fcFortIdList:
                Index = fcPortId.rindex(".")
                if fcPortId[:Index] in modulePortIdList or "H" in fcPortId:
                    bugFcPortIdList.append(fcPortId)
                    
        else:
            #过滤FC卡ID是否属于接口卡
            for fcPortId in fcFortIdList:
                Index = fcPortId.rindex(".")
                if fcPortId[:Index] in modulePortIdList:
                    bugFcPortIdList.append(fcPortId)
                    
        #FC卡端口的WWN的5~10位是0000C9；000A33；000E03；00109B；0090FA；00E0D5之一，则为Emulex厂商HBA卡
        if bugFcPortIdList:
            flag, cliRet, errMsg = checkFcPort2HBA(cli, bugFcPortIdList, currentVersion)
            cliRetAll += cliRet
        
        return (flag, cliRetAll, errMsg)
    
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(LANG, "query.result.abnormal"))
          

def getFcInfo(cli):
    '''
    @执行命令show port general physical_type=FC，获取Working Mode为Point To Point的端口ID
    '''
    #获取命令回显
    portIdList = []
    cmd = 'show port general physical_type=FC'
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    if flag != True:
        return (flag, cliRet, errMsg, portIdList)
    
    if cliUtil.queryResultWithNoRecord(cliRet):
        return (flag, cliRet, errMsg, portIdList)
    
    fcDictList = cliUtil.getHorizontalCliRet(cliRet)
    if len(fcDictList) == 0:
        errMsg = common.getMsg(LANG, "cannot.get.port.info","FC")
        return (False, cliRet, errMsg, portIdList)
    
    for fcInfo in fcDictList:
        workingMode = fcInfo.get("Working Mode")
        if workingMode == "Point To Point":
            portId = fcInfo.get("ID")
            portIdList.append(portId)
            
    return (True, cliRet, errMsg, portIdList)
    
def checkFcPort2HBA(cli, portIdList, currentVersion):
    '''
    @检测FC卡是否存在直连HBA卡
    ''' 
    cliRetAll = ""
    errMsgAll = ""
    checkFlag = True
    HBA_WWN_LIST = ["0000C9","000A33","000E03","00109B","0090FA","00E0D5"]
    for id in portIdList:
        cmd = "show port initiator port_type=FC port_id=%s" %id
        flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        cliRetAll += cliRet
        if flag != True:
            if currentVersion in ["V300R002C10","V300R002C10SPC100"]:
                errMsg = common.getMsg(LANG, "has.not.cli.privilege")
            return (cliUtil.RESULT_NOCHECK, cliRetAll, errMsg)
        
        fcDictList = cliUtil.getHorizontalCliRet(cliRet)
        if len(fcDictList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.port.info" ,id)
            LOGGER.logNoPass("Cannot get information about WWN of FC")
            return (cliUtil.RESULT_NOCHECK, cliRetAll, errMsg)
        
        for info in fcDictList:
            wwn = info.get("WWN","")
            if wwn[4:10].upper() in HBA_WWN_LIST:
                checkFlag =  False
                errMsgAll += common.getMsg(LANG, "port.wwn.is.HBA",(id,wwn))
                
    return (checkFlag, cliRetAll, errMsgAll)        
        