# -*- coding: UTF-8 -*-
import cliUtil
import common
import hardware
import config

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    '''
         引擎状态检查：
                 所有控制器均在线，Health Status为Normal且Running Status为Online表示正常，其它情况均属于不正常状态。
    '''
    flag = True
    sn_flag = ""
    cliRet = ""
    errMsg = ""

    try:
        cmd = r"show controller general|filterColumn include " \
              r"columnList=Controller,Health\sStatus,Running\sStatus,Electronic\sLabel"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG, cliUtil.endWithSignToAdmin)
        if checkRet[0] != True:
            LOGGER.logSysAbnormal()
            return checkRet

        cliRet = checkRet[1]
        cliRetLinesList = cliUtil.getVerticalCliRetFilterElabel(cliRet, False)
        if len(cliRetLinesList) == 0:
            errMsg = common.getMsg(LANG, "cannot.get.controller.info")
            LOGGER.logNoPass("Cannot get information about controller")
            return (False, cliRet, errMsg)

        engineList = []
        engineSlotDict = {}
        isPrintBomCodeFlag = False  # 是否已经打印BOM编码标记
        eLabel = hardware.getCtrlBOMCode(cliRet)  # 获取控制器的BOM编码
        devType = str(py_java_env.get("devInfo").getDeviceType())
        LOGGER.logInfo("getDeviceType:%s" % devType)
        riskDevTypeList = ["2200 V3", "2600 V3", "2100 V3", "5300 V5"]

        if len(eLabel) == 0:
            eLabel = 'Unknown'
        for retDict in cliRetLinesList:
            ctrlId = retDict.get("Controller").strip()
            healthStatus = retDict.get("Health Status")
            runningStatus = retDict.get("Running Status")
            electronicLabel = retDict.get("Electronic Label", "")
            LOGGER.logInfo("electronicLabel:%s" % electronicLabel)
            engineId = ctrlId[:-1]
            slot = ctrlId[-1]
            engineList.append(engineId)

            if engineSlotDict.has_key(engineId):
                slots = engineSlotDict.get(engineId).append(slot)
                engineSlotDict.setdefault(engineId, slots)
            else:
                engineSlotDict.setdefault(engineId, [slot])

            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "controller.health.status.abnormal", (ctrlId, healthStatus))
                LOGGER.logNoPass(
                    "The Health Status of Controller [%s] is abnormal (Health Status:%s)" % (ctrlId, healthStatus))
                isPrintBomCodeFlag = True
                errMsg += common.getMsg(LANG, "hardware.bom.info", (ctrlId, eLabel))
                LOGGER.logNoPass("The Hardware ID: [%s] BOMCode:%s" % (ctrlId, eLabel))
            if runningStatus != common.STATUS_ONLINE:
                flag = False
                errMsg += common.getMsg(LANG, "controller.running.status.abnormal", (ctrlId, runningStatus))
                LOGGER.logNoPass(
                    "The Running Status of Controller [%s] is abnormal (Running Status:%s)" % (ctrlId, runningStatus))
                isPrintBomCodeFlag = True
                errMsg += common.getMsg(LANG, "hardware.bom.info", (ctrlId, eLabel))
                LOGGER.logNoPass("The Hardware ID: [%s] BOMCode:%s" % (ctrlId, eLabel))

            electronicLabelList = electronicLabel.split(" ")
            barCode = 'Unknown'
            for line in electronicLabelList:
                if "BarCode" in line:
                    tmpList = line.split("=")
                    if len(tmpList) == 2:
                        barCode = tmpList[1].strip()
                        break

            LOGGER.logInfo("barCode:%s" % barCode)
            if devType in riskDevTypeList:
                LOGGER.logInfo("devType is risk.")
                if barCode in config.RISK_CONTROLLER_SN:
                    LOGGER.logInfo("barCode is risk.")
                    errMsg += common.getMsg(LANG, "controller.barcode.risk", ctrlId)
                    sn_flag = cliUtil.RESULT_WARNING

        isSiglePdtModel = common.isSigleModel(cli, LANG)
        if not isSiglePdtModel:
            for engine in set(engineList):
                slots = engineSlotDict.get(engine)
                controllerId = ", ".join([(engine + slot) for slot in slots])
                if slots not in (["A", "B"], ["A", "B", "C", "D"]):
                    flag = False
                    errMsg += common.getMsg(LANG, "engine.may.be.offline", engine)
                    LOGGER.logNoPass("The controller in the engine [%s] may be offline (%s)" % (engine, controllerId))
                    if isPrintBomCodeFlag == False:
                        errMsg += common.getMsg(LANG, "normalhardware.bom.info", (controllerId, eLabel))
                        LOGGER.logNoPass("The Normal Hardware ID: [%s] BOMCode:%s" % (controllerId, eLabel))

        if flag:
            LOGGER.logPass()
            if sn_flag:
                return sn_flag, cliRet, errMsg

        return flag, cliRet, errMsg

    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
