# -*- coding: UTF-8 -*-
import cliUtil
import common

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)
MIN_DISK_NUMBER = 18

def execute(cli):
    '''
        硬盘域成员盘数量检查
    '''
    # 获取用户填写的扩容列表
    expDiskList = common.getExpDiskListFromContextFilter(py_java_env)
    logger.logInfo("expDiskList is %s" % expDiskList)

    try:
        # 如果都是新建硬盘域,则不涉及
        if not expDiskList:
            return cliUtil.RESULT_NOSUPPORT, "", ""

        # 检查所有行 将检查结果收敛到硬盘域维度
        all_disk_domain_result = checkAllDiskDomain(cli, expDiskList)
        logger.logInfo("all_disk_domain_result is: %s" % str(all_disk_domain_result))

        # 根据所有硬盘域的检查结果 判断返回总的结果
        return getSummaryResult(all_disk_domain_result)

    except Exception, exception:
        logger.logException(exception)
        return cliUtil.RESULT_NOCHECK, cli_ret_all, common.getMsg(lang, "query.result.abnormal")

def getSummaryResult(all_disk_domain_result):
    """ 根据所有硬盘域的检查结果 汇总本次检查的最终结果
    1. 错误消息汇总是所有硬盘域错误消息的合并
    2. cli回显汇总是所有硬盘域cli回显的合并
    3. 最终检查结果 优先级为失败>未检查>成功 即所有硬盘域的检查结果 以优先级最高的为准

    :param all_disk_domain_result: 所有硬盘域的检查结果列表
    :return: 最终检查结果 cli回显汇总 错误消息汇总
    """

    err_msg_all = ""
    cli_ret_all = ""
    summary_result = ""

    for disk_domain_result in all_disk_domain_result:
        err_msg_all += disk_domain_result["err_msg"]
        cli_ret_all += disk_domain_result["cli_ret"]
        # 返回结果的优先级 失败>未检查>成功
        if summary_result == "":
            summary_result = disk_domain_result["check_result"]
        elif summary_result is True and disk_domain_result["check_result"] in [False, cliUtil.RESULT_NOCHECK]:
            summary_result = disk_domain_result["check_result"]
        elif summary_result == cliUtil.RESULT_NOCHECK and disk_domain_result["check_result"] is False:
            summary_result = disk_domain_result["check_result"]
        else:
            continue

    return summary_result, cli_ret_all, err_msg_all

def getDiskNumber(cli_ret):
    """根据cli的回显结果获取成员盘数量

    :param cli_ret: cli的回显结果
    :return: 成员盘数量 整数或者None
    """
    cli_ret_list = cli_ret.encode("utf8").splitlines()

    for line in cli_ret_list:
        if "Disk Number" in line:
            fields = line.split(":")
            if len(fields) < 2:
                continue
            if fields[0].strip() == "Disk Number":
                disk_number = int(fields[1].strip())
                return disk_number

    return None

def checkAllDiskDomain(cli, expDiskList):
    """检查界面中选择的所有行涉及到的硬盘域 并将检查结果收敛到硬盘域维度

    :param cli: cli连接
    :param expDiskList: 界面选择的行列表
    :return: 所有硬盘域的检查结果列表
    """

    checked_disk_domain_id_list = []
    checked_disk_domain_list = []

    for expDiskDict in expDiskList:
        checked_dd_item = {}
        err_msg = ""
        check_result = ""
        # 忽略新建硬盘域场景
        eng = expDiskDict.get("eng")
        if eng == "new":
            continue
        # 获取硬盘域ID
        disk_domain_id = expDiskDict.get("diskDomain")

        # 如果硬盘域id为空或者已经检查过了 则继续下一行
        if disk_domain_id is None or disk_domain_id in checked_disk_domain_id_list:
            continue

        # 下发CLI命令获取硬盘域成员盘数量
        cmd = "show disk_domain general disk_domain_id=%s" % disk_domain_id
        flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)

        if flag is not True:
            # 命令返回失败 本硬盘域检查结果为未检查
            err_msg = common.getMsg(lang, "obtain.dd.info.failed", disk_domain_id)
            check_result = cliUtil.RESULT_NOCHECK
        else:
            disk_number = getDiskNumber(cli_ret)
            if disk_number is None:
                # 命令返回内容中无法获取成员盘数量 本硬盘域检查结果为未检查
                err_msg = common.getMsg(lang, "obtain.dd.info.failed", disk_domain_id)
                check_result = cliUtil.RESULT_NOCHECK
            elif disk_number <= MIN_DISK_NUMBER:
                # 成员盘数量小于等于18 本硬盘域检查结果为失败
                err_msg = common.getMsg(lang, "check.dd.member.disk.failed",
                                        (disk_domain_id, disk_number, MIN_DISK_NUMBER))
                check_result = False
            else:
                # 成员盘数量大于18 本硬盘域检查结果为成功
                err_msg = ""
                check_result = True

        # 将本次检查的硬盘域和检查结果放入列表中
        checked_disk_domain_id_list.append(disk_domain_id)
        checked_dd_item["disk_domain_id"] = disk_domain_id
        checked_dd_item["check_result"] = check_result
        checked_dd_item["err_msg"] = err_msg
        checked_dd_item["cli_ret"] = cli_ret
        checked_disk_domain_list.append(checked_dd_item.copy())

    return checked_disk_domain_list

