# -*- coding: UTF-8 -*-
import cliUtil
import common
import xlrd
import os
import expandconfig
from cbb.business.operate.expansion import common as exp_common

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)
expConfigObj = expandconfig.ExpandConfig(py_java_env)

DORADO_CONFIG_FILE_NAME = (r'DORADO_EXP_RECOM_CONFIG_C01.xls', r'DORADO_EXP_RECOM_CONFIG_C21.xls')

ENV_EXP_RECOM_CONFIG_DATA = "dorado_exp_capacity_cut_config_data"

SHEET_NAMES = ("Dorado6000SAS","Dorado5000SAS","Dorado5000NVME","Dorado5000SASENH","Dorado6000SASENH")

SUPPORT_ENHANCE_VERSIONS = ("C21", "C30")

RECOM_DATA_CRITICAL_VALUE = 120

sysVerCfgDataMapping={
    "C01" : DORADO_CONFIG_FILE_NAME[0],
    "C21" : DORADO_CONFIG_FILE_NAME[1],
    "C30" : DORADO_CONFIG_FILE_NAME[1],
}

diskCapType={
    "600GB":0,
    "900GB":1,   
    "1800GB":2,   
    "3600GB":3,   
    "1000GB":4,
    "2000GB":5,
    "4000GB":6,
    "7680GB":7,
}

capMapping = {
    600 : "600GB",
    900 : "900GB",
    1800 : "1800GB",
    3600 : "3600GB",
    7680 : "7680GB",
    1000 : "1000GB",
    2000 : "2000GB",
    4000 : "4000GB",
}

capMappingFor960N = {
    (960, 0) : "900GB",
    (1920, 0) : "1800GB",
    (3840, 0) : "3600GB",
    (960, 1) : "1000GB",
    (1920, 1) : "2000GB",
    (3840, 1) : "4000GB",
}

maxSingleEngDiskNum={
    "C01":
        {
            ("Dorado5000 V3", "NVME"):25,
            ("Dorado5000 V3", "SAS"):100,
            ("Dorado6000 V3", "SAS"):100,
        },
    "C21":
        {
            ("Dorado5000 V3", "NVME"):25,
            ("Dorado5000 V3", "SAS"):100,
            ("Dorado6000 V3", "SAS"):300,
            ("Dorado5000 V3", "ENH"):100,
            ("Dorado6000 V3", "ENH"):300,
            ("Dorado18000 V3", "ENH"):200,
            ("Dorado18000 V3", "SAS"):200,
        },
    "C30":
        {
            ("Dorado5000 V3", "NVME"):25,
            ("Dorado5000 V3", "SAS"):100,
            ("Dorado6000 V3", "SAS"):300,
            ("Dorado5000 V3", "ENH"):100,
            ("Dorado6000 V3", "ENH"):300,
            ("Dorado18000 V3", "ENH"):200,
            ("Dorado18000 V3", "SAS"):200,
        },
}

#进度总剩余时间
LIMIT_TIME = 120
#进度刷新间隔
INTERVAL = 2

def execute(cli):
    '''
        扩容硬盘容量规格检查
    '''
    cliRetAll = ""
    versionList = ["V300R001C01SPC100", "V300R001C21", "V300R001C21SPC100", "V300R001C30", "V300R001C30SPC100"]
    expDiskList = common.getExpDiskListFromContextFilter(py_java_env)
    logger.logInfo("expDiskList is %s" % expDiskList)
    
    try:
        if not expDiskList:
            return cliUtil.RESULT_NOSUPPORT, "", ""
        
        #进度条刷新
        common.threadUpProcess(py_java_env, LIMIT_TIME, INTERVAL, logger)
        #进度开始
        common.inProcess(py_java_env)
        logger.logInfo("process Thread started!")
        
        ret, sysVersionList, __ = common.parse_upgradePackage(cli, lang)
        cliRet = ret[1]
        if not ret[0]:
            return cliUtil.RESULT_NOCHECK, cliRet, ret[2]

        ret, sysVersion, errInfo = common.getCurrentVersion(sysVersionList,lang)
        logger.logInfo("current system version:%s" % (sysVersion))
        if not ret:
            errMsg = errInfo
            return cliUtil.RESULT_NOCHECK, cliRet, errMsg
        if sysVersion not in versionList:
            logger.logInfo("the current system version is not mentioned")
            return cliUtil.RESULT_NOSUPPORT, cliRet, ""

        cliRetAll += cliRet
        # 获取硬盘域信息
        flag, cliRet, errMsg, diskDomainList = common.getDiskDomainInfo(cli, lang)
        cliRetAll += cliRet
        if not flag:
            logger.logSysAbnormal()
            return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg

        # 硬盘域不存在返回不涉及
        if flag and not diskDomainList:
            logger.logInfo("the disk domain is not exist")
            return cliUtil.RESULT_NOSUPPORT, cliRetAll, ""
        logger.logInfo("diskDomainList is %s" % diskDomainList)
        
        # 如果是双引擎系统，但只选择了一个引擎进行扩容评估，检查不通过
        expDomainEngMap = {}
        expInfo = py_java_env.get("expInfo")
        expModeList = expInfo.getExpModeInfoList()
        logger.logInfo("The expInfo expModeList is %s" % str(expModeList))
        if len(expModeList) != 1:
            domainEngMap = {}
            for anExpMode in expModeList:
                anExpModeArray = anExpMode.split(":")
                domainEngMap[anExpModeArray[1]] = domainEngMap.get(anExpModeArray[1], 0) + 1
            logger.logInfo("The domainEngMap of expModeList is %s" % str(domainEngMap))
            
            for line in expDiskList:
                expDiskDomId = line.get("diskDomain")
                engineId = line.get("logicEng")
                
                strLogicEngId = str(engineId)
                
                if not expDomainEngMap.get(expDiskDomId):
                    expDomainEngMap[expDiskDomId] = [strLogicEngId]
                    continue
                
                if strLogicEngId not in expDomainEngMap[expDiskDomId]:
                    tmpExpDomainEngMapAry = expDomainEngMap.get(expDiskDomId)
                    tmpExpDomainEngMapAry.append(strLogicEngId)
                    expDomainEngMap[expDiskDomId] = tmpExpDomainEngMapAry
            logger.logInfo("The expDomainEngMap of expModeList is %s" % str(expDomainEngMap))
            checkFlag = True
            for expDiskDomId in expDomainEngMap.keys():
                if domainEngMap.get(expDiskDomId) != len(expDomainEngMap.get(expDiskDomId)):
                    logger.logNoPass("the double engines system need to config on each engine")
                    errMsg += common.getMsg(lang, "expand.disk.dualengine.not.pass", expDiskDomId)
                    checkFlag = False
                    continue
            if not checkFlag:
                return False, cliRetAll, errMsg
        else:
            expDiskDomId = expDiskList[0].get("diskDomain")
            engineId = expDiskList[0].get("logicEng")
            expDomainEngMap[expDiskDomId] = [engineId]

        # 如果为双引擎系统，两个引擎新扩容硬盘数量不一致或者两个引擎新扩容硬盘容量不一致，检查不通过
        engineDiskNumDict = {}
        engineDiskCapacityDict = {}
        expDiskDomIdAry = []
        for line in expDiskList:
            expDiskDomId = line.get("diskDomain")
            engineId = line.get("eng")
            diskNum = int(line.get("diskNum"))
            diskCapacity = str(line.get("diskCapacity"))
            capacityUnit = str(line.get("unit"))
            diskCapacity2GB = common.changUnit2GBLabelCap(diskCapacity + capacityUnit)
            engineDiskNumDict[(expDiskDomId, engineId)] = engineDiskNumDict.get((expDiskDomId, engineId), 0) + diskNum
            engineDiskCapacityDict[(expDiskDomId, engineId)] = engineDiskCapacityDict.get((expDiskDomId, engineId), 0) + diskCapacity2GB[1] * diskNum
            expDiskDomIdAry.append(expDiskDomId)
        
        logger.logInfo("engineDiskNumDict is %s" % engineDiskNumDict)
        logger.logInfo("engineDiskCapacityDict is %s" % engineDiskCapacityDict)
        
        for domId in set(expDiskDomIdAry):
            engineDiskNumInDomain = {}
            engineDiskCapacityInDomain = {}
            for anEngineDisk in engineDiskNumDict:
                if anEngineDisk[0] == domId:
                    engineDiskNumInDomain.update({anEngineDisk : engineDiskNumDict.get(anEngineDisk)})
            logger.logInfo("engineDiskNumInDomain is %s" % str(engineDiskNumInDomain))
            if len(set(engineDiskNumInDomain.values())) != 1:
                logger.logNoPass("the disk number of engines is inconsistent")
                errMsg = common.getMsg(lang, "expand.disk.number.not.pass")
                return False, cliRetAll, errMsg
            for anEngineDisk in engineDiskCapacityDict:
                if anEngineDisk[0] == domId:
                    engineDiskCapacityInDomain.update({anEngineDisk : engineDiskCapacityDict.get(anEngineDisk)})
            logger.logInfo("engineDiskCapacityInDomain is %s" % str(engineDiskCapacityInDomain))
            
            engineDiskCapacityListBase50GbDiff = common.getDiskCapListBaseOn50GBDiff(engineDiskCapacityInDomain.values())
            logger.logInfo("engineDiskCapacityListBase50GbDiff is %s" % engineDiskCapacityListBase50GbDiff)
            if len(set(engineDiskCapacityListBase50GbDiff)) != 1:
                logger.logNoPass("the disk capacity of engines is not consistent")
                errMsg = common.getMsg(lang, "expand.disk.capacity.not.pass")
                return False, cliRetAll, errMsg

        # 遍历硬盘域来检查
        for diskDomainId in set(expDiskDomIdAry):
            isQrySucc, cliRet, errInfo, diskInDomainList = common.getDiskDomainInfoById(cli, diskDomainId, lang)
            cliRetAll += cliRet
            if not isQrySucc:
                flag = False
                errMsg += errInfo
                return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg

            # 获取硬盘域中的硬盘类型
            diskTypeList = [disk["Type"]for disk in diskInDomainList]
            logger.logInfo("diskTypeList is %s" % diskTypeList)

            # 根据硬盘域ID获取对应的新扩硬盘类型
            newExpDiskList = filter(lambda disk:disk.get("diskDomain") == diskDomainId, expDiskList)
            logger.logInfo("newExpDiskList is %s" % newExpDiskList)

            newDiskModelList = [disk.get("diskModel") for disk in newExpDiskList]
            logger.logInfo("diskModelList is %s" % newDiskModelList)

            # 新扩容硬盘类型和已有硬盘域中的SSD硬盘类型(加密:SSDSED;非加密硬盘SSD等)不一致
            if len(set(diskTypeList)) == 1 and set(diskTypeList) != set(newDiskModelList):
                flag = False
                logger.logNoPass("the disk type of the system diskdomain is not consistent with the expanding diskType")
                errMsg += common.getMsg(lang, "expand.disk.type.not.pass")
                continue

            # 获取新扩容硬盘容量
            newDiskCapacityList = []
            for line in newExpDiskList:
                diskCapacity = str(line.get("diskCapacity"))
                capacityUnit = str(line.get("unit"))
                diskCapacityGB = common.changUnit2GB(diskCapacity + capacityUnit, True)
                newDiskCapacityList.append(diskCapacityGB[1])
            logger.logInfo("newDiskCapacityList is %s" % newDiskCapacityList)
            
            newDiskCapacityListBase50GbDiff = common.getDiskCapListBaseOn50GBDiff(newDiskCapacityList)
            logger.logInfo("newDiskCapacityListBase50GbDiff is %s" % newDiskCapacityListBase50GbDiff)
            # 同一批次新扩容的硬盘容量不止一种,检查不通过
            if len(set(newDiskCapacityListBase50GbDiff)) != 1:
                flag = False
                logger.logNoPass("The capacity of new expand disk is not consistent")
                errMsg += common.getMsg(lang, "expand.disk.capacity.not.pass")
                continue
            
            diskCapacityList = [] # 当前硬盘域(ID为diskDomainId)中所有硬盘的容量列表
            for disk in diskInDomainList:
                diskId = disk.get("ID") # 获取硬盘域中的硬盘ID
                isQrySucc, gbCap, errInfo = common.getDiskCapacityByDiskId(cli, diskId, lang, isHasLog=False)
                if not isQrySucc:
                    flag = False
                    errMsg += errInfo
                    continue
                diskCapacityList.append(gbCap)
            
            logger.logInfo("diskCapacityList is %s" % diskCapacityList)
            
            # 如果原系统硬盘域中只存在一种容量硬盘，并且大于新扩容硬盘容量，检查不通过。
            diskCapacityListBase50GbDiff = common.getDiskCapListBaseOn50GBDiff(diskCapacityList)
            logger.logInfo("diskCapacityList is %s" % diskCapacityListBase50GbDiff)
            if len(set(diskCapacityListBase50GbDiff)) == 1:
                orgDiskCapacity = diskCapacityListBase50GbDiff[0]
                newDiskCapacity = newDiskCapacityListBase50GbDiff[0]
                if orgDiskCapacity > newDiskCapacity:
                    flag = False
                    logger.logNoPass("The capacity disk is larger than new disk capacity")
                    errMsg += common.getMsg(lang, "expand.disk.capacity.scale1.not.pass",
                                            (newDiskCapacity, orgDiskCapacity))
                    continue

            # 如果原系统硬盘域存在两种容量硬盘，并且新扩容硬盘容量不等于原硬盘域中最大容量硬盘的容量，检查不通过。
            if len(set(diskCapacityListBase50GbDiff)) == 2:
                newDiskCapacity = newDiskCapacityListBase50GbDiff[0]
                originMaxDiskCapacity = max(diskCapacityListBase50GbDiff)
                if abs(newDiskCapacity - originMaxDiskCapacity) > 50.0:
                    flag = False
                    logger.logNoPass("The capacity of new expand disk is not equal to the max of disk capacity")
                    errMsg += common.getMsg(lang, "expand.disk.capacity.scale2.not.pass",
                                            (newDiskCapacity, originMaxDiskCapacity))
                    continue
            
            newAndOldDiskCapList = newDiskCapacityList + diskCapacityList
            newAndOldDiskCapListBase50GB = common.getDiskCapListBaseOn50GBDiff(newAndOldDiskCapList)
            logger.logInfo("newAndOldDiskCapList is %s" % newAndOldDiskCapList)
            logger.logInfo("newAndOldDiskCapListBase50GB is %s" % newAndOldDiskCapListBase50GB)

            isNvme = isNvmeDisk(newDiskModelList[0])
            isEnhanced = False
            cVersion = getCVersion(sysVersion)
            if cVersion in SUPPORT_ENHANCE_VERSIONS:
                isQrySucc, isEnhanced, isEnhErrMsg = common.isEnhancedVersion(cli, lang, isOrigin=True)
                if not isQrySucc:
                    flag = False
                    errMsg += isEnhErrMsg
                    return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg

            # 检查单引擎最大规格是否满足要求
            # 获取设备型号
            devInfo = common.getCurDeviceInfo(py_java_env)
            productModel = str(devInfo.getDeviceType())
            logger.logInfo("productModel=%s" % str(productModel))
            # 引擎最大硬盘数
            maxEngDiskNum = getMaxDisknum(cVersion, productModel, isEnhanced, isNvme)
            # 获取硬盘域中在每个引擎上的硬盘数
            engineDiskNumDic = getEngineDiskNumDic(diskInDomainList, productModel)
            # 引擎上新扩硬盘数字典
            newExpDiskNumDic = getNewExpDiskNumDic(newExpDiskList)
            for engineId in newExpDiskNumDic:
                if (engineDiskNumDic.get(engineId) + newExpDiskNumDic.get(engineId)) > maxEngDiskNum:
                    flag = False
                    logger.logNoPass("The condition of expand disk is not pass in single engine")
                    errMsg += common.getMsg(lang, "expand.disk.number.scale.not.pass",
                                            (engineId, newExpDiskNumDic.get(engineId), maxEngDiskNum))
                    continue

            # 原系统硬盘域存在一种容量，并且新扩容后硬盘容量为2，需要进行大下盘检查
            if len(set(diskCapacityListBase50GbDiff)) == 1 and len(set(newAndOldDiskCapListBase50GB)) == 2:
               # 大小盘检查
                expRecomConfigs = getRecomConfigData(cVersion)
                sheetDataKey = getSheetDataKey(productModel, isEnhanced, isNvme)
                logger.logInfo("The sheetDataKey is %s" % sheetDataKey)
                logger.logInfo("The expRecomConfigs is %s" % str(expRecomConfigs))
                recomConfigDict = expRecomConfigs.get(sheetDataKey)
                logger.logInfo("The expRecomConfigDict is %s" % str(recomConfigDict))
                for engineId in newExpDiskNumDic:
                    # 原系统的
                    baseNum = engineDiskNumDic.get(engineId)
                    # 输入新扩的
                    expDiskNum = newExpDiskNumDic.get(engineId)
                    # 原系统的
                    # 获取电子标签硬盘容量
                    diskId = diskInDomainList[0].get("ID")  # 获取硬盘域中的硬盘ID，因容量相同取第一块盘即可
                    isQrySucc, elabeldiskCapacity, errInfo = common.getDiskCapacityByDiskId(cli, diskId, lang,
                                                                                         isOrigin=True)
                    if not isQrySucc:
                        flag = False
                        errMsg += errInfo
                        return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg

                    logger.logInfo("The elabeldiskCapacity is %s" % str(elabeldiskCapacity))
                    baseDiskCapacity2GB = common.changUnit2GBLabelCap(elabeldiskCapacity)
                    baseCap = getDiskCapType(baseDiskCapacity2GB[1], isNvme)

                    if baseCap not in diskCapType.values():
                        flag = False
                        sortedDictKeyAry = getSortedCapacityTypeKeys()
                        errMsg += common.getMsg(lang,
                                                "check.dorado.expand.disk.orinsystem.capacity.not.mapping.not.pass",
                                                (diskDomainId, engineId, diskTypeList[0],str(elabeldiskCapacity), str(sortedDictKeyAry)))
                        continue

                    # 新扩控输入的
                    anExpDiskCapacity = str(newExpDiskList[0].get("diskCapacity"))
                    logger.logInfo("The anExpDiskCapacity is %s" % str(anExpDiskCapacity))
                    expCapacityUnit = str(newExpDiskList[0].get("unit"))
                    logger.logInfo("The expCapacityUnit is %s" % str(expCapacityUnit))
                    expDiskCapacity2GB = common.changUnit2GBLabelCap(anExpDiskCapacity + expCapacityUnit)
                    logger.logInfo("The expDiskCapacity2GB is %s" % str(expDiskCapacity2GB))
                    recommCap = getDiskCapType(expDiskCapacity2GB[1], isNvme)
                    # 判断新输入盘是否符合盘容量类型要求

                    if not recommCap:
                        flag = False
                        sortedDictKeyAry = getSortedCapacityTypeKeys()
                        errMsg += common.getMsg(lang, "check.dorado.expand.disk.capacity.not.mapping.not.pass",
                                                (diskDomainId, engineId,
                                                 diskTypeList[0],anExpDiskCapacity + expCapacityUnit, str(sortedDictKeyAry)))
                        continue
                    logger.logInfo("The expRecomConfigData is %s %s %s" % (str(baseCap), str(baseNum), str(recommCap)))

                    # 原系统中超过临界盘数，按照临界盘读取最小推荐扩盘数（最小起扩盘数/截断阈值）
                    if baseNum > RECOM_DATA_CRITICAL_VALUE:
                        baseNum = RECOM_DATA_CRITICAL_VALUE
                    minRecommNum = recomConfigDict.get((baseCap, baseNum, recommCap))

                    if not minRecommNum:
                        flag = False
                        errMsg += common.getMsg(lang,
                                                "check.dorado.expand.disk.capacity.recomm.not.mapping.not.pass",
                                                (diskDomainId, engineId, diskTypeList[0],anExpDiskCapacity + expCapacityUnit))
                        continue

                    logger.logInfo("The min expRecomNum is %s" % str(minRecommNum))
                    logger.logInfo("The input expRecomNum is %s" % str(expDiskNum))
                    if minRecommNum > expDiskNum:
                        flag = False
                        errMsg += common.getMsg(lang,"check.expand.engine.disk.number.less.threshold1.not.pass",
                                                ( diskDomainId, engineId, diskTypeList[0], expDiskNum, minRecommNum))
                        continue

        # 检查通过，持久化配置数据
        if flag:
            # 扩容配置持久化数据
            configDataDiskNumDict = {}
            configDataDiskCapDict = {}
            configDataDiskModelDict = {}
            for line in expDiskList:
                expDiskDomId = line.get("diskDomain")
                engineId = line.get("eng")
                diskNum = int(line.get("diskNum"))
                diskCapacity = str(line.get("diskCapacity"))
                capacityUnit = str(line.get("unit"))
                diskModel = str(line.get("diskModel"))
                diskCapacity2GB = common.changUnit2GBLabelCap(diskCapacity + capacityUnit)
                configDataDiskNumDict[expDiskDomId] = configDataDiskNumDict.get(expDiskDomId, 0) + diskNum
                if configDataDiskCapDict.get(expDiskDomId, 0) == 0:
                    configDataDiskCapDict[expDiskDomId] = diskCapacity2GB[1]
                if configDataDiskModelDict.get(expDiskDomId, "") == "":
                    configDataDiskModelDict[expDiskDomId] = diskModel
            logger.logInfo("configDataDiskNumDict is %s" % configDataDiskNumDict)
            logger.logInfo("configDataDiskCapDict is %s" % configDataDiskCapDict)
            logger.logInfo("configDataDiskModelDict is %s" % configDataDiskModelDict)
            
            configPersistData = {}
            for aDomId in configDataDiskNumDict.keys():
                aPersistData = {}
                aPersistData["domainId"] = aDomId
                aPersistData["diskNum"] = configDataDiskNumDict.get(aDomId)
                aPersistData["diskCapacity"] = configDataDiskCapDict.get(aDomId)
                aPersistData["engine"] = expDomainEngMap[aDomId]
                aPersistData["diskModel"] = configDataDiskModelDict[aDomId]
                configPersistData[aDomId] = aPersistData
            logger.logInfo("check pass, start to persist config data: %s" % configPersistData)
            exp_common.save_expansion_config_data(configPersistData, logger)
            exp_common.get_expansion_config_data(logger)
        return flag, cliRetAll, errMsg

    except Exception, exception:
        logger.logException(exception)
        return cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(lang,"query.result.abnormal")
    finally:
        common.finishProcess(py_java_env)
        logger.logInfo("finish process!")

def getEngineDiskNumDic(diskInDomainList, productModel):
    engineDiskNumDic = {} # {"0":50,"1":100}
    for disk in diskInDomainList:
        engineId = common.getEngineIdByDiskId(disk.get("ID"), productModel)  # 根据硬盘ID获取引擎ID
        engineDiskNumDic[engineId] = engineDiskNumDic.get(engineId, 0) + 1
    logger.logInfo("engineDiskNumDic is %s" % engineDiskNumDic)
    return engineDiskNumDic

def getNewExpDiskNumDic(newExpDiskList):
    newExpDiskNumDic = {}  # {"0":40,"1":50}
    for newExpDisk in newExpDiskList:
        engineId = newExpDisk.get("logicEng")
        diskNum = int(newExpDisk.get("diskNum"))
        newExpDiskNumDic[engineId] = newExpDiskNumDic.get(engineId, 0) + diskNum
    logger.logInfo("newExpDiskNumDic is %s" % newExpDiskNumDic)
    return newExpDiskNumDic
        
def isNvmeDisk(diskModel):
    return "NVME" in diskModel.upper()
    
def getSheetDataKey(productModel, isEnhanced=False, isNvme=False):
    sheetDataKey = ""
    productModelSplitList = productModel.split()
    # Dorado 18000 V3与Dorado6000SASENH保持一致
    if productModel == "Dorado18000 V3":
        sheetDataKey = "Dorado6000SASENH"
        return sheetDataKey
    
    sheetDataKey = productModelSplitList[0]
    if isNvme:
        return sheetDataKey + "NVME"
    if isEnhanced:
        return sheetDataKey + "SASENH"
    return sheetDataKey + "SAS"

def getRecomConfigData(cVersion):
    recomCfgKey = ENV_EXP_RECOM_CONFIG_DATA + cVersion
    expRecomConfigs = py_java_env.get(recomCfgKey)
    if not expRecomConfigs:
        excel = Excel(cVersion)
        expRecomConfigs = excel.getExpRecomConfigs()
        py_java_env.put(recomCfgKey, expRecomConfigs)
    return expRecomConfigs

def getCVersion(sysVersion):
    for cVersion in sysVerCfgDataMapping.keys():
        if cVersion in sysVersion:
            return cVersion
    return ""
    
def getDiskCapType(capacity, isNvme):
    '''
        获得等价容量
    '''
    if is960N(capacity):
        nvmeSign = 1 if isNvme else 0
        return diskCapType.get(capMappingFor960N.get((capacity, nvmeSign)))
    return diskCapType.get(capMapping.get(capacity))

def is960N(capacity):
    for key in capMappingFor960N.keys():
        if capacity == key[0]:
            return True
    return False

def getMaxDisknum(cVersion, productModel, isEnhanced=False, isNvme=False):
    productTypeStr = "SAS"
    if isEnhanced:
        productTypeStr = "ENH"
    if isNvme:
        productTypeStr = "NVME"
    return maxSingleEngDiskNum.get(cVersion).get((productModel, productTypeStr))

def getSortedCapacityTypeKeys():
    sortedDictKeyAry = []
    sortedDictTypes = sorted(diskCapType.items(), key=lambda ele:ele[1])
    for dictKey, __ in sortedDictTypes:
        sortedDictKeyAry.append(dictKey)
    return sortedDictKeyAry

class Excel(object):

    def __init__(self, cVersion = "C21"):
        self.cVersion = cVersion
        configFileName = sysVerCfgDataMapping.get(cVersion)
        filepath = py_java_env.get("path")
        filename = filepath + os.sep + configFileName
        self.filename = filename

    def openExcel(self):
        self.data = xlrd.open_workbook(self.filename)

    def creatExpRecomConfigList(self, sheet_name, start_row):
        
        self.table = self.data.sheet_by_name(sheet_name)
        nrows = self.table.nrows
        expRecomConfigList = {}

        for rownum in range(start_row, nrows, 1):
            cellBaseCap = diskCapType.get(self.table.cell(rownum, 1).value)
            cellBaseNum = int(self.table.cell(rownum, 3).value)
            cellRecommandCap = diskCapType.get(self.table.cell(rownum, 5).value)
            cellRecommandNum = int(self.table.cell(rownum, 7).value)
            
            expRecomConfigList.update({(cellBaseCap,  cellBaseNum, cellRecommandCap) : cellRecommandNum})
        return expRecomConfigList
    
    def getExpRecomConfigs(self):
        expRecomConfigs = {}
        self.openExcel()
        dorado6000SASCfgs = self.creatExpRecomConfigList(SHEET_NAMES[0], 1)
        dorado5000SASCfgs = self.creatExpRecomConfigList(SHEET_NAMES[1], 1)
        dorado5000NVMECfgs = self.creatExpRecomConfigList(SHEET_NAMES[2], 1)
        expRecomConfigs.update({SHEET_NAMES[0] : dorado6000SASCfgs})
        expRecomConfigs.update({SHEET_NAMES[1] : dorado5000SASCfgs})
        expRecomConfigs.update({SHEET_NAMES[2] : dorado5000NVMECfgs})
        if self.cVersion in SUPPORT_ENHANCE_VERSIONS:
            dorado5000SASENHCfgs = self.creatExpRecomConfigList(SHEET_NAMES[3], 1)
            dorado6000SASENHCfgs = self.creatExpRecomConfigList(SHEET_NAMES[4], 1)
            expRecomConfigs.update({SHEET_NAMES[3] : dorado5000SASENHCfgs})
            expRecomConfigs.update({SHEET_NAMES[4] : dorado6000SASENHCfgs})
        return expRecomConfigs
    