# -*- coding: UTF-8 -*-
import cliUtil
import common

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)

def execute(cli):
    '''
    ISCSI端口检查：
        1 如果ISCSI端口不存在表示正常；
        2 Health Status必须为Normal。端口Running Status为Link Down时表示正常，
                        当为Link Up时，工作速率为10Mbps，100Mbps，1000Mbps，10000Mbps，25000Mbps，40000Mbps或100000Mbps时表示正常；
        3 其它情况均属于不正常状态。
    '''
    flag = True
    cliRet =""
    errMsg = ""
    portName = "ETH"
    
    try:
        cmd = "show port general physical_type=ETH logic_type=Host_Port"
        LOGGER.logExecCmd(cmd)
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
        if checkRet[0] != True: 
            LOGGER.logSysAbnormal()
            return checkRet
        
        cliRet = checkRet[1]
        if cliUtil.queryResultWithNoRecord(cliRet):
            return (True, cliRet, errMsg)
        
        cliRetLinesList = cliUtil.getHorizontalCliRet(cliRet)
        for line in cliRetLinesList:
            portId = line.get("ID")
            healthStatus = line.get("Health Status")
            runningStatus = line.get("Running Status")
            workingRate = line.get("Working Rate(Mbps)")
            
            if healthStatus != common.STATUS_NORMAL:
                flag = False
                errMsg += common.getMsg(LANG, "port.health.status.abnormal", (portName, portId, healthStatus))
                LOGGER.logNoPass("The Health Status of ETH port [%s] is abnormal (Health Status:%s)"
                     % (portId, healthStatus))
            
            if runningStatus == common.STATUS_LINK_UP:
                if workingRate not in ["10", "100", "1000", "10000", "25000", "40000", "100000"]:
                    flag = False
                    errMsg += common.getMsg(LANG, "port.working.rate.abnormal", (portName, portId, workingRate))
                    LOGGER.logNoPass("The Working Rate of ETH port [%s] is abnormal (Working Rate:%sMbps)"
                         % (portId, workingRate))
        
        if flag:
            LOGGER.logPass()
            
        return (flag, cliRet, errMsg)
        
    except Exception, exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cliRet, common.getMsg(LANG, "query.result.abnormal"))
