# -*- coding: UTF-8 -*-

import cliUtil
import common
from frameone.util import contextUtil
from frameone.rest import restUtil
from common import UnCheckException
from com.huawei.ism.exception import IsmException
from cbb.frame.base import baseUtil
from cbb.frame.base import product

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PERFORMANCE_SWITCH_DISABLED = "83890437"
FC_PORT_PERFORMANCE_OBJECT = "212"
ETH_PORT_PERFORMANCE_OBJECT = "213"
SAS_PORT_PERFORMANCE_OBJECT = "214"
UTILIZATION_PERFORMANCE_INDEX = "18"
FRONT_END_PORTS = ["0", "5", "6"]
# 前端端口FC/ETH支持查性能数据的端口ROLE，对应CLI是 TGT/INI AND TGT
FRONT_END_SUPPORT_ROLE = ["3", "4"]
EXPANSION_PORT = "208"
port_id_location_dict = {}
usage_more_than_80_flag = False
usage_60_less_80_flag = False
exceed_80_msg = ""
exceed_60_less_80_msg = ""


def execute(cli):
    """
    前后端端口性能负载检测
    :param cli:
    :return:
    """
    global exceed_80_msg
    global exceed_60_less_80_msg
    global usage_more_than_80_flag
    global usage_60_less_80_flag
    all_cli_ret = ""
    try:
        exceed_80_msg = common.getMsg(LANG, "utilization.exceed.80.port")
        exceed_60_less_80_msg = common.getMsg(
            LANG, "utilization.exceed.60.less.80.port")
        dataDict = contextUtil.getContext(py_java_env)
        rest = contextUtil.getRest(dataDict)

        # 端口检查规则list，包含端口新的查询url和性能对象
        port_utilization_list = {}
        all_cli_ret, fc_port_id_list = \
            query_port_utilization(rest, all_cli_ret,
                                   port_utilization_list,
                                   "fc_port",
                                   FC_PORT_PERFORMANCE_OBJECT)

        # 查询SAS端口的利用率，由于级联口没有性能数据，得用专用过滤方法
        if not baseUtil.is_micro_dev(
                str(PY_JAVA_ENV.get("devInfo").getDeviceType())):
            sas_port_id_list, all_cli_ret = \
                query_port_id_by_sas(rest, all_cli_ret)
            all_cli_ret = query_performance(rest, sas_port_id_list,
                                            SAS_PORT_PERFORMANCE_OBJECT,
                                            UTILIZATION_PERFORMANCE_INDEX,
                                            port_utilization_list, all_cli_ret)
            # 检查SAS端口
            check_utilization_list(
                sas_port_id_list, "SAS", port_utilization_list)

        # 查询ETH端口的利用率，由于ETH有部分端口没有性能，得使用特殊方法过滤
        eth_port_id_list, all_cli_ret = \
            query_port_id_by_eth(rest, all_cli_ret)
        all_cli_ret = query_performance(rest, eth_port_id_list,
                                        ETH_PORT_PERFORMANCE_OBJECT,
                                        UTILIZATION_PERFORMANCE_INDEX,
                                        port_utilization_list, all_cli_ret)

        try:
            rest.close()
            LOGGER.logInfo("conn close success, close session!")
        except Exception, e:
            LOGGER.logError("conn close except: %s" % str(e))

        # 根据检查标准，检查所有端口的利用率
        LOGGER.logInfo(
            "port_utilization_list is :%s" % port_utilization_list)
        # 检查FC端口
        check_utilization_list(
            fc_port_id_list, "FC", port_utilization_list)

        # 检查ETH端口
        check_utilization_list(
            eth_port_id_list, "ETH", port_utilization_list)
        all_error = build_all_error()
        if usage_more_than_80_flag:
            return False, all_cli_ret, all_error
        if usage_60_less_80_flag:
            return cliUtil.RESULT_WARNING, all_cli_ret, all_error
        return True, all_cli_ret, ""

    except UnCheckException as unCheckException:
        LOGGER.logInfo(
            "UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        return (cliUtil.RESULT_NOCHECK, unCheckException.cliRet,
                unCheckException.errorMsg)

    except Exception as exception:
        LOGGER.logError("Failed to check coffer :%s" % str(exception))
        return (cliUtil.RESULT_NOCHECK, all_cli_ret,
                common.getMsg(LANG, "query.result.abnormal.out_svp"))


def build_all_error():
    """
    组装所有利用率检查范围的异常信息
    :return:
    """
    global exceed_80_msg
    global exceed_60_less_80_msg
    global usage_more_than_80_flag
    global usage_60_less_80_flag
    error = ''
    if usage_more_than_80_flag:
        error = common.joinLines(error, exceed_80_msg)
    if usage_60_less_80_flag:
        error = common.joinLines(error, exceed_60_less_80_msg)
    return error


def check_utilization_list(port_id_list, port_type, port_utilization_list):
    """
    根据不同端口，拼接不同的提示信息
    :param port_id_list: 端口id列表
    :param port_type: 端口类型
    :param port_utilization_list: 利用率字典
    :return:
    """
    global port_id_location_dict
    global exceed_80_msg
    global exceed_60_less_80_msg
    global usage_more_than_80_flag
    global usage_60_less_80_flag
    exceed_80_list = []
    exceed_60_less_80_list = []
    for port_id in port_id_list:
        perf = port_utilization_list.get(port_id, "")
        if perf.isdigit():
            port_name = port_id_location_dict.get(port_id, "")
            key_perf_msg = common.getMsg(LANG,
                                         "port.performance.usage.info",
                                         (port_name, port_id, str(perf)))
            perf_int = int(perf)
            if perf_int > 80:
                # 如果是4294967295，替换为--展示。
                exceed_80_list.append(
                    key_perf_msg.replace("4294967295%", '--'))
            if 60 < perf_int <= 80:
                exceed_60_less_80_list.append(key_perf_msg)
    if exceed_80_list:
        usage_more_than_80_flag = True
        exceed_80_msg = common.joinLines(exceed_80_msg, "%s:\n%s" % (
            port_type, '\r\n'.join(exceed_80_list)))

    if exceed_60_less_80_list:
        usage_60_less_80_flag = True
        exceed_60_less_80_msg = common.joinLines(
            exceed_60_less_80_msg,
            "%s:\n%s" % (port_type, '\r\n'.join(exceed_60_less_80_list)))


def query_port_utilization(rest, all_cli_ret, port_utilization_list,
                           port_url,
                           perf_object):
    """

    :param rest:  rest连接
    :param all_cli_ret: 原始信息
    :param port_utilization_list:
    :param port_url: url关键字
    :param perf_object: 性能对象
    :return: 原始信息，端口ID列表
    """
    global port_id_location_dict
    records, all_cli_ret = query_port_info(rest, port_url, all_cli_ret)
    id_list = []
    for record in records:
        port_id = record.get("ID", "")
        ini_role = record.get("INIORTGT", "")
        # Dorado Nas触发，只查支持查性能数据的前端端口角色。
        if ini_role not in FRONT_END_SUPPORT_ROLE:
            continue
        port_location = record.get("LOCATION", "--")
        if port_id:
            port_id_location_dict[port_id] = port_location
            id_list.append(port_id)
    all_cli_ret = query_performance(rest, id_list, perf_object,
                                    UTILIZATION_PERFORMANCE_INDEX,
                                    port_utilization_list, all_cli_ret)
    return all_cli_ret, id_list


def query_port_info(rest, url, all_cli_ret):
    """
    根据Res命令，获取对应字段的回文list
    :param rest: rest连接
    :param url: url关键字
    :param all_cli_ret: 所有回文
    :return: 回文list,原始信息
    """
    try:
        all_cli_ret = common.joinLines(all_cli_ret,
                                       str(rest.getBaseUri() + url))
        records = restUtil.CommonRestService.get4Big(rest,
                                                     url)
        all_cli_ret = common.joinLines(all_cli_ret, str(records))
    except IsmException as e:
        LOGGER.logError("Query port info error :%s" % str(e))
        raise UnCheckException(
            common.getMsg(LANG, "cannot.build.http.connections"),
            all_cli_ret)

    return records, all_cli_ret


def is_support_nas():
    """
    dorado 6.1 开始支持 nas特性
    :return:
    """
    p_version = str(py_java_env.get("devInfo").getProductVersion())
    if product.isDigitalVer(p_version) and p_version >= "6.1":
        return True
    return False


def query_port_id_by_eth(rest, all_cli_ret):
    """
    ETH口根据Res命令，获取对应字段的回文list
    :param rest: rest连接
    :param all_cli_ret: 原始信息
    :return: 回文list,原始信息
    """
    global port_id_location_dict
    records, all_cli_ret = query_port_info(rest, "eth_port", all_cli_ret)
    id_list = []
    for record in records:
        port_id = record.get("ID", "")
        ini_role = record.get("INIORTGT", "")
        bond_name = record.get("BONDNAME", "")

        # Dorado Nas触发，只查支持查性能数据的前端端口角色。
        if ini_role not in FRONT_END_SUPPORT_ROLE:
            continue

        # 方案变更-NAS BOND的成员ETH口不做 端口负载检测
        # 在ETH口上创建bond后，性能数据都会汇聚到BOND口上，
        # ETH口上的性能数据都显示为0
        if is_support_nas() and bond_name != '':
            continue

        logic_type = record.get("LOGICTYPE", "")
        port_location = record.get("LOCATION", "--")
        if port_id:
            port_id_location_dict[port_id] = port_location
        if port_id and logic_type:
            if str(logic_type) in FRONT_END_PORTS:
                id_list.append(port_id)

    return id_list, all_cli_ret


def query_port_id_by_sas(rest, all_cli_ret):
    """
    sas口根据Res命令，获取对应字段的回文list
    :param rest: rest连接
    :param all_cli_ret: 原始信息
    :return: 回文list,原始信息
    """
    global port_id_location_dict
    records, all_cli_ret = query_port_info(rest, "sas_port", all_cli_ret)
    id_list = []
    for record in records:
        port_id = record.get("ID", "")
        parent_type = record.get("PARENTTYPE", "")
        port_location = record.get("LOCATION", "--")
        if port_id:
            port_id_location_dict[port_id] = port_location
        if port_id and parent_type:
            if str(parent_type) != EXPANSION_PORT:
                id_list.append(port_id)

    return id_list, all_cli_ret


def query_performance(rest, id_list, perf_object, perf_index,
                      port_utilization_list, all_cli_ret):
    """
    根据性能对象和指标，查询对应list的性能数据
    :param rest: rest连接
    :param id_list: 需要查询的id的list
    :param perf_object: 性能对象
    :param perf_index: 性能指标
    :param port_utilization_list: 性能数据liest
    :param all_cli_ret: 原始信息
    :return: 原始信息
    """
    for id in id_list:
        try:
            cmdStr = "performace_statistic/cur_statistic_data?" \
                     "CMO_STATISTIC_UUID=%s:%s&CMO_STATISTIC_DATA_ID_LIST=%s"
            perf_url = cmdStr % (perf_object, id, perf_index)
            all_cli_ret = common.joinLines(all_cli_ret,
                                           str(rest.getBaseUri() + perf_url))
            perf_records = restUtil.CommonRestService.get4Big(rest,
                                                              perf_url)
            all_cli_ret = common.joinLines(all_cli_ret, str(perf_records))
            if len(perf_records) > 0:
                perf = perf_records[0].get("CMO_STATISTIC_DATA_LIST", '')
                if perf:
                    port_utilization_list[id] = perf
        except IsmException as e:
            LOGGER.logError("Failed to check coffer :%s" % str(e))
            if str(e.getErrorId()) == PERFORMANCE_SWITCH_DISABLED:
                raise UnCheckException(
                    common.getMsg(LANG,
                                  "performance.switch.disabled"),
                    all_cli_ret)
    return all_cli_ret
