# -*- coding: UTF-8 -*-
import traceback

import cliUtil
import common
import cli_util_cache
from com.huawei.ism.tool.obase.exception import ToolException
from common import UnCheckException

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)

# 工作速率
WORK_SPEED_LIST = [
    "10",
    "100",
    "1000",
    "10000",
    "25000",
    "40000",
    "100000",
    "200000",
]
PORT_TYPE = 'RDMA'


def execute(cli):
    """
    快照与源LUN容量检查
    :param cli:
    :return:
    """
    ret = ""
    try:
        # 获取RDMA信息
        (
            exp_port_info,
            clu_port_info,
            ret,
        ) = cli_util_cache.get_rdma_port_info_cache(PY_JAVA_ENV, cli,
                                                    LOGGER)
        # 如果没有RDMA端口检查通过
        if not exp_port_info and not clu_port_info:
            return True, ret, ""

        # 检查级联端口健康状态和工作速率
        (
            status_err_info,
            work_rate_err_info,
        ) = check_port_status(exp_port_info)
        # 检查cluster健康状态和工作速率
        (
            status_err_info_tmp,
            work_rate_err_info_tmp,
        ) = check_port_status(clu_port_info)
        status_err_info.update(status_err_info_tmp)
        work_rate_err_info.update(work_rate_err_info_tmp)

        err_msg_list = []
        if status_err_info:
            err_key = "rdma.port.health.status.abnormal"
            for port_id in status_err_info:
                status = status_err_info.get(port_id, '')
                err_msg_list.append(
                    common.getMsg(LANG, err_key, (port_id, status)))
        if work_rate_err_info:
            err_key = "port.working.rate.abnormal"
            for port_id in work_rate_err_info:
                work_rate = work_rate_err_info.get(port_id, '')
                err_msg_list.append(
                    common.getMsg(LANG, err_key,
                                  (PORT_TYPE, port_id, work_rate)))

        if err_msg_list:
            return False, ret, "".join(err_msg_list)

        return True, ret, ""
    except UnCheckException as e:
        return cliUtil.RESULT_NOCHECK, ret, e.errorMsg
    except (ToolException, Exception) as e:
        LOGGER.logError(str(e))
        LOGGER.logError(traceback.format_exc())
        return (
            cliUtil.RESULT_NOCHECK,
            ret,
            common.getMsg(LANG, "query.result.abnormal"),
        )


def check_port_status(port_list):
    """
    检查健康状态和工作速率
    :param port_list:
    :return:
    """
    not_normal_info_dict = {}
    work_rate_err_info_dict = {}
    for port_info in port_list:
        port_id = port_info.get("ID", "")
        health_status = port_info.get("Health Status", "")
        running_status = port_info.get("Running Status", "")
        work_rate = port_info.get("Working Rate(Mbps)", "")
        if health_status != "Normal":
            not_normal_info_dict[port_id] = health_status
        if running_status == "Link Down":
            continue

        if work_rate not in WORK_SPEED_LIST:
            work_rate_err_info_dict[port_id] = work_rate

    return not_normal_info_dict, work_rate_err_info_dict
