# -*- coding: UTF-8 -*-
import cliUtil
import common
import expandconfig
from config import DiskType
from config import SMO_DISK_CAPACITY

lang = common.getLang(py_java_env)
logger = common.getLogger(PY_LOGGER, __file__)
deviceType = str(common.getProductModeFromContext(py_java_env))
expConfigObj = expandconfig.ExpandConfig(py_java_env)

#进度总剩余时间
LIMIT_TIME = 120
#进度刷新间隔
INTERVAL = 2

def execute(cli):
    '''
        扩容前SMO资源项检查
    '''
    flag = True
    cliRetAll = ""
    errMsg = ""
    try:
        expDiskTypeOnEngineDict = expConfigObj.getExpDiskTypeOnEngine()
        logger.logInfo("The expDiskTypeOnEngineDict is %s" % expDiskTypeOnEngineDict)
        
        if not expDiskTypeOnEngineDict:
            return cliUtil.RESULT_NOSUPPORT, cliRetAll, errMsg
        
        #进度条刷新
        common.threadUpProcess(py_java_env, LIMIT_TIME, INTERVAL, logger)
        #进度开始
        common.inProcess(py_java_env)
        logger.logInfo("process Thread started!")
        
        # 获取硬盘域信息
        checkRet = common.getDiskDomainInfo(cli, lang)
        logger.logInfo("The diskDomainList is %s" % checkRet[3])
        cliRetAll = checkRet[1]
        if not checkRet[0]:
            logger.logSysAbnormal()
            return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg
        
        # 硬盘域不存在返回不涉及
        if not checkRet[3]:
            logger.logInfo("the disk domain is not exist")
            return cliUtil.RESULT_NOSUPPORT, cliRetAll, ""
        
        # 原扩硬盘域、原扩引擎不存在新扩硬盘类型（新增层级），检查通过.
        checkRet = checkNewDiskTypeOnEngine(cli, lang)
        cliRetAll += checkRet[1]
        # 返回True 检查通过 或者返回未检查
        if checkRet[0] != False:
            return checkRet[0], cliRetAll, checkRet[2]
        
        # 如果原引擎的成员盘容量总和超过指定范围，则检查不通过。
        cmd = "show disk general |filterColumn include columnList=ID,Type,Capacity,Role|filterRow column=Role predict=equal_to value=Member\sDisk"
        checkRet = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
        cliRetAll += checkRet[1]
        errMsg = checkRet[2]
        if not checkRet[0]:
            logger.logSysAbnormal()
            return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg
        
        diskDictList = cliUtil.getHorizontalCliRet(checkRet[1])
        if len(diskDictList) == 0:
            logger.logSysAbnormal()
            return cliUtil.RESULT_NOCHECK, cliRetAll, errMsg
        
        # 获取当前系统引擎成员盘类型字典信息,格式为:{0:{"SSD","SAS"}}
        engDiskTypeDict = common.getEngMemberDiskType(diskDictList)
        logger.logInfo("The engDiskTypeDict is %s" % engDiskTypeDict)
        # 获取当前系统引擎成员盘容量字典信息,格式为:{0:[500, 700]容量单位为GB
        engDiskCapacityDict = common.getEngMemberDiskCapacity(diskDictList)
        logger.logInfo("The engDiskCapacityDict is %s" % engDiskCapacityDict)
        
        maxDiskCapacity = SMO_DISK_CAPACITY.get(deviceType)
        for engineId in expDiskTypeOnEngineDict:
            logger.logInfo("The expDiskTypeOnEngineDict is %s" % expDiskTypeOnEngineDict)
            if engDiskTypeDict.get(engineId) & expDiskTypeOnEngineDict.get(engineId):
                curDiskCapacity = sum(engDiskCapacityDict.get(engineId))
                logger.logInfo("The curDiskCapacity is %s" % curDiskCapacity)
                logger.logInfo("The maxDiskCapacity is %s" % float(maxDiskCapacity))
                if float(curDiskCapacity) > float(maxDiskCapacity):
                    logger.logNoPass("The diskCapacity [%sTB] of engine [engine_id:CTE%s] is more than requirement[%sTB]" % (curDiskCapacity/1024, engineId, maxDiskCapacity/1024))
                    errMsg += common.getMsg(lang, "expand.disk.capacity.exceed.specification", (engineId, curDiskCapacity/1024, maxDiskCapacity/1024))
                    flag = False
                    
        return flag, cliRetAll, errMsg
        
    except Exception, exception:
        logger.logException(exception)
        return cliUtil.RESULT_NOCHECK, cliRetAll, common.getMsg(lang,"query.result.abnormal")
    finally:
        common.finishProcess(py_java_env)
        logger.logInfo("finish process!")

def checkNewDiskTypeOnEngine(cli,lang):
    """
    判断扩容硬盘域扩容引擎上是否存在新扩硬盘类型（新增层级）,存在返回True
    """
    cliRet = ""
    errMsg = ""
    expDiskInfoDic = expConfigObj.getExpDiskInfo()
    logger.logInfo("The expDiskInfoDic is %s" % expDiskInfoDic)
    
    for diskDomainId in expDiskInfoDic:
        expDiskInfoList = expDiskInfoDic.get(diskDomainId)
        expEngineDiskDic = {}
        expDiskTypeSet = set()
        for expDiskInfoObj in expDiskInfoList:
            engineId = expDiskInfoObj.getDiskEngineId()
            diskType = expDiskInfoObj.getDiskType()
            expDiskTypeSet.add(diskType)
            expEngineDiskDic[engineId] = expEngineDiskDic.get(engineId, set()) | expDiskTypeSet
        
        # 遍历扩容引擎字典
        for engineId in expEngineDiskDic:
            # 根据扩容硬盘域diskDomainId和扩容引擎engineId,获取系统当前硬盘类型的集合
            diskTypeSet = set() # 系统当前硬盘类型的集合
            checkRet = common.getDiskTypeByEngineOnDD(cli, diskDomainId, engineId, lang)
            cliRet = checkRet[1]
            if not checkRet[0]:
                return cliUtil.RESULT_NOCHECK, cliRet, checkRet[2]
            diskTypeSet = checkRet[3]
            # 扩容引擎engineId中存在新扩硬盘类型(存在非新扩层级)
            if expEngineDiskDic.get(engineId) & diskTypeSet:
                return False, cliRet, errMsg
    
    return True, cliRet, errMsg


