#  coding=UTF-8
#  Copyright (c) Huawei Technologies Co., Ltd. 2019-2019. All rights reserved.

"""
@version: Toolkit V200R006C00
@time: 2020/07/27
@file: check_item_sed_msid_risk.py
@function:
"""

import common
import cliUtil
from cbb.business.operate.inspection.checkitems import check_sed_msid_risk

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    """加密盘与产品读取MSID算法冲突,导致接盘失败
    @OMRPId bdm_check_sed_msid_risk_product_version

    :param
        cli
    :return: (是否通过， 回显， 错误码)
    """
    cli_ret = ""
    try:
        LOGGER.logInfo("process Thread started!")

        # 获取扩容硬盘列表
        exp_disk_list = py_java_env.get("expDiskList")

        #  设置上下文
        context = {
            "lang": LANG,
            "logger": PY_LOGGER,
            "CLI_CONNECTION": cli,
            "expDiskList": exp_disk_list,
        }

        # 调用框架，获取检查结果
        ret = check_sed_msid_risk.execute(context)

        return ret

    except Exception as exception:
        LOGGER.logException(exception)
        return (cliUtil.RESULT_NOCHECK, cli_ret,
                common.getMsg(LANG, "query.result.abnormal"))
    finally:
        common.finishProcess(py_java_env)
        LOGGER.logInfo("finish process!")
