# -*- coding: UTF-8 -*-
from cbb.business.checkitems.ad_domian_connectivity_check import (
    AdDomainConnCheck,
)
from cbb.frame.checkitem.context_adapter import InspectContext

import common
import cliUtil

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)


def execute(cli):
    """
    AD连通性检查
    :param cli:
    :return:
    """
    tool_context = InspectContext(PY_JAVA_ENV, cli)
    context_inspect = tool_context.get_context()
    context_inspect["logger"] = PY_LOGGER
    ad_conn_check = AdDomainConnCheck(context_inspect)
    try:
        flag, msg = ad_conn_check.check()
        LOGGER.logInfo("flag:{}, msg:{}".format(flag, msg))
        res_flag, ret, msg = tool_context.get_result(
            flag, msg, ad_conn_check.get_origin_info())
        return res_flag, ret, msg
    except Exception as e:
        LOGGER.logError(str(e))
        return (
            cliUtil.RESULT_NOCHECK,
            ad_conn_check.get_origin_info(),
            common.getMsg(LANG, "query.result.abnormal"),
        )
    finally:
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model {}".format(ret))
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)
