# -*- coding: UTF-8 -*-
import time
import datetime
import re
import cliUtil
import common
import traceback
import config
from common import UnCheckException
from common import AsynProgress
from com.huawei.ism.tool.obase.exception import ToolException

PY_JAVA_ENV = py_java_env
LANG = common.getLang(PY_JAVA_ENV)
LOGGER = common.getLogger(PY_LOGGER, __file__)
ALL_CLI_RET = ""
TOTAL_RESULT_DICT = {}
GET_RESULT_INFO_LIST = []
RESULT_FLAG_LIST = []
ALL_NODES_IDS = []


def execute(cli):
    '''

    '''
    global ALL_CLI_RET
    myPthread = AsynProgress(PY_JAVA_ENV, LOGGER)
    myPthread.start_thread()
    connCli = ""
    try:
        # 如果是18000执行debug命令获取阵列链接
        flag, conn, tmpErrMsg = common.createDeviceCliContFor18000(cli, PY_JAVA_ENV, LOGGER, LANG)
        if flag != True:
            return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, tmpErrMsg)

        connCli = conn

        # 查询产品版本和补丁版本号
        flag, cliRet, errMsg, softwareVersion, hotPatchVersion = common.getVersion(connCli, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        LOGGER.logInfo("softwareVersion is: %s, hotPatchVersion:%s" % (softwareVersion, hotPatchVersion))

        if softwareVersion not in config.CHECK_HYPER_ARB_LINK_WHITE_PRODUCT_LIST:
            no_support_msg = common.version_no_support_msg(
                "", softwareVersion, "",
                config.CHECK_HYPER_ARB_LINK_WHITE_PRODUCT_LIST,
                LANG)
            return (cliUtil.RESULT_NOSUPPORT, no_support_msg, "")

        # 检查是否存在HyperMetro对应license信息
        checkFlag, isExistHyperMetroLicense, errMsg = checkIsExistHyperMetroLicense(connCli)
        if not isExistHyperMetroLicense:
            return (True, ALL_CLI_RET, "")

        # 检查是否存在双活pair记录
        checkFlag, isExistHyperMetroPair, errMsg = checkIsExistHyperMetroPair(connCli)
        if checkFlag != True:
            return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, errMsg)

        if not isExistHyperMetroPair:
            return (True, ALL_CLI_RET, "")

        # 检查每个仲裁服务器的每个控制器的livelink数是否一致
        checkResult, errMsg = checkCpsCtrlLivelinkConsistent(connCli)
        if checkResult != True:
            return (checkResult, ALL_CLI_RET, errMsg)

        return (True, ALL_CLI_RET, "")

    except UnCheckException, unCheckException:
        LOGGER.logInfo(u"UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, unCheckException.errorMsg)
    except ToolException:
        LOGGER.logError(str(traceback.format_exc()))
        raise
    except:
        LOGGER.logInfo(str(traceback.format_exc()))
        return (cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, "query.result.abnormal"))
    finally:
        myPthread.setStopFlag(True)
        if connCli and common.is18000(PY_JAVA_ENV, connCli):
            common.closeConnection(connCli, PY_JAVA_ENV, LOGGER)
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def checkIsExistHyperMetroLicense(cli):
    '''
    检查是否存在HyperMetro的License
    :param cli:
    :return:
    '''
    global ALL_CLI_RET
    isExistHyperMetroLicense = False
    cmd = "show license"
    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        return (False, isExistHyperMetroLicense, errMsg)
    if "HyperMetro" in cliRet:
        isExistHyperMetroLicense = True
    return (True, isExistHyperMetroLicense, "")


def checkIsExistHyperMetroPair(cli):
    '''
     检查是否存在双活PAIR记录
    :param cli:
    :return:
    '''
    global ALL_CLI_RET
    isExistHyperMetroPair = False
    cmd = "show hyper_metro_pair general"
    (flag, cliRet, errMsg) = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        return (False, isExistHyperMetroPair, errMsg)

    hyperMetroPairInfoList = cliUtil.getHorizontalCliRet(cliRet)

    if len(hyperMetroPairInfoList) > 0:
        isExistHyperMetroPair = True

    return (True, isExistHyperMetroPair, "")


def checkCpsCtrlLivelinkConsistent(cli):
    '''
    检查每个仲裁服务器的每个控制器的livelink数是否一致
    :param cli:
    :return:(检查结果，错误信息)
    '''
    global ALL_CLI_RET, GET_RESULT_INFO_LIST, ALL_NODES_IDS, TOTAL_RESULT_DICT
    checkResults = []
    errMsg = ""

    # 获取仲裁服务器的控制器的livelink数
    getCpsCtrlLivelinkDict(cli, PY_JAVA_ENV, LOGGER, LANG, "")

    LOGGER.logInfo("Get TOTAL_RESULT_DICT is :%s" % TOTAL_RESULT_DICT)
    if RESULT_FLAG_LIST and not TOTAL_RESULT_DICT:
        return cliUtil.RESULT_WARNING, common.getMsg(LANG, "check.arb.link.no.config")

    # 判断是否少了节点
    if len(TOTAL_RESULT_DICT) < len(ALL_NODES_IDS):
        checkResults.append(False)
        errMsg += common.getMsg(LANG, "get.cps.or.ctrl.num.error")

    # 遍历每个节点
    for nodeId in TOTAL_RESULT_DICT:
        isLiveLinkZeroDict = {}
        for otherNodeId in TOTAL_RESULT_DICT:
            if nodeId == otherNodeId:
                continue

            # 比较当前节点和其他节点的 cps
            cpsCtrlLiveLinkDictA = TOTAL_RESULT_DICT.get(nodeId, {})
            cpsCtrlLiveLinkDictB = TOTAL_RESULT_DICT.get(otherNodeId, {})

            tmpBigLenCpsCtrlLiveLinkDict = cpsCtrlLiveLinkDictA
            if len(cpsCtrlLiveLinkDictA) < len(cpsCtrlLiveLinkDictB):
                tmpBigLenCpsCtrlLiveLinkDict = cpsCtrlLiveLinkDictB

            for cpsName in tmpBigLenCpsCtrlLiveLinkDict:
                ctrlLiveLinkDictA = cpsCtrlLiveLinkDictA.get(cpsName, {})
                ctrlLiveLinkDictB = cpsCtrlLiveLinkDictB.get(cpsName, {})
                if not ctrlLiveLinkDictA or not ctrlLiveLinkDictB or len(ctrlLiveLinkDictA) != len(ctrlLiveLinkDictB):
                    checkResults.append(False)
                    tmpErrMsg = common.getMsg(LANG, "get.cps.or.ctrl.num.error")
                    if tmpErrMsg not in errMsg:
                        errMsg += tmpErrMsg
                    continue

                for ctrlNode in ctrlLiveLinkDictA:
                    liveLinkA = ctrlLiveLinkDictA.get(ctrlNode, {})
                    liveLinkB = ctrlLiveLinkDictB.get(ctrlNode, {})
                    if liveLinkA != liveLinkB:
                        checkResults.append(False)
                        tmpNotPassErrMsg = common.getMsg(LANG, "check.arb.link.no.pass", (cpsName, ctrlNode))
                        if tmpNotPassErrMsg not in errMsg:
                            errMsg += tmpNotPassErrMsg

                    isLiveLinkZero = isLiveLinkZeroDict.get(cpsName, [])
                    isLiveLinkZero.append(liveLinkA)
                    isLiveLinkZero.append(liveLinkB)
                    isLiveLinkZeroDict[cpsName] = isLiveLinkZero

        for cpsName in isLiveLinkZeroDict:
            isLiveLinkZero = isLiveLinkZeroDict.get(cpsName, [])
            tmpZeroList = [ i for i in isLiveLinkZero if i != "0"]

            # 如果isLiveLinkZero都有值，但是值都是 ‘0’，则结果为建议优化
            if isLiveLinkZero and not tmpZeroList:
                tmpSuggErrMsg = common.getMsg(LANG, "check.arb.link.warning", cpsName)
                if tmpSuggErrMsg not in errMsg:
                    errMsg += tmpSuggErrMsg
                checkResults.append(cliUtil.RESULT_WARNING)

        # 比较一遍就能比较出哪些是不等的值，互相之间再不等不需要判断。
        break

    checkResult = getCheckResult(checkResults)

    return (checkResult, errMsg)


def getCheckResult(checkResults):
    if False in checkResults:
        return False

    if cliUtil.RESULT_WARNING in checkResults:
        return cliUtil.RESULT_WARNING

    if cliUtil.RESULT_NOCHECK in checkResults:
        return cliUtil.RESULT_NOCHECK

    return True


@common.checkAllEngineInClusterWarp
def getCpsCtrlLivelinkDict(cli, PY_JAVA_ENV, LOGGER, LANG, heartBeatCliRet):
    '''
    检查对象数量
    :param connCli:
    :param PY_JAVA_ENV:
    :param LOGGER:
    :param LANG:
    :return:是否继续遍历节点执行检查
    '''
    global ALL_CLI_RET, GET_RESULT_INFO_LIST, TOTAL_RESULT_DICT, RESULT_FLAG_LIST, ALL_NODES_IDS
    LOGGER.logInfo("checkObjNum heartBeatCliRet:%s" % heartBeatCliRet)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, heartBeatCliRet)

    if not ALL_NODES_IDS:
        cmd = "sys showcls"
        (flag, cliRet, errMsg) = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
        engineInfoDictList = cliUtil.getHorizontalNostandardCliRet(cliRet)
        for engineInfo in engineInfoDictList:
            engine = engineInfo.get("engine", "")
            if engine == "":
                continue

            status = engineInfo.get("status", "")
            if status == "" or status != "normal":
                continue

            ctrlNodeId = engineInfo.get("id", "")
            if ctrlNodeId == "":
                continue

            ALL_NODES_IDS.append(ctrlNodeId)

    cmd = "arb showall"
    (flag, cliRet, errMsg) = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cliRet)
    if flag != True:
        GET_RESULT_INFO_LIST.append(cliUtil.RESULT_NOCHECK, common.getMsg(LANG, "query.result.abnormal"))
        return common.CHECK_FLAG_NOT_CONTINUE

    # 解析仲裁服务器的控制器的livelink
    cliRet = unicode(cliRet)

    # 解析仲裁服务器的控制器的livelink
    reg_cps = re.compile("Cps\(\d+\):")
    cpsTuple = reg_cps.findall(cliRet)

    # 当前节点ID
    local_id = re.compile("local nid\((\d+)\)")
    localIds = local_id.findall(cliRet)
    localId = "0"
    if localIds:
        localId = localIds[0]

    cpsCtrlLiveLinkDict = {}
    for cpsNum in range(0, len(cpsTuple)):
        cpsInfoBeginIndex = cliRet.find(cpsTuple[cpsNum])

        # 最后一次直接到最后
        if cpsNum >= len(cpsTuple) - 1:
            cpsInfo = cliRet[(cpsInfoBeginIndex):]
        else:
            cpsInfoEndIndex = cliRet.find(cpsTuple[cpsNum + 1])
            cpsInfo = cliRet[(cpsInfoBeginIndex):cpsInfoEndIndex]

        # 仲裁服务器名称
        reg_cpsName = re.compile("name:\s*(.*)")
        search_cpsName = reg_cpsName.search(cpsInfo)
        cpsName = search_cpsName.group(1)

        ctrlLiveLinkDict = cpsCtrlLiveLinkDict.get(cpsName, {})

        reg_ctrl = re.compile("\s*Ctrl\((\d+)\):\s*liveLink:\s*(\d+),")
        ctrlTuple = reg_ctrl.findall(cpsInfo)
        for (ctrlId, liveLink) in ctrlTuple:
            ctrlLiveLinkDict[ctrlId] = liveLink

        cpsCtrlLiveLinkDict[cpsName] = ctrlLiveLinkDict


    if not cpsCtrlLiveLinkDict and "Cps" not in cliRet and "liveLink" not in cliRet:
        RESULT_FLAG_LIST.append(cliUtil.RESULT_WARNING)
        return common.CHECK_FLAG_NOT_CONTINUE

    TOTAL_RESULT_DICT[localId] = cpsCtrlLiveLinkDict

    return common.CHECK_FLAG_CONTINUE
