# -*- coding:utf-8 -*-
import traceback

import cliUtil
import common
from common import UnCheckException
from config import hypermetro_resource_check_model, hypermetro_resource_check_version
from common import AsynProgress
from cliUtil import DEBUG_MODEL_FLAG
from common_utils import is_super_administrator

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
ALL_CLI_RET = ''
ALL_ERR_MSG_FALSE = ''
ALL_ERR_MSG_NO_CHECK = ''
remote_replication_cmd = 'show remote_replication unified list_type=fs'
hypervault_cmd = 'show hypervault general'
hyper_metro_pair_cmd = 'show hyper_metro_pair general'
get_pair_failed_info = {remote_replication_cmd: common.getMsg(LANG, 'cannot.get.remote.replication.info'),
                        hypervault_cmd: common.getMsg(LANG, 'cannot.get.hypervault.info'),
                        hyper_metro_pair_cmd: common.getMsg(LANG, 'cannot.get.hyper.metro.pair.info')}


def execute(cli):
    """
    步骤1 以admin用户登录设备；
    步骤2 执行命令：show remote_replication unified list_type=fs获取文件远程复制PAIR数量；
    步骤3 执行命令：show hypervault general获取一体化备份PAIR数量；
    步骤4 执行命令：show hyper_metro_pair general获取双活PAIR数量；
    步骤5 执行命令：change user_mode current_mode user_mode=developer进入developer模式；
    步骤6 执行命令：debug进入debug模式；
    步骤7 执行命令：cmm show pr RSS_LOG_PARTITION 获取增值LOG分区使用数,即“Used_Obj”的值;
    步骤8 退出debug模式，执行命令：minisystem，进入minisystem模式；
    步骤9 执行命令：sshtoremoteExt 登录本引擎的其他各个控制器，重复步骤5-步骤8；
    步骤10 分别登录其他引擎，重复步骤5-步骤9。
    1 步骤2、步骤3和步骤4如果命令不支持则相应个数计算为0；
    2 步骤7如果增值LOG分区使用数大于（双活PAIR数+一体化备份PAIR数+文件远程复制PAIR数+128），则检查失败，否则检查成功。
    :param cli:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_FALSE, ALL_ERR_MSG_NO_CHECK
    myPthread = AsynProgress(PY_JAVA_ENV, LOGGER)
    try:
        # 不是超级管理员账号,报未完成检查
        if not is_super_administrator(cli, PY_JAVA_ENV.get("devInfoMap").get("userName"), LANG):
            return cliUtil.RESULT_NOCHECK, "", common.getMsg(LANG, "loginUser.name.level.must.be.super.admin")
        myPthread.start_thread()
        check_product_flag, no_support_msg = check_product_info(cli)
        if not check_product_flag:
            return cliUtil.RESULT_NOSUPPORT, no_support_msg, ''
        # 获取所有控制器id
        flag, contr_id_list, err_msg, cli_ret = cliUtil.getControllerIdListWithRet(cli, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
        if flag != True:
            LOGGER.logError('Query controlled ID list failed, check terminated!')
            if not flag:
                return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, err_msg
            return flag, ALL_CLI_RET, err_msg
        # 获取文件远程复制PAIR数量
        flag, err_msg, remote_replication_num = get_pair_num(cli, remote_replication_cmd)
        if flag != True:
            return flag, ALL_CLI_RET, err_msg
        # 获取一体化备份PAIR数量
        flag, err_msg, hypervault_num = get_pair_num(cli, hypervault_cmd)
        if flag != True:
            return flag, ALL_CLI_RET, err_msg
        # 获取双活PAIR数量
        flag, err_msg, hyper_metro_pair_num = get_pair_num(cli, hyper_metro_pair_cmd)
        if flag != True:
            return flag, ALL_CLI_RET, err_msg
        # 执行命令：sshtoremoteExt 登录本引擎的其他各个控制器，重复步骤5-步骤8
        if common.is18000(PY_JAVA_ENV, cli):
            flag_list, used_obj_dict = check_used_obj_on_all_engine_by_contr_cli(cli, contr_id_list)
        else:
            flag_list, used_obj_dict = check_used_obj_on_all_engine(cli, contr_id_list)
        flag_list = check_result(used_obj_dict, remote_replication_num, hypervault_num, hyper_metro_pair_num, flag_list)
    except UnCheckException, un_check_exception:
        LOGGER.logError(str(traceback.format_exc()))
        LOGGER.logInfo('UnCheckException, err_msg: %s' % un_check_exception.errorMsg)
        return un_check_exception.flag, un_check_exception.cliRet, un_check_exception.errorMsg
    except:
        LOGGER.logError(str(traceback.format_exc()))
        return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, common.getMsg(LANG, 'query.result.abnormal')
    else:
        if False in flag_list:
            return False, ALL_CLI_RET, ALL_ERR_MSG_FALSE
        if cliUtil.RESULT_NOCHECK in flag_list:
            return cliUtil.RESULT_NOCHECK, ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
        return True, ALL_CLI_RET, ''
    finally:
        #停止刷新进度
        myPthread.setStopFlag(True)
        # 退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        # 退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)


def check_result(used_obj_dict, remote_replication_num, hypervault_num, hyper_metro_pair_num, flag_list):
    """
    判断结果
    :param used_obj_dict:
    :param remote_replication_num:
    :param hypervault_num:
    :param hyper_metro_pair_num:
    :param flag_list:
    :return:
    """
    global ALL_ERR_MSG_FALSE
    standard_value = remote_replication_num + hypervault_num + hyper_metro_pair_num + 128
    for (eng_id, ctr_id), used_obj_num in used_obj_dict.items():
        if int(used_obj_num) > int(standard_value):
            flag_list.append(False)
            ALL_ERR_MSG_FALSE = common.joinLines(ALL_ERR_MSG_FALSE, common.getMsg(LANG, 'exit.used.obj', (
                eng_id, ctr_id, used_obj_num, standard_value)))
    flag_list = list(set(flag_list))
    return flag_list


def get_pair_num(cli, cmd):
    """
    根据不同的命令获取pair数量
    :param cli:
    :param cmd:
    :return:
    """
    global ALL_CLI_RET
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, LANG)
    pair_num = 0
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if cliUtil.queryResultWithNoRecord(cli_ret):
        return True, err_msg, pair_num
    if not cliUtil.hasCliExecPrivilege(cli_ret):
        return True, err_msg, pair_num
    if flag != True:
        return cliUtil.RESULT_NOCHECK, err_msg, pair_num
    cli_ret_list = cliUtil.getHorizontalCliRet(cli_ret)
    pair_num = len(cli_ret_list)
    return True, err_msg, pair_num


def get_used_obj(cli, contr_id, eng_id):
    """
     执行命令：debug进入debug模式；
     执行命令：cmm show pr RSS_LOG_PARTITION 获取增值LOG分区使用数,即“Used_Obj”的值;
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    cmd = 'cmm show pr RSS_LOG_PARTITION'
    flag, cli_ret, err_msg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)

    # 当CBB截流判断结束符，当恰好为']'结束时，回文不全。
    if cli_ret and not cli_ret.endswith(DEBUG_MODEL_FLAG):
        LOGGER.logError('cli ret not complete, retry!')
        # 在当前模式下重试一次带结束符的。
        # 重试之前，因之前的回文残留，先执行一条sys showcls清除残留回文后
        # 再执行带结束符的命令。
        cliUtil.excuteCmdInDebugModel(cli, "sys showcls", LANG)
        filter_list = [DEBUG_MODEL_FLAG]
        flag, cli_ret, err_msg = cliUtil.excuteCmdInDebugModel(cli,
                                                               cmd, LANG,
                                                               filter_list)

    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    used_obj_num = 0
    if flag != True:
        return flag, err_msg, used_obj_num
    cli_ret_list = cliUtil.getVerticalCliRet(cli_ret)
    if len(cli_ret_list) == 0:
        return cliUtil.RESULT_NOCHECK, common.getMsg(LANG, 'cannot.get.used.obj.info', (contr_id, eng_id)), used_obj_num
    used_obj_num = cli_ret_list[0].get('Used_Obj')
    return True, err_msg, used_obj_num


def check_used_obj_on_all_nodes_in_engine(cli, ctrl_id_list, eng_id):
    """
    心跳至引擎中每个控制器去检查used_obj值
    :param cli:
    :param ctrl_id_list:
    :param eng_id:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
    flag_list = []
    used_obj_dict = {}
    eng_num_dict = get_engine_ctrl_num_dict(ctrl_id_list)
    LOGGER.logInfo('Engine number map is:' + unicode(eng_num_dict))
    current_ctrl_node_id, current_engine_ctrl_id_list = get_current_engine_ctrl_node_info(cli)
    LOGGER.logInfo(
        "current_ctrl_node_id:%s, current_engine_ctrl_id_list:%s" % (current_ctrl_node_id, current_engine_ctrl_id_list))
    # 在debug模式下执行命令：cmm show pr RSS_LOG_PARTITION 获取增值LOG分区使用数,即“Used_Obj”的值
    flag, err_msg, used_obj = get_used_obj(cli, current_ctrl_node_id, eng_id)
    used_obj_dict[(str(eng_id), str(current_ctrl_node_id))] = used_obj
    if flag != True:
        flag_list.append(flag)
        ALL_ERR_MSG_NO_CHECK = common.joinLines(ALL_ERR_MSG_NO_CHECK, err_msg)
    # 心跳至每个控制器进行检查
    for node_id in current_engine_ctrl_id_list:
        flag, cli_ret, err_msg = common.heartBeatToOtherCtrl(cli, node_id, PY_JAVA_ENV, LOGGER, LANG)
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
        if flag != True:
            LOGGER.logError('SSH to remote controller failed.')
            raise UnCheckException(err_msg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)
        # 在debug模式下执行命令：cmm show pr RSS_LOG_PARTITION 获取增值LOG分区使用数,即“Used_Obj”的值
        flag, err_msg, used_obj = get_used_obj(cli, node_id, eng_id)
        used_obj_dict[(str(eng_id), str(node_id))] = used_obj
        cliUtil.exitHeartbeatCli(cli, LANG)
        if flag != True:
            flag_list.append(flag)
            ALL_ERR_MSG_NO_CHECK = common.joinLines(ALL_ERR_MSG_NO_CHECK, err_msg)
            continue
    return flag_list, used_obj_dict


def get_engine_ctrl_num_dict(contr_id_list):
    """
    获取引擎下的控制器数量
    :param contr_id_list:
    :return:
    """
    eng_num_dict = {}
    for contr_id in contr_id_list:
        engine_id = contr_id[:1]
        eng_num_dict[engine_id] = eng_num_dict.get(engine_id, 0) + 1
    return eng_num_dict


def get_all_engine_reachable_ip(mgt_port_dict_list):
    """
    @summary: Get reachable IP address of every engine.
    @param mgt_port_dict_list: Management port IP address information dictionary.
    @return: {engineId: reachable_IP_address}
    """
    engine_ip_dict = {}
    for management_port_info_dict in mgt_port_dict_list:
        ip = management_port_info_dict.get('IPv4 Address')
        port_running_status = management_port_info_dict.get('Running Status')
        if port_running_status == 'Link Up' and ip not in ['', '--']:
            management_port_id = management_port_info_dict.get('ID')
            if 'DSW' not in management_port_id:
                engine_id = management_port_id.split('.')[0][-1:]
                ip_list = engine_ip_dict.get(engine_id, [])
                ip_list.append(ip)
                engine_ip_dict.update({engine_id: ip_list})

    return engine_ip_dict


def get_connected_engine_id(management_port_dict_list):
    """
    @summary: Get the ID of engine that toolkit has connected.
    @param management_port_dict_list: Management port information dictionary.
    @return: Number of engine that toolkit has current connected.
    """
    current_contr_ip = PY_JAVA_ENV.get('devInfo').getIp()
    LOGGER.logInfo('The IP that ToolKit connected is %s.' % current_contr_ip)

    for management_port_dict in management_port_dict_list:
        ip = management_port_dict.get('IPv4 Address')
        if ip == current_contr_ip:
            management_port_id = management_port_dict.get('ID')
            engine_id = management_port_id.split('.')[0][-1:]
            LOGGER.logInfo('The engine that ToolKit connected is %s.' % engine_id)
            return engine_id

    return ''


def check_used_obj_on_all_engine(cli, contr_id_list):
    """
    在所有引擎中检查
    :param cli:
    :param contr_id_list:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
    current_ctrl_ip = PY_JAVA_ENV.get('devInfo').getIp()
    all_flag_list = []
    all_used_obj_dict = {}
    eng_num_dict = get_engine_ctrl_num_dict(contr_id_list)
    flag, err_msg, ip_list_dict = get_contr_ip_list_of_engine(cli, LANG)
    engine_num = len(eng_num_dict)
    if engine_num == 1:
        return check_used_obj_on_all_nodes_in_engine(cli, contr_id_list, '0')

    # 设置默认值为0号引擎，下面根据实际值更新
    current_engine = u'0'
    for engine_id in ip_list_dict:
        ip_list = ip_list_dict[engine_id]
        if current_ctrl_ip in ip_list:
            current_engine = engine_id
            LOGGER.logInfo("check currentIp is in ipList: True")
            break

    # 检查当前引擎
    flag_list, obj_dict = check_used_obj_on_all_nodes_in_engine(cli,
                                                                contr_id_list,
                                                                current_engine)
    all_flag_list.extend(flag_list)
    all_used_obj_dict.update(obj_dict)
    if current_engine in ip_list_dict:
        ip_list_dict.pop(current_engine)

    # 检查其他引擎
    for eng_id in ip_list_dict:
        info_tuple = common.getEngineCtrlNodeInfo(cli, LOGGER, LANG)
        flag, ret, msg, conn, exits = common.enginesJump(cli,
                                                         eng_id,
                                                         info_tuple[5],
                                                         info_tuple[3],
                                                         info_tuple[6],
                                                         PY_JAVA_ENV,
                                                         LOGGER,
                                                         LANG,
                                                         info_tuple[4])
        ALL_CLI_RET = common.joinLines(ALL_CLI_RET, ret)
        if flag is not True:
            raise UnCheckException(msg, ALL_CLI_RET)

        flag_list, used_obj_dict = check_used_obj_on_all_nodes_in_engine(
            conn, contr_id_list, engine_id)
        all_flag_list.extend(flag_list)
        all_used_obj_dict.update(used_obj_dict)

        common.enginesBack(conn, PY_JAVA_ENV, LOGGER, LANG, exits)
        LOGGER.logInfo("exit heart beat success.")

    all_flag_list.append(True)
    all_flag_list = list(set(all_flag_list))
    return all_flag_list, all_used_obj_dict


def check_used_obj_on_all_engine_by_contr_cli(cli, contr_id_list):
    """
    check on every controller, the ssh connection is to controller.
    :param cli:
    :param contr_id_list:
    :return:
    """
    global ALL_CLI_RET, ALL_ERR_MSG_NO_CHECK
    current_ctrl_ip = PY_JAVA_ENV.get('devInfo').getIp()
    all_flag_list = []
    all_used_obj_dict = {}
    eng_num_dict = get_engine_ctrl_num_dict(contr_id_list)
    engine_num = len(eng_num_dict)
    if engine_num == 1:
        flag, err_msg, return_cli, ip = get_connection_by_contr_ip(PY_JAVA_ENV, cli)
        if flag == False:
            raise UnCheckException(err_msg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)
        contr_cli = return_cli
        flag_list, used_obj_dict = check_used_obj_on_all_nodes_in_engine(contr_cli, contr_id_list, '0')
        if ip != current_ctrl_ip:
            common.closeSSH(contr_cli)
        return flag_list, used_obj_dict

    # 多引擎环境需要连接到每个引擎上的控制器进行检查
    flag, err_msg, ip_list_dict = get_contr_ip_list_of_engine(cli, LANG)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)

    # 依次检查所有引擎
    flag, msg, tmp_cli, conn_ip = common.getConnectionByContrIpWithConnIp(
        PY_JAVA_ENV, cli, ip_list_dict, u"0", LOGGER, LANG)

    if flag is not True:
        raise UnCheckException(msg, ALL_CLI_RET)

    if not tmp_cli:
        raise UnCheckException(msg, ALL_CLI_RET)

    try:
        # 设置默认值为0号引擎，下面根据实际值更新
        current_engine = u'0'
        for engine_id in ip_list_dict:
            ip_list = ip_list_dict[engine_id]
            if conn_ip in ip_list:
                current_engine = engine_id
                LOGGER.logInfo("check currentIp is in ipList: True")
                break

        flag_list, used_obj_dict = check_used_obj_on_all_nodes_in_engine(
            tmp_cli, contr_id_list, engine_id)
        all_flag_list.extend(flag_list)
        all_used_obj_dict.update(used_obj_dict)

        info_tuple = common.getEngineCtrlNodeInfo(tmp_cli, LOGGER, LANG)
        for engine_id in ip_list_dict:
            # 已检查的当前引擎。
            if current_engine == engine_id:
                continue

            flag, ret, msg, conn, exits = common.enginesJump(tmp_cli,
                                                             engine_id,
                                                             info_tuple[5],
                                                             info_tuple[3],
                                                             info_tuple[6],
                                                             PY_JAVA_ENV,
                                                             LOGGER,
                                                             LANG,
                                                             info_tuple[4])
            ALL_CLI_RET = common.joinLines(ALL_CLI_RET, ret)
            if flag is not True:
                raise UnCheckException(msg, ALL_CLI_RET)

            flag_list, used_obj_dict = check_used_obj_on_all_nodes_in_engine(
                conn, contr_id_list, engine_id)
            all_flag_list.extend(flag_list)
            all_used_obj_dict.update(used_obj_dict)

            common.enginesBack(conn, PY_JAVA_ENV, LOGGER, LANG, exits)
            LOGGER.logInfo("exit heart beat success.")

    except UnCheckException, unCheckException:
        raise UnCheckException(unCheckException.errorMsg, ALL_CLI_RET)
    finally:
        if current_ctrl_ip != conn_ip:
            common.closeSSH(tmp_cli)

    LOGGER.logInfo('All connected engine has been checked.')
    # 已经检查过的引擎
    checked_eng_id_list = ip_list_dict.keys()
    # 集群中的所有引擎
    all_eng_id_list = eng_num_dict.keys()
    not_connected_eng_id_list = [eng_id for eng_id in all_eng_id_list if eng_id not in checked_eng_id_list]
    if not_connected_eng_id_list:
        not_connected_eng_id_list.sort()
        LOGGER.logError(
            'There has not connected engine that can not be checked: ' + ','.join(not_connected_eng_id_list))
        err_msg = common.getMsg(LANG, 'dev.connEngine.failure',
                                (','.join(not_connected_eng_id_list), ','.join(not_connected_eng_id_list)))
        ALL_ERR_MSG_NO_CHECK = common.joinLines(ALL_ERR_MSG_NO_CHECK, err_msg)
        all_flag_list.append(cliUtil.RESULT_NOCHECK)
        all_flag_list = list(set(all_flag_list))
        return all_flag_list, all_used_obj_dict
    all_flag_list.append(True)
    all_flag_list = list(set(all_flag_list))
    return all_flag_list, all_used_obj_dict


def get_connection_by_contr_ip(PY_JAVA_ENV, cli):
    """
    @summary: 建立到阵列控制器的SSH连接，只有登录控制器的连接才能进入debug，minisystem模式
    """
    global ALL_CLI_RET
    current_contr_ip = PY_JAVA_ENV.get('devInfo').getIp()
    flag, err_msg, ip_list_dict = get_contr_ip_list_of_engine(cli, LANG)
    LOGGER.logInfo('controller management ip list in the engine is %s' % str(ip_list_dict))
    if flag != True:
        return False, err_msg, cli, current_contr_ip

    ip_list_list = ip_list_dict.values()
    for ip_list in ip_list_list:
        if current_contr_ip in ip_list:
            # 当前连接就是与控制器的连接（18000设备跳过SVP，PC直接连接控制器）
            LOGGER.logInfo('the current ip(%s) is controller management ip.' % str(current_contr_ip))
            return True, '', cli, current_contr_ip

    for engine in ip_list_dict:
        ip_list = ip_list_dict.get(engine)
        for ip in ip_list:
            cil_connection = common.getCilConnectionByIp(ip, PY_JAVA_ENV, LOGGER)
            if cil_connection:
                LOGGER.logInfo('Success to connect to controller(IP:%s)' % ip)
                return True, '', cil_connection, ip
            else:
                LOGGER.logInfo('Failed to connect to controller(IP:%s)' % ip)
    # 连接控制器失败。请参考预警公告手动检查。
    err_msg = common.getMsg(LANG, 'connect.to.controller.failed.hypermetro')
    return False, err_msg, cli, current_contr_ip


def get_contr_ip_list_of_engine(cli, lang):
    """
    @summary: 获取引擎对应下的控制器IP
    """
    global ALL_CLI_RET
    ip_list_dict = {}

    cmd = 'show upgrade package'
    flag, cli_ret, err_msg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        return flag, err_msg, ip_list_dict

    begin_index = cli_ret.find('Software Version')
    end_index = cli_ret.find('HotPatch Version')
    info_dict_list = cliUtil.getHorizontalCliRet(cli_ret[begin_index: end_index])

    for info_dict in info_dict_list:
        ip = info_dict.get('IP', '')
        contr_name = info_dict.get('Name', '')
        if ip != '' and contr_name != '':
            engine = contr_name[:1]
            ip_list = ip_list_dict.get(engine, [])
            ip_list.append(ip)
            ip_list_dict.update({engine: ip_list})

    # 控制器未配置管理IP，无法连接控制器。请参考预警公告手动检查。
    if len(ip_list_dict) == 0:
        err_msg = common.getMsg(LANG, 'contr.not.config.ip')
        return False, err_msg, ip_list_dict

    return True, err_msg, ip_list_dict


def check_product_info(cli):
    """
    判断产品是否满足检查的版本及型号范围
    :param cli:
    :return:
    """
    global ALL_CLI_RET
    flag, cli_ret, err_msg, product_version = common.getProductVersionByUpgradePackage(cli, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)
    flag, product_model, cli_ret, err_msg = cliUtil.getProductModelWithCliRet(cli, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        raise UnCheckException(err_msg, ALL_CLI_RET, cliUtil.RESULT_NOCHECK)
    if product_version in hypermetro_resource_check_version and product_model in hypermetro_resource_check_model:
        return True, ""
    no_support_msg = common.version_no_support_msg(
        product_model, product_version,
        hypermetro_resource_check_model, hypermetro_resource_check_version,
        LANG)
    return False, no_support_msg


def get_current_engine_ctrl_node_info(cli):
    """
    @summary: 获取除当前节点外的引擎其他健康节点信息，当前节点信息。
    @param cli: cli连接
    @return:current_ctrl_node_id,current_engine_ctrl_id_list
            current_ctrl_node_id 当前节点ID
            current_engine_ctrl_id_list 除当前节点外的引擎其他健康节点信息
    """
    global ALL_CLI_RET
    cmd = 'showsysstatus'
    # 当前节点
    current_ctrl_node_id = None
    current_engine = None
    engine_ctrl_node_mapping_dict = {}

    flag, cli_ret, err_msg = cliUtil.excuteCmdInMinisystemModel(cli, cmd, LANG)
    ALL_CLI_RET = common.joinLines(ALL_CLI_RET, cli_ret)
    if flag != True:
        LOGGER.logInfo('get node info failed. err_msg: %s' % err_msg)
        raise UnCheckException(common.getMsg(LANG, 'chunk.check.get.controller.node.failed'), ALL_CLI_RET)

    ctrl_info_dict_list = cliUtil.getVerticalCliRet(cli_ret)
    engine_info_dict_list = cliUtil.getHorizontalNostandardCliRet(cli_ret)

    for ctrl_info in ctrl_info_dict_list:
        if ctrl_info.get('local node id', '') != '':
            current_ctrl_node_id = ctrl_info.get('local node id', '')
            break

    for engine_info in engine_info_dict_list:
        engine = engine_info.get('engine', '')
        if engine == '':
            continue

        ctrl_node_id = engine_info.get('id', '')
        if ctrl_node_id == '':
            continue

        tmp_list = engine_ctrl_node_mapping_dict.get(engine, [])
        tmp_list.append(ctrl_node_id)
        engine_ctrl_node_mapping_dict[engine] = tmp_list

        if ctrl_node_id == current_ctrl_node_id:
            current_engine = engine

    # 当前引擎包含的控制器节点
    current_engine_ctrl_id_list = engine_ctrl_node_mapping_dict.get(current_engine, [])
    current_engine_ctrl_id_list.remove(current_ctrl_node_id)
    return current_ctrl_node_id, current_engine_ctrl_id_list
