# -*- coding: UTF-8 -*-

from com.huawei.ism.tool.obase.exception import ToolException

from common import UnCheckException
import cliUtil
import common
from cbb.frame.cli.cli_with_cache import execute_cmd_in_cli_mode_with_cache
import re
import traceback

LANG = common.getLang(py_java_env)
LOGGER = common.getLogger(PY_LOGGER, __file__)
PY_JAVA_ENV = py_java_env
allCliRet = ''
def execute(cli):
    '''
    @summary: chunk status check 
        1、版本包括V300R003C10SPC100且热补丁版本小于V300R003C10SPC105、
                         或者V3R5C00SPC300且无热补丁，则继续巡检；否则，巡检通过；
        2、state不等于start的每一行，若存在writechunkcnt不等于0且dirtypagecnt等于0，则巡检不通过;否则继续检查；
        3、tpnum大于170并且writetpnum大于100，则有问题风险，工具提示打补丁或者工程师介入；否则继续巡检；
        4、其他未检查的lun及非当前引擎的lun，若lunid对应的timing length小于3小时，
        则有问题风险，工具提示打补丁或者工程师介入；
    '''
    #1.版本包括V300R003C10SPC100且热补丁版本小于V300R003C10SPC105
    #或者V3R5C00SPC300且无热补丁，则继续巡检；否则，巡检通过
    global allCliRet
    errMsg = ""
    try:
        #检查是否风险版本 
        flag = isRiskVersion(cli)
        LOGGER.logInfo("is risk version : %s" % flag)
        
        #如果不是风险版本直接检查通过
        if flag == False:
            return(True, allCliRet, errMsg)
        
        #刷新进度条
        common.refreshProcess(PY_JAVA_ENV, 1, LOGGER)
        
        #是否超级管理员
        flag, cliRet, userPrivilege, errMsg = cliUtil.getUserPrivilegeWithCliRet(cli, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            raise UnCheckException(errMsg, allCliRet)
        
        if userPrivilege.lower() != 'Super_admin'.lower():
            return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, 'user.level.not.super_admin'))
        
        #获取异步远程复制全部的LUN和需要在当前引擎检查 timing length的前300个LUN
        (flag, otherLunCheckList, timingLengthPointCheckLunList, errMsg) = getLunForCheck(cli)
        if flag == cliUtil.RESULT_NOSUPPORT or len(timingLengthPointCheckLunList) == 0:
            return (True, allCliRet, '')
        
        checkCli = ''
        currentContrIp = PY_JAVA_ENV.get("devInfo").getIp()
        connectedIp = currentContrIp
        if common.is18000(PY_JAVA_ENV, cli):
            flag, errMsg, conCli, connectedIp = getConnectionByContrIp(PY_JAVA_ENV, cli)
            checkCli = conCli
            if flag == False:
                return cliUtil.RESULT_NOCHECK, allCliRet, errMsg
        else:
            checkCli = cli
            common.refreshProcess(PY_JAVA_ENV, 5, LOGGER)
        #检查前300个LUN中当前引擎的LUN timingLength是否有风险
        (isRiskLunFlag, 
         errMsg, 
         otherEngineLunList) = currEngLunTimingLengthCheck(checkCli, timingLengthPointCheckLunList)
        LOGGER.logInfo("other lun check list is %s, otherEngineLunList is %s!" % (otherLunCheckList, 
                                                                                  otherEngineLunList))
        
        if common.is18000(PY_JAVA_ENV, cli):
            if connectedIp != currentContrIp:
                common.closeSSH(checkCli)
            
        if isRiskLunFlag:
            return(False, allCliRet, errMsg)
        
        #检查非当前引擎的LUN以及300以外的LUN。
        otherLunCheckList.extend(otherEngineLunList)
        LOGGER.logInfo("merged other lun check list is %s!" % otherLunCheckList)
        if len(otherLunCheckList) == 0:
            LOGGER.logInfo("other lun check list length is 0!")
            return (True, allCliRet, '')
        
        isRiskLunFlag, errMsg = otherLunCheck(otherLunCheckList)
        LOGGER.logInfo("other lun check result is %s!" % isRiskLunFlag)
        
        #检查不通过
        if isRiskLunFlag == True:
            return(False, allCliRet, errMsg)
        
        #建议优化
        if isRiskLunFlag == cliUtil.RESULT_WARNING:
            return (cliUtil.RESULT_WARNING, allCliRet, errMsg)
        
        #检查通过
        return (True, allCliRet, '')
    
    except UnCheckException, unCheckException:
        LOGGER.logError(str(traceback.format_exc()))
        LOGGER.logInfo("UnCheckException, errMsg: %s" % unCheckException.errorMsg)
        return (cliUtil.RESULT_NOCHECK, unCheckException.cliRet, unCheckException.errorMsg)
    
    except (ToolException, Exception) as e:
        LOGGER.logError(str(e))
        return (cliUtil.RESULT_NOCHECK, allCliRet, common.getMsg(LANG, "query.result.abnormal"))
    
    finally:
        #退出到cli模式
        ret = cliUtil.enterCliModeFromSomeModel(cli, LANG)
        LOGGER.logInfo("enter cli mode from some model ret is %s" % str(ret))
        
        #退出失败后为不影响后续检查项重新连接cli
        if not ret[0]:
            common.reConnectionCli(cli, LOGGER)
        common.refreshProcess(PY_JAVA_ENV, 100, LOGGER)

def otherLunCheck(otherLunCheckList):
    '''
    @summary: 检查其他非当前引擎的LUN。包含前300个LUN中非当前引擎的LUN 和 300LUN以外的LUN。
    @param otherLunCheckList: 其他非当前引擎的LUN和 300LUN以外的LUN
    @return: (isRiskLunFlag, errMsg)
        isRiskLunFlag: 是否存在问题LUN
            True: 存在
            Flase: 不存在
            WARNING: 建议优化。
        errMsg 错误消息
    '''
    for lunInfoDict in otherLunCheckList:
        timingLength = lunInfoDict.get("Timing Length","")
        if timingLength == "" or timingLength == "--":
            LOGGER.logInfo("lunInfoDict:%s, timingLength is: %s!"%(lunInfoDict, timingLength))
            continue
        
        #步骤4获取的300个之后的lun及步骤5获取到的非当前引擎的lun，
        #若lunid对应的timing length小于等于30分钟，巡检“不通过”；
        #若timing length大于30分钟且小于3小时，有问题风险，巡检工具上报“建议优化”；
        if 'Minute' in timingLength:
            timingLengthValue = timingLength.split("Minute")[0].strip()
            timingLength = int(timingLengthValue)
            
            if timingLength <= 30:
                LOGGER.logInfo("timingLength(Minute) is not bigger than 30, no pass!")
                return (True, common.getMsg(LANG, 'chunk.check.no.pass.error.msg'))
            
            if timingLength > 30 and timingLength < 180:
                LOGGER.logInfo("timingLength(Minute) is bigger than 30 but smaller than 180, waring!")
                return (cliUtil.RESULT_WARNING, common.getMsg(LANG, 'chunk.check.pass.suggesstion.optimization.msg'))
            
        elif 'Second' in timingLength:
            timingLengthValue = timingLength.split("Second")[0].strip()
            
            timingLength = int(timingLengthValue)
            
            if timingLength <= 1800:
                LOGGER.logInfo("timingLength(Seconds) is not bigger than 30, no pass!")
                return (True, common.getMsg(LANG, 'chunk.check.no.pass.error.msg'))
            
            if 1800 < timingLength < 10800:
                LOGGER.logInfo("timingLength(Seconds) is bigger than 30 but smaller than 180, waring!")
                return (cliUtil.RESULT_WARNING, common.getMsg(LANG, 'chunk.check.pass.suggesstion.optimization.msg'))
    #检查通过
    return (False, '')

def getNodeAndLunIdListMapping(cli, timingLengthPointCheckLunList):
    '''
    @summary: 获取节点和LUN的映射关系
    @param cli: cli连接 
    @param timingLengthPointCheckLunList: 300个LUN全集，用于过滤非当前引擎的LUN 
    @return: (currentNodeId, curEngCtrlNodeLunDictList)
        currentNodeId: 当前节点
        curEngCtrlNodeLunDictList: 当前引擎全部节点和LUN的对应关系
    '''
    #查询前300个lun的lunid与lun工作控制器名称的对应关系
    ctrlLunMappingDict = getCtrlAndLunMapping(cli, timingLengthPointCheckLunList)
    LOGGER.logInfo("all controller name and LUN Mapping DICT is %s" % ctrlLunMappingDict)
    
    #如果控制器和LUN的映射关系为空返回通过。
    if len(ctrlLunMappingDict) == 0:
        LOGGER.logInfo("ctrlLunMappingDict is null!")
        return (None, {})
    
    #获取当前引擎的全部健康节点信息，当前节点信息
    (currentNodeId, currentEngineCtrlNodeIdList) = getCurrentEngineCtrlNodeInfo(cli)
    LOGGER.logInfo("currentNodeId is %s, currentEngineCtrlNodeIdList is %s!" % (currentNodeId, 
                                                                                currentEngineCtrlNodeIdList))
    
    #如果当前引擎健康的控制器节点为空，直接返回通过
    if len(currentEngineCtrlNodeIdList) == 0:
        return (currentNodeId, {})
    
    #每个控制器选择一个LUN执行命令，获取工作控制器对应的节点信息，过滤出有LUN的节点信息。
    ctrlNodeIdAndLunIdMappingDict = getCtrlNodeAndLunIdMapping(cli, ctrlLunMappingDict)
    LOGGER.logInfo("all controller node and LUN Mapping DICT is %s" % ctrlNodeIdAndLunIdMappingDict)
    #如果映射关系为空证明，当前引擎没有LUN。
    if len(ctrlNodeIdAndLunIdMappingDict) == 0:
        return (currentNodeId, {})
    
    #过滤出当前引擎的全部控制器下的LUN
    curEngCtrlNodeLunDictList = getLunDictListInCurEng(currentEngineCtrlNodeIdList, ctrlNodeIdAndLunIdMappingDict)
    LOGGER.logInfo("current Engine's controller node and LUN Mapping DICT is %s" % curEngCtrlNodeLunDictList)
    
    return (currentNodeId, curEngCtrlNodeLunDictList)
    
def currEngLunTimingLengthCheck(cli, timingLengthPointCheckLunList):
    '''
    @summary: 检查前300个LUN中归宿于当前引擎的LUN
    @param cli: cli连接 
    @param timingLengthPointCheckLunList: 300个LUN全集，用于过滤非当前引擎的LUN 
    @return: (False/True, errMsg, otherNotCheckedLunDictList)
        isRiskLunFlag: 是否存在问题LUN
            True: 存在
            Flase: 不存在。
        errMsg: 错误消息
        otherEngineLunList: 非当前引擎的LUN
    '''
    
    #获取节点和LUN的映射关系
    (currentNodeId, 
     curEngCtrlNodeLunDictList) = getNodeAndLunIdListMapping(cli, timingLengthPointCheckLunList)
    
    #如果没有获取到节点和LUN的映射或当前引擎的节点和LUN的映射都返回没有风险和全部的LUN。
    if len(curEngCtrlNodeLunDictList) == 0:
        return (False, '', timingLengthPointCheckLunList)
    
    #2.过滤出已经检查的lun
    otherNotCheckedLunDictList = filterCheckedLun(timingLengthPointCheckLunList, curEngCtrlNodeLunDictList)
    
    #定义当前引擎检查进度条总进度、每个LUN的进度
    totalLen = 1
    totalProcess = 90
    currentProcess = 5
    
    for node in curEngCtrlNodeLunDictList:
        totalLen += len(curEngCtrlNodeLunDictList[node])
    
    singleLunProcess = totalProcess/float(totalLen)
    LOGGER.logInfo("singleLunProcess is :%s, totalLen is :%s"%(singleLunProcess, totalLen))
    
    
    #检查当前控制器下的LUN
    currentCtrlLunInfoDictList = curEngCtrlNodeLunDictList.get(currentNodeId, [])
    if len(currentCtrlLunInfoDictList) != 0:
        (isRiskFlag, errMsg, currentProcess) = checkSingleCtrlLun(singleLunProcess,
                                                          currentProcess, 
                                                          cli, 
                                                          currentCtrlLunInfoDictList)
        if isRiskFlag:
            return (True, errMsg, timingLengthPointCheckLunList)

    #获取全部节点
    allCtrlNodeIdList = curEngCtrlNodeLunDictList.keys()
    if len(allCtrlNodeIdList) == 0:
        return (False, '', timingLengthPointCheckLunList)
    
    #从全部节点中移除已检查的当前节点
    if currentNodeId in allCtrlNodeIdList:
        allCtrlNodeIdList.remove(currentNodeId)
    
    #1.心跳至其他控制器检查其他控制器下的LUN
    #节点个数
    nodeCount = len(allCtrlNodeIdList)
    
    #如果检查节点为空
    if nodeCount == 0:
        LOGGER.logInfo("other controller node %s do not have lun." % nodeCount)
        common.refreshProcess(PY_JAVA_ENV, 97, LOGGER)
        return (False, '', otherNotCheckedLunDictList)
    
    (flag, errMsg) = checkOtherCtrlInCurrEng(singleLunProcess,
                                                      currentProcess,
                                                      cli, 
                                                      allCtrlNodeIdList, 
                                                      nodeCount, 
                                                      curEngCtrlNodeLunDictList)
    if flag == True:
        return (True, errMsg, otherNotCheckedLunDictList)
    #3.返回检查结果
    return (False, '', otherNotCheckedLunDictList)

def checkOtherCtrlInCurrEng(singleLunProcess, currentProcess, 
                            cli, allCtrlNodeIdList, nodeCount, ctrlNodeLunInfoMappingDict):
    '''
    @summary: 检查当前引擎其他控制器是否存在风险
    @param singleLunProcess: 单个LUN进度
    @param currentProcess: 当前进度
    @param cli: cli连接
    @param allCtrlNodeIdList: 待检查的节点
    @param nodeCount:  节点数
    @param ctrlNodeLunInfoMappingDict:  节点LUN的对应关系
    @return: (flag, errMsg)
        flag: 
            True: 有风险
            False: 无风险
        errMsg: 错误消息
    '''
    global allCliRet
    #1.4每个步骤的进度    
    for nodeId in allCtrlNodeIdList:
        lunInfoDictList = ctrlNodeLunInfoMappingDict.get(nodeId, [])
        if len(lunInfoDictList) == 0:
            LOGGER.logInfo("controller node %s do not have lun." % nodeId)
            continue
        
        #1.1心跳
        (flag, errMsg) = heartBeatToOtherCtrl(cli, nodeId)
        
        if flag != True:
            raise UnCheckException(errMsg, allCliRet)
        
        (flag, cliRet, errMsg) = cliUtil.enterDebugModeFromCliMode(cli, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        if flag != True:
            raise UnCheckException(errMsg, allCliRet) 
        try:    
            #1.2检查是否存在风险
            (isRiskFlag, errMsg, currentProcess) = checkSingleCtrlLun(singleLunProcess,
                                                          currentProcess, cli, ctrlNodeLunInfoMappingDict[nodeId])
            if isRiskFlag:
                return (True, errMsg)
        except UnCheckException, unCheckException:
            raise UnCheckException(unCheckException.errorMsg, unCheckException.cliRet)
        except Exception, exception:
            LOGGER.logException(exception)
        finally:
            cliUtil.exitHeartbeatCli(cli, LANG)
        
    return (False, '')

def getLunDictListInCurEng(currentEngineCtrlIdList, ctrlNodeIdAndLunIdMappingDict):
    '''
    @summary: 从300个全集里过滤出当前引擎下的控制器上待检查的LUN。
    @param currentEngineCtrlIdList: 当前引擎控制器ID列表
    @param ctrlNodeIdAndLunIdMappingDict: 全部300个LUN和控制器nodeId的对应关系。
    @return: curEngCtrlNodeLunDictList 返回过滤结果
    '''
    curEngCtrlNodeLunDictList = {}
    for nodeId in currentEngineCtrlIdList:
        tmpList = ctrlNodeIdAndLunIdMappingDict.get(nodeId, [])
        if len(tmpList) == 0:
            continue
        curEngCtrlNodeLunDictList[nodeId] = tmpList
    return curEngCtrlNodeLunDictList

def filterCheckedLun(allLunList, curEngCtrlNodeLunDictList):
    '''
    @summary: 过滤非当前引擎的LUN
    @param allLun: 全部的LUN
    @param checkedLun: 当前引擎已经检查的LUN  
    @return: otherLunDictList 非当前引擎的的LUN
    '''
    
    otherLunDictList = []
    tmpLunIdList = []
    for nodeId in curEngCtrlNodeLunDictList:
        tmpList = curEngCtrlNodeLunDictList.get(nodeId, [])
        if len(tmpList) == 0:
            continue
        
        tmpLunIdList.extend(tmpList)
        
    for lun in allLunList:
        lunId = lun.get('Local LUN ID', '')
        if lunId == '':
            continue
        
        if lunId not in tmpLunIdList:
            otherLunDictList.append(lun)
            
    return otherLunDictList
        
def heartBeatToOtherCtrl(cli, nodeId):
    '''
    @summary: 心跳至指定节点
    @param cli: cli连接
    @param nodeId: 控制器节点ID
    @return: (flag, errMsg)
        flag:
            True: 命令执行成功
            False: 命令执行失败
        errMsg: 错误消息
    '''
    global allCliRet
    priKey = PY_JAVA_ENV.get("devInfo").getPriKey()
    if priKey:
        #不支持PublicKey鉴权方式进行心跳控制器
        errMsg = common.getMsg(LANG, "no.support.publickey.forensics")
        return (False, errMsg)
    
    cmd = "sshtoremoteExt %s" % str(nodeId)
    passWord = PY_JAVA_ENV.get("devInfo").getLoginUser().getPassword()
    
    flag, cliRet, errMsg = cliUtil.sshToRemoteContr(cli, cmd, passWord, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        LOGGER.logInfo("heart beat to other node Failed. errMsg: %s" % errMsg)
        raise UnCheckException(common.getMsg(LANG, "heart.beat.to.node.failed", nodeId), allCliRet)
    #删除本地密码
    del passWord
    
    return (flag, errMsg)
    
def checkSingleCtrlLun(singleLunProcess, currentProcess, cli, lunIdList):
    '''
    @summary: 检查当前控制器下的LUN
    @param singleLunProcess: 单个LUN进度
    @param currentProcess: 当前进度
    @param cli: cli连接
    @param lunIdList: lun id list 信息字典列表
    @return: (True/False, errMsg, currentProcess)
        flag:
            True: 有风险
            False: 没有风险
        errMsg: 错误消息
        currentProcess: 当前进度
    '''
    global allCliRet
    #初始记录一个LUN的进度，如果进度小于1不更新叠加到1后才更新。
    nodeProcess = singleLunProcess
    for lunId in lunIdList:
        #每个控制器都需要单独再查归属控制器为自己的LUN信息，
        #步骤9 执行如下命令：devlun showctrl [lunid]，获取lun的datavolumeid(volid)、currenttimepoint(curtp)信息，
        #其中lunid为工作在当前控制器的lu
        lunInfoDict = getSingleLunVolumeInfo(cli, lunId)
        if not lunInfoDict:
            continue
        
        volumeId = lunInfoDict['volumeId']
        currentPoint = int(lunInfoDict['currentTimePoint'])
        startPoint = 0
        if currentPoint >= 170:
            startPoint = currentPoint - 170
            
        cmd = 'cache show timepoint %s %s %s' % (volumeId, startPoint, currentPoint)
        flag, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        
        if flag != True:
            LOGGER.logInfo("excute cache show timepoint Failed. errMsg: %s" % errMsg)
            raise UnCheckException(common.getMsg(LANG, "chunk.check.getlun.info.failed", lunId), allCliRet)

        lunTimePointInfoDictList = cliUtil.getHorizontalCliRet(cliRet)
        if len(lunTimePointInfoDictList) == 0:
            LOGGER.logInfo("lunId is %s has no timepoint." % lunId)
            continue
        
        writeTpNumber = 0
        LOGGER.logInfo("lunTimePointInfoDictList: %s" % lunTimePointInfoDictList)
        for lunTimePointInfo in lunTimePointInfoDictList:
            state = lunTimePointInfo.get("state", '')
            if state == '':
                continue
            
            dirtyPageCnt = lunTimePointInfo.get("dirtyPageCnt", '')
            if dirtyPageCnt == '':
                continue
            
            writeChunkCnt = lunTimePointInfo.get("writeChunkCnt", '')
            if writeChunkCnt == '' or not writeChunkCnt.isdigit():
                continue
            
            #步骤10获取的state不等于start的每一行，若存在writechunkcnt不等于0且dirtypagecnt等于0，巡检“不通过”；否则继续检查；
            if state != 'start' and writeChunkCnt != '0' and dirtyPageCnt == '0':
                LOGGER.logInfo("risk lun time point: %s" % lunTimePointInfo)
                return (True, common.getMsg(LANG, 'chunk.check.no.pass.error.msg'), currentProcess) 
            
            if writeChunkCnt != '0':
                writeTpNumber += 1
        
        if nodeProcess > 1:
            currentProcess += int(nodeProcess)
            nodeProcess = singleLunProcess
            common.refreshProcess(PY_JAVA_ENV, currentProcess, LOGGER)
        else:
            nodeProcess += singleLunProcess
        
        #找到 There is '12' timepoint(s):中的12
        tempStrList = re.finditer(r"There is '\d+'" , cliRet)
        tempTimePStr = ''
        for tempStr in tempStrList:
            tempTimePStr = tempStr.group()
        if tempTimePStr == '':
            continue
        
        tempTimePStrList = tempTimePStr.split("'")
        if len(tempTimePStrList) >= 2:
            timePointNum = tempTimePStrList[1]
        
        if timePointNum == '' or not timePointNum.isdigit():
            continue
        
        timePointNum = int(timePointNum)
        LOGGER.logInfo("timePointNum is %s, writeTpNumber is : %s" % (timePointNum, writeTpNumber))
        #判断标准 3、步骤10获取的tpnum大于170并且writetpnum大于100，巡检“不通过”；否则继续巡检；
        if timePointNum > 170 and writeTpNumber > 100:
            LOGGER.logInfo("timePointNum is: %s, writeTpNumber is %s, check no pass." % (timePointNum, writeTpNumber))
            return (True, common.getMsg(LANG, 'chunk.check.no.pass.error.msg'), currentProcess)
        
    #如果都检查完成，则不存在风险    
    return (False, '', currentProcess)
    
def getSingleLunVolumeInfo(cli, lunId):
    '''
    @summary: 获取单个LUN详细信息
    @param cli: cli连接
    @param lunId: lunId 待检查的lunId
    @return: lunInfoDict
        lunInfoDict: 详细信息结果
    '''
    global allCliRet
    cmd = "devlun showctrl %s" % lunId
    flag, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        LOGGER.logInfo("excute devlun showctrl Failed. errMsg: %s"%errMsg)
        raise UnCheckException(common.getMsg(LANG, "chunk.check.getlun.info.failed", lunId), allCliRet)
    
    lunInfoDictList = cliUtil.getVerticalCliRet(cliRet)
    if len(lunInfoDictList) == 0:
        return dict()
    
    volumeId = lunInfoDictList[0].get("Data Volume ID", "")
    if volumeId == "":
        return dict()
    
    currentTimePoint = lunInfoDictList[0].get("Current Time Point", "")
    if currentTimePoint == "":
        return dict()
    
    if currentTimePoint == "--":
        return dict()
    
    lunInfoDict = {
                   "volumeId":volumeId, 
                   "currentTimePoint":currentTimePoint, 
                   "lunId":lunId
                   }
    
    return lunInfoDict
    
def getCtrlNodeAndLunIdMapping(cli, ctrlLunMappingDict):
    '''
    @summary: 获取获取控制器节点和LUN ID的对应关系,如果某个控制器没有lun，继续检查。
    @param cli: cli连接 
    @param ctrlLunMappingDict: 控制器名称和LUN ID的映射关系
    @return: ctrlNodeIdAndLunIdMappingDict
        ctrlNameNodeIdMappingDict: 控制器节点和LUN ID的对应关系
    '''
    global allCliRet
    ctrlNodeIdAndLunIdMappingDict = {}
    for ctrlName in ctrlLunMappingDict:
        lunIdList = ctrlLunMappingDict[ctrlName]
        if len(lunIdList) == 0:
            continue
        
        lunId = lunIdList[0]
        cmd = "devlun showctrl %s" % lunId
        flag, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
        allCliRet = common.joinLines(allCliRet, cliRet)
        
        if flag != True:
            LOGGER.logInfo("execute devlun showctrl Failed. errMsg: %s." % errMsg)
            raise UnCheckException(common.getMsg(LANG, "chunk.check.getlun.info.failed", lunId), allCliRet)
        
        lunInfoDictList = cliUtil.getVerticalCliRet(cliRet)
        if len(lunInfoDictList) == 0:
            raise UnCheckException(common.getMsg(LANG, "chunk.check.getlun.info.failed", lunId), allCliRet)
        
        workCtrlNodeId = lunInfoDictList[0].get("Work Controller ID","")
        if workCtrlNodeId == "":
            raise UnCheckException(common.getMsg(LANG, "chunk.check.getlun.info.failed", lunId), allCliRet)
        
        ctrlNodeIdAndLunIdMappingDict[workCtrlNodeId] = lunIdList
        
    return ctrlNodeIdAndLunIdMappingDict
        
    
def getCurrentEngineCtrlNodeInfo(cli):
    '''
    @summary: 获取当前引擎的全部健康节点信息，当前节点信息。
    @param cli: cli连接 
    @return: (currentCtrlNodeId, currentEngineCtrlIdList)
        currentNodeId: 当前节点ID
        currentEngineCtrlIdList: 当前引擎的全部健康节点信息
    '''
    global allCliRet
    #获取当前节点信息，当前引擎的全部节点信息。
    cmd = 'sys showcls'
    #当前节点
    currentCtrlNodeId = None
    currentEngine = None
    engineCtrlNodeMappingDict = {}
    
    flag, cliRet, errMsg = cliUtil.excuteCmdInDebugModel(cli, cmd, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        LOGGER.logInfo("get node info Failed. errMsg: %s" % errMsg)
        raise UnCheckException(common.getMsg(LANG, "chunk.check.get.controller.node.failed"), allCliRet)

    ctrlInfoDictList = cliUtil.getVerticalCliRet(cliRet)
    engineInfoDictList = cliUtil.getHorizontalNostandardCliRet(cliRet)
    
    for ctrlInfo in ctrlInfoDictList:
        if ctrlInfo.get("local node id", "") != "":
            currentCtrlNodeId = ctrlInfo.get("local node id","")
            break
    if not currentCtrlNodeId:
        LOGGER.logInfo("get node info Failed.")
        raise UnCheckException(common.getMsg(LANG, "chunk.check.getlun.info.failed"), allCliRet)
        
    for engineInfo in engineInfoDictList:
        engine = engineInfo.get("engine","")
        if engine == "":
            continue
        
        status = engineInfo.get("status","")
        if status == "" or status != "normal":
            continue
        
        ctrlNodeId = engineInfo.get("id", "")
        if ctrlNodeId == "":
            continue
        
        tmpList = engineCtrlNodeMappingDict.get(engine, [])
        tmpList.append(ctrlNodeId)
        engineCtrlNodeMappingDict[engine] = tmpList
        
        if ctrlNodeId == currentCtrlNodeId:
            currentEngine = engine
    
    #当前引擎包含的控制器节点
    currentEngineCtrlIdList = engineCtrlNodeMappingDict.get(currentEngine, [])
    return (currentCtrlNodeId, currentEngineCtrlIdList)
    
def getCtrlAndLunMapping(cli, timingLengthPointCheckLunList):
    '''
    @summary: 查询前300个lun的lunid与lun工作控制器名称的对应关系
    @param timingLengthPointCheckLunList: 前300个lun的信息列表
    @return: ctrlLunMappingDict 
        ctrlLunMappingDict: lunid与lun工作控制器名称字典
    '''
    global allCliRet
    #查询前300个lun的lunid与lun工作控制器名称的对应关系

    ctrlLunMappingDict = {} 
    lunIdList = []
    lun_info_list = []
    cli_ret_list = []
    for lun in timingLengthPointCheckLunList:
        lunId = lun.get("Local LUN ID", "")
        if not lunId:
            continue

        lunIdList.append(lunId)

        cmd = "show lun general lun_id=%s" % lunId
        flag, cli_ret, msg = execute_cmd_in_cli_mode_with_cache(PY_JAVA_ENV,
                                                                cli, cmd,
                                                                LOGGER)

        cli_ret_list.append(cli_ret)
        if flag is not True:
            allCliRet = common.joinLines(allCliRet, "\n".join(cli_ret_list))
            raise UnCheckException(msg, allCliRet)

        lun_info = cliUtil.getVerticalCliRet(cli_ret)
        lun_info_list.extend(lun_info)

    allCliRet = common.joinLines(allCliRet, "\n".join(cli_ret_list))
    #获取待检查LUN和控制器的对应关系。
    for lunCtrlPair in lun_info_list:
        workCtrlName = lunCtrlPair.get("Work Controller", "")
        if workCtrlName == "":
            continue
        
        lunId = lunCtrlPair.get("ID", "")
        if lunId == "":
            continue
        
        lunIdList = ctrlLunMappingDict.get(workCtrlName, [])
        lunIdList.append(lunId)
        
        ctrlLunMappingDict[workCtrlName] = lunIdList
    
    return ctrlLunMappingDict
    
def getLunForCheck(cli):
    '''
    @summary: 查询异步远程复制lun。
    @param cli: cli连接
    @param LANG: 中英文环境。 
    @return: (flag, otherLunCheckList, timingLengthPointCheckLunList, errMsg)
        flag:
            True: 获取到Lun信息
            RESULT_NOSUPPORT: 没有licence
        otherLunInfoDictList: 300个LUN之外的LUN
        preCheckLunInfoDictList: 需要在当前引擎检查 timing length的前300个LUN。
        errMsg:错误原因
    '''
    
    global allCliRet
    #300以外的LUN
    otherLunInfoDictList = []
    
    #需要在当前引擎检查 timing length的前300个LUN。
    preCheckLunInfoDictList = []
    
    (flag, cliRet, errMsg) = cliUtil.enterDeveloperMode(cli, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        raise UnCheckException(errMsg, allCliRet) 
    
    cmd = r'''show remote_replication general |filterRow column=Is\sPrimary predict=equal_to value=Yes logicOp=and column=Replication\sMode predict=equal_to value=Asynchronous logicOp=and column=Timing\sLength predict=not predict2=equal_to value=-- |filterColumn include columnList=Local\sLUN\sID,Timing\sLength'''
    flag, cliRet, errMsg = cliUtil.excuteCmdInDeveloperMode(cli, cmd, True, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    
    if flag == False or flag == cliUtil.RESULT_NOCHECK: 
        LOGGER.logInfo("Failed to get information about remote replication asynchronous lun. errMsg: %s"%errMsg)
        raise UnCheckException(common.getMsg(LANG, "chunk.check.getremote.asynchronous.lun.info.failed"), allCliRet)
    
    #如果没有licence
    elif flag == cliUtil.RESULT_NOSUPPORT:
        return (cliUtil.RESULT_NOSUPPORT, otherLunInfoDictList, preCheckLunInfoDictList, errMsg)
    
    elif cliUtil.queryResultWithNoRecord(cliRet):
        return (True, otherLunInfoDictList, preCheckLunInfoDictList, errMsg)
    
    allCheckLunInfoDictList = cliUtil.getHorizontalNostandardCliRet(cliRet)
    
    LOGGER.logInfo("all check lun id is:%s!" % allCheckLunInfoDictList)
    
    #前300个LUN
    preCheckLunInfoDictList = allCheckLunInfoDictList[0:300]
    
    #其于LUN
    otherLunInfoDictList = allCheckLunInfoDictList[300:]
    
    LOGGER.logInfo("otherLunInfoDictList is: %s !" % otherLunInfoDictList)
    
    return (True, otherLunInfoDictList, preCheckLunInfoDictList, errMsg)
    
def isRiskVersion(cli):
    '''
    @summary: 检查软件版本是否有问题
    @param cli: cli回显 
    @attention: 问题版本：V300R003C10SPC100
                V300R003C10SPC100+V300R003C10SPH101
                V300R003C10SPC100+V300R003C10SPH102
                V300R005C00SPC300
    @return: (True/False, cliRet)
        Flag:
            True: 问题版本
            False: 非问题版本
    '''
    
    global allCliRet
    #获取版本信息
    (succFlag, cliRet, errMsg), softwareVersionList, hotPatchVersionList= common.parse_upgradePackage(cli, LANG)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if succFlag != True:
        LOGGER.logInfo("get package info fail!")
        raise UnCheckException(errMsg, cliRet)
    
    flag, productVersion, errMsg = common.getCurrentVersion(softwareVersionList, LANG)
    if flag != True:
        LOGGER.logInfo("get current product version error. errMsg: %s"%errMsg)
        raise UnCheckException(errMsg, allCliRet)
    
    #如果不是黑名单，直接通过。
    productVersion = productVersion.strip()
    if productVersion != "V300R003C10SPC100" and productVersion != "V300R005C00SPC300":
        LOGGER.logInfo("the product is not V300R003C10SPC100 V300R005C00SPC300 checked pass.")
        return False

    #检查补丁版本信息,如果大于V300R003C10SPH105,则不存在风险
    flag, hotPatchVersion, errMsg = common.getHotPatchVersion(hotPatchVersionList, LANG)
    if flag != True:
        raise UnCheckException(errMsg, allCliRet)
    
    hotPatchVersion = hotPatchVersion.strip()
    
    if productVersion == "V300R003C10SPC100" and hotPatchVersion >= "V300R003C10SPH105":
        LOGGER.logInfo("V300R003C10SPC100 hot patch version is bigger than V300R003C10SPH105 checked pass.")
        return False
    
    #检查补丁版本信息,V300R005C00SPC300如果有补丁版本则不存在风险。
    if productVersion == "V300R005C00SPC300" and hotPatchVersion != "--" and hotPatchVersion != "":
        LOGGER.logInfo("V300R005C00SPC300 hot patch version is not null checked pass.")
        return False
    
    return True

def getConnectionByContrIp(PY_JAVA_ENV, cli):
    """
    @summary: 建立到阵列控制器的SSH连接，只有登录控制器的连接才能进入debug，minisystem模式
    """
    currentContrIp = PY_JAVA_ENV.get("devInfo").getIp()
    connectedIP = currentContrIp
    
    flag, errMsg, ipListDict = getContrIpListOfEngine(cli, LANG)
    LOGGER.logInfo('controller management ip list in the engine is %s' % str(ipListDict))
    if flag != True:
        return (False, errMsg, cli, connectedIP)
    
    ipListList = ipListDict.values()
    for ipList in ipListList:
        if currentContrIp in ipList:
            connectedIP = currentContrIp
            #当前连接就是与控制器的连接（18000设备跳过SVP，PC直接连接控制器）
            LOGGER.logInfo('the current ip(%s) is controller management ip.' % str(currentContrIp))
            common.refreshProcess(PY_JAVA_ENV, 5, LOGGER)
            return (True, "", cli, connectedIP)
    
    #连接进度条总数5
    currentProcess = 1
    totalLen = 1
    
    for engine in ipListDict:
        totalLen += len(ipListDict.get(engine))
    if totalLen > 1:
        totalLen -= 1
    singleProcess = 4/float(totalLen)    
    nodeProcess = singleProcess
    for engine in ipListDict:
        ipList = ipListDict.get(engine)
        for ip in ipList:
            cilConnection = common.getCilConnectionByIp(ip, PY_JAVA_ENV, LOGGER)
            
            if nodeProcess >= 1:
                currentProcess += int(nodeProcess)
                common.refreshProcess(PY_JAVA_ENV, currentProcess, LOGGER)
                nodeProcess = singleProcess
            else:
                nodeProcess += singleProcess
            LOGGER.logInfo('currentProcess is :%s , singleProcess is %s, totalLen is %s' % (currentProcess, singleProcess, totalLen))
            if cilConnection:
                connectedIP = ip
                LOGGER.logInfo('Success to connect to controller(IP:%s)' % ip)
                common.refreshProcess(PY_JAVA_ENV, 5, LOGGER)
                return (True, "", cilConnection, connectedIP)
            else:
                LOGGER.logInfo('Failed to connect to controller(IP:%s)' % ip)
    #连接控制器失败。请参考预警公告手动检查。
    errMsg = common.getMsg(LANG, "chunk.check.connect.to.controller.failed")
    return (False, errMsg, cli, connectedIP)

def getContrIpListOfEngine(cli, lang):
    """
    @summary: 获取引擎对应下的控制器IP
    """
    global allCliRet
    
    ipListDict = {}
    
    cmd = "show upgrade package"
    flag, cliRet, errMsg = cliUtil.excuteCmdInCliMode(cli, cmd, True, lang)
    allCliRet = common.joinLines(allCliRet, cliRet)
    if flag != True:
        return (flag, errMsg, ipListDict)
    
    beginIndex = cliRet.find("Software Version")
    endIndex = cliRet.find("HotPatch Version")
    infoDictList = cliUtil.getHorizontalCliRet(cliRet[beginIndex : endIndex])
    
    for infoDict in infoDictList:
        ip = infoDict.get("IP", "")
        contrName = infoDict.get("Name", "")
        if ip != "" and contrName != "":
            engine = contrName[:1]
            ipList = ipListDict.get(engine, [])
            ipList.append(ip)
            ipListDict.update({engine:ipList})
    
    #控制器未配置管理IP，无法连接控制器。请参考预警公告手动检查。
    if len(ipListDict) == 0:
        errMsg = common.getMsg(LANG, "contr.not.config.ip")
        return (False, errMsg, ipListDict)
    
    return (True, errMsg, ipListDict)
